/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pipeline.progress;

import com.ibm.smarts.pipeline.constants.ExecutionStatus;
import java.util.Collections;
import java.util.List;

public class TaskStatus {
    private ExecutionStatus status = ExecutionStatus.NOT_STARTED;
    private List<String> errors;
    private List<String> warnings;
    private List<String> dataSourceExceptions;

    public TaskStatus(ExecutionStatus status) {
        this.status = status;
    }

    public TaskStatus(List<String> errors, List<String> warnings, List<String> dataSourceExceptions) {
        this.errors = errors;
        this.warnings = warnings;
        this.dataSourceExceptions = dataSourceExceptions;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExecutionStatus status) {
        this.status = status;
    }

    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings == null ? Collections.emptyList() : this.warnings;
    }

    public List<String> getDataSourceExceptions() {
        return this.dataSourceExceptions == null ? Collections.emptyList() : this.dataSourceExceptions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Status: ").append(this.status.toString()).append("\n\nErrors:\n\n");
        if (this.errors != null) {
            for (String error : this.errors) {
                builder.append(error).append("\n");
            }
        }
        builder.append("\n\nWarnings:\n\n");
        if (this.warnings != null) {
            for (String warning : this.warnings) {
                builder.append(warning).append("\n");
            }
        }
        builder.append("\n\nData source exceptions:\n\n");
        if (this.dataSourceExceptions != null) {
            for (String dataSourceException : this.dataSourceExceptions) {
                builder.append(dataSourceException).append("\n");
            }
        }
        return builder.toString();
    }
}

