/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.questionanalyzer.core.interpretation;

import com.ibm.smarts.questionanalyzer.core.interpretation.Interpretation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class InterpretationBoard {
    private List<Interpretation> mActiveInterpretations;
    private final String mQuestion;

    public InterpretationBoard(String question) {
        this.mQuestion = question;
        this.mActiveInterpretations = new ArrayList<Interpretation>();
    }

    public String getQuestion() {
        return this.mQuestion;
    }

    public List<Interpretation> getInterpretations() {
        return this.mActiveInterpretations;
    }

    public void setActiveInterpretations(List<Interpretation> interpretations) {
        this.mActiveInterpretations = interpretations;
        Collections.sort(this.mActiveInterpretations, new Comparator<Interpretation>(){

            @Override
            public int compare(Interpretation o1, Interpretation o2) {
                if (o1.getScore().floatValue() > o2.getScore().floatValue()) {
                    return 1;
                }
                if (o1.getScore() == o2.getScore()) {
                    return 0;
                }
                return -1;
            }
        });
    }

    public Interpretation getBestInterpretation() {
        int size = this.mActiveInterpretations.size();
        if (size == 0) {
            return null;
        }
        return this.mActiveInterpretations.get(size - 1);
    }

    public Interpretation removeInterpretation(int i) {
        if (this.mActiveInterpretations == null || this.mActiveInterpretations.size() == 0 || this.mActiveInterpretations.size() < i) {
            return null;
        }
        return this.mActiveInterpretations.remove(i);
    }
}

