/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.combinations.generator.util;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.combinations.generator.exceptions.ColumnNotFoundException;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static List<String> toColumnIDs(List<IDataColumn> columns) {
        ArrayList<String> columnIds = new ArrayList<String>();
        for (IDataColumn c : columns) {
            columnIds.add(c.getIdForExpression());
        }
        return columnIds;
    }

    public static Set<String> toUniqueDatasetIDS(Set<String> uniqueIds, SmartsModule smartsModule) throws ColumnNotFoundException {
        LinkedList<String> columnIds = new LinkedList<String>(uniqueIds);
        HashSet<String> dataSetIds = new HashSet<String>();
        smartsModule.getDatasets().forEach(dataSet -> SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataSet).forEach(column -> {
            if (columnIds.contains(column.getIdForExpression())) {
                dataSetIds.add(dataSet.getId());
                columnIds.remove(column.getIdForExpression());
            }
        }));
        if (!columnIds.isEmpty()) {
            throw new ColumnNotFoundException("These columns were not found: " + ((Object)columnIds).toString());
        }
        return dataSetIds;
    }
}

