/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.combinations.generator.validator.spi;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.combinations.generator.validator.spi.Validator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class ValidatorService {
    private static ValidatorService v = null;
    private ServiceLoader<Validator> loader = ServiceLoader.load(Validator.class);

    private ValidatorService() {
    }

    public static synchronized ValidatorService getInstance() {
        if (v == null) {
            v = new ValidatorService();
        }
        return v;
    }

    public boolean hasValidators() {
        return this.loader.iterator().hasNext();
    }

    public synchronized boolean validate(List<IDataColumn> combination) {
        boolean valid = false;
        try {
            Iterator<Validator> validators = this.loader.iterator();
            while (!valid && validators.hasNext()) {
                Validator validator = validators.next();
                valid = validator.validate(combination);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            valid = false;
            serviceError.printStackTrace();
        }
        return valid;
    }
}

