/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.builder.tasks;

import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.QGEncodedSamplesContainer;
import com.ibm.smarts.question.generator.core.util.QuestionGeneratorCoreUtil;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.store.api.provider.IObjectStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QGSamplesEncodingTaskImpl {
    private final Logger LOGGER = LoggerFactory.getLogger(QGSamplesEncodingTaskImpl.class);
    public static final String QG_SAMPLE_ENCODING_TASK_ID = "smarts.question.generator.qgSampleEncoding";
    private static final String QG_SAMPLE_ENCODING_TASK_NAME = "QGSampleEncoding";
    private static final String QG_SAMPLE_ENCODING_TASK_DESCRIPTION = "Encodes the samples for the question generation.";

    public void execute(SmartsTaskContext taskContext) throws InternalException {
        String smartsId = taskContext.getSmartsModuleId();
        String dataSetId = taskContext.getDatasetId();
        PerformanceLogger.get().info((Object)(smartsId + "." + dataSetId));
        RequestContext requestContext = taskContext.getRequestContext();
        IStoreProvider storeProvider = taskContext.getStoreProvider();
        String taskId = QG_SAMPLE_ENCODING_TASK_ID;
        SmartsModule smartsModule = storeProvider.getModuleStore(requestContext).getSmartsModulePart(smartsId, dataSetId);
        if (smartsModule == null) {
            this.LOGGER.error("SmartsModule not found for id: {}.", (Object)smartsId);
            throw new InternalException("SmartsModule not found for id: {0}.", new Object[]{smartsId});
        }
        IObjectStore qgEncodedSamplesContainerObjectStore = storeProvider.getObjectStore();
        QGEncodedSamplesContainer qgEncodedSamplesContainer = (QGEncodedSamplesContainer)qgEncodedSamplesContainerObjectStore.get(smartsId);
        if (qgEncodedSamplesContainer == null) {
            this.LOGGER.error("QGEncodedSamplesContainer not found for: {}.", (Object)smartsId);
            throw new InternalException("QGEncodedSamplesContainer not found for {0}", new Object[]{smartsId});
        }
        DatasetInfo datasetInfo = smartsModule.getDatasets().stream().filter(ds -> ds.getId().equals(dataSetId)).findAny().orElse(null);
        if (datasetInfo == null) {
            this.LOGGER.error("DataSet not found for the id: {}.", (Object)dataSetId);
            throw new InternalException("DataSet not found for the id: {0}.", new Object[]{dataSetId});
        }
        List columns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo);
        if (SmartsModuleUtil.logMissingData((String)smartsId, (String)datasetInfo.getId(), (List)columns, (String)taskId)) {
            this.LOGGER.error("Missing sample data for dataSetId: {}.", (Object)dataSetId);
            throw new InternalException("Missing sample data for dataSetId: {0}.", new Object[]{dataSetId});
        }
        List generatedEncodedSamples = QuestionGeneratorCoreUtil.encodeSamples((DatasetInfo)datasetInfo);
        List inheritedEncodedSamples = (List)qgEncodedSamplesContainer.getDataSetEncodedSamples().get(dataSetId);
        if (inheritedEncodedSamples != null && !inheritedEncodedSamples.isEmpty()) {
            SmartsModuleUtil.appendFilteredEncodedSamples((List)generatedEncodedSamples, (List)inheritedEncodedSamples);
        }
        qgEncodedSamplesContainer.getDataSetEncodedSamples().put(dataSetId, generatedEncodedSamples);
        PerformanceLogger.get().info((Object)(smartsId + "." + dataSetId));
    }
}

