/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.commons.messages.CommonsRuntimeException;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.ResponseUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.ws.rs.core.Response;

public class MoserException
extends CommonsRuntimeException {
    private static final long serialVersionUID = 9108354034952058966L;
    protected int httpStatus = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();

    public MoserException(Throwable e) {
        super(e, new Message(MoserError.INTERNAL_ERROR));
    }

    public MoserException(IMessageKey.Param0 key, Throwable e) {
        super(e, new Message(key));
    }

    public MoserException(IMessageKey.Param1 key, String arg1, Throwable e) {
        super(e, new Message(key, (Object)arg1));
    }

    public MoserException(IMessageKey.Param2 key, String arg1, String arg2, Throwable e) {
        super(e, new Message(key, (Object)arg1, (Object)arg2));
    }

    public MoserException(IMessageKey.Param0 key) {
        super(new Message(key));
    }

    public MoserException(IMessageKey.Param1 key, String arg1) {
        super(new Message(key, (Object)arg1));
    }

    public MoserException(IMessageKey.Param2 key, String arg1, String arg2) {
        super(new Message(key, (Object)arg1, (Object)arg2));
    }

    public MoserException(IMessageKey.Param3 key, String arg1, String arg2, String arg3) {
        super(new Message(key, (Object)arg1, (Object)arg2, (Object)arg3));
    }

    public int getHTTPStatusCode() {
        return this.httpStatus;
    }

    public MoserException setHTTPStatus(int status) {
        this.httpStatus = status;
        return this;
    }

    public JSONObject getJSONApiEntity(Locale locale) {
        JSONObject error = new JSONObject();
        error.put((Object)"status", (Object)Integer.toString(this.getHTTPStatusCode()));
        error.put((Object)"title", (Object)this.getLocalizedMessage(locale));
        error.put((Object)"code", (Object)this.getErrorCode());
        if (this.getCause() != null) {
            error.put((Object)"details", (Object)this.getCause().getLocalizedMessage());
        }
        JSONObject meta = new JSONObject();
        meta.put((Object)"severity", (Object)"error");
        meta.put((Object)"response", this.getRESTResponseEntity(locale));
        error.put((Object)"meta", (Object)meta);
        JSONArray errors = new JSONArray();
        errors.add((Object)error);
        JSONObject response = new JSONObject();
        response.put((Object)"errors", (Object)errors);
        return response;
    }

    public Response getJSONApiResponse(Locale locale) {
        return ResponseUtils.getResponse(this.getHTTPStatusCode(), (Object)this.getJSONApiEntity(locale));
    }

    public Object getRESTResponseEntity(Locale locale) {
        JSONObject response = new JSONObject();
        response.put((Object)"msg", (Object)this.getLocalizedMessage(locale));
        response.put((Object)"code", (Object)this.getErrorCode());
        if (this.getCause() != null) {
            response.put((Object)"exceptionCauseMsg", (Object)this.getCause().getLocalizedMessage());
        }
        return response;
    }

    public Response getResponse(Locale locale) {
        return ResponseUtils.getResponse(this.getHTTPStatusCode(), this.getRESTResponseEntity(locale));
    }
}

