/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.core.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.smarts.store.api.config.TypeName;
import com.ibm.smarts.store.core.types.StoreLocale;
import java.util.Map;

public class Type {
    private final TypeName typeName;
    private final String esType;
    private final String baseIndex;
    private final Map<String, StoreLocale> locales;

    @JsonCreator
    public Type(@JsonProperty(value="typeName") TypeName typeName, @JsonProperty(value="esType") String esType, @JsonProperty(value="esBaseIndex") String baseIndex, @JsonProperty(value="locale") Map<String, StoreLocale> locales) {
        this.typeName = typeName;
        this.esType = esType;
        this.baseIndex = baseIndex;
        this.locales = locales;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public String getEsType() {
        return this.esType;
    }

    public String getBaseIndex() {
        return this.baseIndex;
    }

    @JsonIgnore
    public String getIndex(String locale) {
        try {
            return this.getIndexInternal(locale);
        }
        catch (NullPointerException e) {
            return this.getIndexInternal("en");
        }
    }

    protected String getIndexInternal(String locale) {
        StoreLocale sl = this.locales.get(locale);
        return this.baseIndex + "_" + sl.getIndexPostfix();
    }

    public Map<String, StoreLocale> getLocales() {
        return this.locales;
    }

    @JsonIgnore
    public String getSchema(String locale) {
        return this.getLocaleMapping(locale).toString();
    }

    public ObjectNode getLocaleMapping(String locale) {
        try {
            return this.locales.get(locale).getTemplate();
        }
        catch (NullPointerException e) {
            return this.locales.get("en").getTemplate();
        }
    }
}

