/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.rest;

import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.smarts.ca.api.SmartsCaSystem;
import com.ibm.smarts.ca.core.rest.client.BIRestClientConfigInfo;
import com.ibm.smarts.ca.core.rest.server.AbstractCaRestServiceContextListener;
import com.ibm.smarts.ca.rest.SmartsCaRestServer;
import com.ibm.smarts.ca.rest.handlers.SmartsCaBaseRestApi;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.rest.server.AbstractRestServer;
import com.ibm.smarts.core.rest.server.IRestEngineBuilder;
import com.ibm.smarts.system.rest.handlers.SystemBaseRestApi;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;

@WebListener
public class SmartsCaRestServiceContextListener
extends AbstractCaRestServiceContextListener {
    public static final String CONFIG_PATH = "/configSmarts.properties";
    public static final String SMARTS_CA_SERVICE_ID = "SmartsCaService";
    private static SmartsCaSystem system = null;
    public static Properties __injectedConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        block9: {
            systemLogger.info("Initializing Smarts-CA...");
            super.contextInitialized(event);
            try {
                if (SmartsCaRestServiceContextListener.getServer() != null) break block9;
                RESTClientFactory.getInstance().startup();
                Properties config = __injectedConfig != null ? __injectedConfig : SmartsCaRestServiceContextListener.resolveProperties((Properties)caConfig);
                systemLogger.info("SmartsCaRestServer config: " + config);
                String caLogsPath = config.getProperty("smarts.core.logsFolder");
                this.createSmartsLogsFolder(caLogsPath);
                if (Boolean.parseBoolean(config.getProperty("smarts.core.performance.logging"))) {
                    PerformanceLogger.init((String)(caLogsPath + File.separator + "performance.log"));
                }
                BIRestClientConfigInfo restConfig = this.buildBiRestConfig(config);
                this.buildSystemRccf(restConfig);
                system = SmartsCaSystem.with(config);
                systemLogger.info("SmartsCaSystem: " + (Object)((Object)system));
                try {
                    systemRequestContext.setAttribute("serviceInitOwner", (Object)Boolean.FALSE);
                    system.componentInitialize(systemRequestContext);
                }
                finally {
                    String metrics = SmartsCaRestServiceContextListener.systemRequestContext.requestMetrics.toString();
                    systemLogger.info("Startup metrics: " + metrics);
                }
                IRestEngineBuilder engineBuilder = null;
                SmartsCaRestServer server = new SmartsCaRestServer(engineBuilder, system);
                server.build();
                SmartsCaRestServiceContextListener.setServer((AbstractRestServer)server);
                SystemBaseRestApi.__static_system = system;
                SmartsCaBaseRestApi.setStaticCaSystem(system);
                systemLogger.info("Smarts-ca service has initialized");
            }
            catch (Exception th) {
                throw new RuntimeException("Could not initialize SmartsCaRestService", th);
            }
            finally {
                systemLogger.info("Finished initializing Smarts-CA.");
            }
        }
    }

    private void createSmartsLogsFolder(String path) throws IOException {
        Path logPath = Paths.get(path, new String[0]);
        if (!Files.exists(logPath, new LinkOption[0])) {
            Files.createDirectory(logPath, new FileAttribute[0]);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        super.contextDestroyed(event);
    }
}

