/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.generated.metadata;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityType;
import com.ibm.bi.platform.moser.common.generated.metadata.DrillGroup;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationGroupType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.KeyCompositionType;
import com.ibm.bi.platform.moser.common.generated.metadata.KeyConstraintType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.SortListType;
import com.ibm.bi.platform.moser.common.generated.metadata.SplitType;
import com.ibm.bi.platform.moser.common.generated.metadata.SqlOperatorType;
import com.ibm.bi.platform.moser.common.utils.ItemScanner;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PropertySetter {
    public static void updateModuleReference(ObjectType obj, String oldValue, String value) {
        if (oldValue == null || value == null || value.equals(oldValue)) {
            if (value == null) {
                obj.idForExpression = null;
            }
            return;
        }
        String objType = obj.getObjectType();
        if ("Calculation".equals(objType) || "Filter".equals(objType)) {
            Module module = MoserObject.getModuleObject(obj);
            if (module == null) {
                return;
            }
            if (PropertySetter.getParentQuerySubject(obj) != null) {
                Filter f = (Filter)obj;
                String oldIdForExpr = f.basicGetIdForExpression();
                String newIdForExpr = null;
                if (oldIdForExpr != null && oldIdForExpr.length() > oldValue.length()) {
                    f.idForExpression = newIdForExpr = oldIdForExpr.substring(0, oldIdForExpr.length() - oldValue.length()) + value;
                }
                PropertySetter.updateExpressionForQueryItem(module, obj, oldIdForExpr, newIdForExpr);
                return;
            }
            PropertySetter.updateMDTVReference(module.basicGetMetadataTreeView(), oldValue, value);
            obj.idForExpression = value;
            PropertySetter.updateExpressionForGlobalCalculationFilter(module, obj, oldValue, value);
            return;
        }
        if ("QuerySubject".equals(objType)) {
            Module module = MoserObject.getModuleObject(obj);
            if (module == null) {
                return;
            }
            PropertySetter.updateMDTVReference(module.basicGetMetadataTreeView(), oldValue, value);
            PropertySetter.updateRelationshipListReference(module.basicGetRelationship(), oldValue, value);
            PropertySetter.updateQuerySubjectListReference(module.basicGetQuerySubject(), oldValue, value);
            QuerySubject qs = (QuerySubject)obj;
            qs.idForExpression = value;
            PropertySetter.updateIdForExpression(qs.basicGetItem(), value);
            PropertySetter.updateExpressionForQuerySubject(module, obj, oldValue, value);
            return;
        }
        if ("QueryItem".equals(objType)) {
            QuerySubject qs = PropertySetter.getParentQuerySubject(obj);
            Module module = MoserObject.getModuleObject(qs);
            if (module == null || qs == null) {
                return;
            }
            String qsId = qs.identifier;
            QueryItem qi = (QueryItem)obj;
            String oldIdForExpr = qi.basicGetIdForExpression();
            String newIdForExpr = null;
            if (oldIdForExpr != null && oldIdForExpr.length() > oldValue.length()) {
                qi.idForExpression = newIdForExpr = oldIdForExpr.substring(0, oldIdForExpr.length() - oldValue.length()) + value;
            }
            PropertySetter.updateItemNormalization(qs.getItemNormalization(), oldValue, value);
            List<DrillGroup> drills = module.drillGroup;
            if (newIdForExpr != null && drills != null) {
                for (DrillGroup dg : drills) {
                    if (dg.segment == null) continue;
                    for (DrillGroup.Segment sg : dg.segment) {
                        if (!oldIdForExpr.equals(sg.ref)) continue;
                        sg.ref = newIdForExpr;
                    }
                }
            }
            PropertySetter.updateItemTypeListQueryItemReference(qs.basicGetItem(), oldValue, value);
            List<Relationship> relationships = module.relationship;
            if (relationships != null) {
                for (Relationship r : relationships) {
                    List<Relationship.Link> links = r.link;
                    if (links == null || links.isEmpty()) continue;
                    CardinalityType left = r.left;
                    CardinalityType right = r.right;
                    if (qsId.equals(left.ref)) {
                        for (Relationship.Link l : links) {
                            if (!oldValue.equals(l.leftRef)) continue;
                            l.leftRef = value;
                        }
                        continue;
                    }
                    if (!qsId.equals(right.ref)) continue;
                    for (Relationship.Link l : links) {
                        if (!oldValue.equals(l.rightRef)) continue;
                        l.rightRef = value;
                    }
                }
            }
            if (newIdForExpr != null && module.querySubject != null) {
                for (QuerySubject aQS : module.querySubject) {
                    PropertySetter.updateItemTypeListReference(aQS.basicGetItem(), oldIdForExpr, newIdForExpr);
                }
            }
            PropertySetter.updateExpressionForQueryItem(module, obj, oldIdForExpr, newIdForExpr);
            return;
        }
    }

    private static void updateItemNormalization(ItemNormalizationType itemNorm, String oldId, String newId) {
        if (itemNorm == null) {
            return;
        }
        List<ItemNormalizationGroupType> groups = itemNorm.basicGetItemNormalizationGroup();
        if (groups == null) {
            return;
        }
        for (ItemNormalizationGroupType grp : groups) {
            if (grp.key != null && grp.key.itemRef != null && grp.key.itemRef.equals(oldId)) {
                grp.key.itemRef = newId;
            }
            if (grp.attribute == null) continue;
            for (ItemNormalizationGroupType.Attribute attr : grp.attribute) {
                if (attr.itemRef == null || !attr.itemRef.equals(oldId)) continue;
                attr.itemRef = newId;
            }
        }
    }

    private static void updateItemTypeListQueryItemReference(List<ItemType> itemTypes, String oldId, String newId) {
        if (itemTypes == null) {
            return;
        }
        for (ItemType itemType : itemTypes) {
            PropertySetter.updateItemTypeQueryItemReference(itemType, oldId, newId);
        }
    }

    private static void updateItemTypeQueryItemReference(ItemType itemType, String oldId, String newId) {
        QueryItem qi = itemType.getQueryItem();
        if (qi != null) {
            if (qi.facetDefinition != null && qi.facetDefinition.sortList != null && qi.facetDefinition.sortList.sortItem != null) {
                for (SortListType.SortItem s : qi.facetDefinition.sortList.sortItem) {
                    if (!oldId.equals(s.ref)) continue;
                    s.ref = newId;
                }
            }
            PropertySetter.updateItemTypeListQueryItemReference(qi.basicGetItem(), oldId, newId);
            return;
        }
        ItemType.Folder folder = itemType.getFolder();
        if (folder != null) {
            PropertySetter.updateItemTypeListQueryItemReference(folder.basicGetItem(), oldId, newId);
            return;
        }
    }

    public static QuerySubject getParentQuerySubject(MoserObject moserObj) {
        if (moserObj == null) {
            return null;
        }
        MoserObject parent = moserObj.getParent();
        if (parent == null) {
            return null;
        }
        String objType = parent.getObjectType();
        if ("QuerySubject".equals(objType)) {
            return (QuerySubject)parent;
        }
        if ("Module".equals(objType)) {
            return null;
        }
        return PropertySetter.getParentQuerySubject(parent);
    }

    private static void updateMDTVReference(List<FolderType> mdtv, String oldId, String newId) {
        if (mdtv == null) {
            return;
        }
        for (FolderType folderType : mdtv) {
            PropertySetter.updateFolderTypeReference(folderType, oldId, newId);
        }
    }

    private static void updateFolderTypeReference(FolderType folderType, String oldId, String newId) {
        List<FolderItemType> folderItemTypes = folderType.basicGetFolderItem();
        if (folderItemTypes == null) {
            return;
        }
        for (FolderItemType folderItemType : folderItemTypes) {
            FolderType nestedFolder;
            String ref = folderItemType.getRef();
            if (oldId.equals(ref)) {
                folderItemType.ref = newId;
            }
            if ((nestedFolder = folderItemType.getFolder()) == null) continue;
            PropertySetter.updateFolderTypeReference(nestedFolder, oldId, newId);
        }
    }

    private static void updateRelationshipListReference(List<Relationship> relationships, String oldId, String newId) {
        if (relationships == null) {
            return;
        }
        for (Relationship relationship : relationships) {
            PropertySetter.updateRelationshipReference(relationship, oldId, newId);
        }
    }

    private static void updateRelationshipReference(Relationship relationship, String oldId, String newId) {
        PropertySetter.updateCardinalityTypeReference(relationship.getLeft(), oldId, newId);
        PropertySetter.updateCardinalityTypeReference(relationship.getRight(), oldId, newId);
    }

    private static void updateCardinalityTypeReference(CardinalityType cardinality, String oldId, String newId) {
        String ref = cardinality.getRef();
        if (oldId.equals(ref)) {
            cardinality.ref = newId;
        }
    }

    private static void updateQuerySubjectListReference(List<QuerySubject> querySubjects, String oldId, String newId) {
        if (querySubjects == null) {
            return;
        }
        for (QuerySubject querySubject : querySubjects) {
            PropertySetter.updateQuerySubjectReference(querySubject, oldId, newId);
        }
    }

    private static void updateQuerySubjectReference(QuerySubject querySubject, String oldId, String newId) {
        QuerySubject.JoinOperation joinOp;
        List<String> ref = querySubject.basicGetRef();
        PropertySetter.updateRefList(ref, oldId, newId);
        List<String> orgRef = querySubject.basicGetOriginalRef();
        PropertySetter.updateRefList(orgRef, oldId, newId);
        QuerySubject.QueryOperation queryOp = querySubject.getQueryOperation();
        if (queryOp != null) {
            PropertySetter.updateRefList(queryOp.basicGetQueryRef(), oldId, newId);
        }
        if ((joinOp = querySubject.getJoinOperation()) != null) {
            PropertySetter.updateRefList(joinOp.basicGetQueryRef(), oldId, newId);
            PropertySetter.updateRelationshipListReference(joinOp.basicGetRelationship(), oldId, newId);
        }
        PropertySetter.updateItemTypeListReference(querySubject.basicGetItem(), oldId, newId);
    }

    private static void updateRefList(List<String> ref, String oldId, String newId) {
        if (ref == null) {
            return;
        }
        for (int i = 0; i < ref.size(); ++i) {
            if (!oldId.equals(ref.get(i))) continue;
            ref.set(i, newId);
        }
    }

    private static void updateItemTypeListReference(List<ItemType> itemTypes, String oldId, String newId) {
        if (itemTypes == null) {
            return;
        }
        for (ItemType itemType : itemTypes) {
            PropertySetter.updateItemTypeReference(itemType, oldId, newId);
        }
    }

    private static void updateItemTypeReference(ItemType itemType, String oldId, String newId) {
        QueryItem qi = itemType.getQueryItem();
        if (qi != null) {
            List<SplitType> splits = qi.basicGetSplitDefinition();
            if (splits != null) {
                for (SplitType split : splits) {
                    String ref = split.getRef();
                    if (!oldId.equals(ref)) continue;
                    split.ref = newId;
                }
            }
            PropertySetter.updateItemTypeListReference(qi.basicGetItem(), oldId, newId);
            return;
        }
        ItemType.Folder folder = itemType.getFolder();
        if (folder != null) {
            PropertySetter.updateItemTypeListReference(folder.basicGetItem(), oldId, newId);
            return;
        }
    }

    public static void updateIdForExpression(List<ItemType> items, String parentIdForExpr) {
        if (items == null) {
            return;
        }
        for (ItemType itm : items) {
            QueryItem qi = itm.getQueryItem();
            if (qi != null) {
                String newIdforExpr;
                qi.idForExpression = newIdforExpr = parentIdForExpr + "." + qi.getIdentifier();
                PropertySetter.updateIdForExpression(qi.basicGetItem(), newIdforExpr);
                continue;
            }
            Filter flt = itm.getFilter();
            if (flt != null) {
                String newIdforExpr;
                flt.idForExpression = newIdforExpr = parentIdForExpr + "." + flt.getIdentifier();
                continue;
            }
            ItemType.Folder folder = itm.getFolder();
            if (folder == null) continue;
            PropertySetter.updateIdForExpression(folder.basicGetItem(), parentIdForExpr);
        }
    }

    public static void resetReferencedObject(Module module, String qiId, String qiIdForExpression, String qsId) {
        List<Relationship> relationships = module.relationship;
        if (relationships != null) {
            for (Relationship r : relationships) {
                List<Relationship.Link> links = r.link;
                if (links == null || links.isEmpty()) continue;
                CardinalityType left = r.left;
                CardinalityType right = r.right;
                if (qsId.equals(left.ref)) {
                    for (Relationship.Link l : links) {
                        if (!qiId.equals(l.leftRef)) continue;
                        l.setReferencedObjectLeft(null);
                    }
                    continue;
                }
                if (!qsId.equals(right.ref)) continue;
                for (Relationship.Link l : links) {
                    if (!qiId.equals(l.rightRef)) continue;
                    l.setReferencedObjectRight(null);
                }
            }
        }
        List<DrillGroup> drills = module.drillGroup;
        if (qiIdForExpression != null && drills != null) {
            for (DrillGroup dg : drills) {
                List<DrillGroup.Segment> segs = dg.segment;
                if (segs == null) continue;
                for (DrillGroup.Segment sg : segs) {
                    if (!qiIdForExpression.equals(sg.ref)) continue;
                    sg.setReferencedObject(null);
                }
            }
        }
    }

    public static void resolveIdForExpression(BaseObjectType obj) {
        if (obj == null) {
            return;
        }
        Module module = MoserObject.getModuleObject(obj);
        if (module == null || !module.isOverrideMode()) {
            return;
        }
        String objType = obj.getObjectType();
        if ("QuerySubject".equals(objType)) {
            obj.idForExpression = ((QuerySubject)obj).identifier;
            return;
        }
        if ("Calculation".equals(objType)) {
            obj.idForExpression = ((Calculation)obj).identifier;
            return;
        }
        if ("QueryItem".equals(objType) || "Filter".equals(objType)) {
            int s;
            String id = ((ObjectType)obj).identifier;
            if (id == null || id.isEmpty()) {
                return;
            }
            ArrayList<String> parts = new ArrayList<String>();
            parts.add(id);
            for (MoserObject parent = obj.getParent(); parent != null && !"Module".equals(objType = parent.getObjectType()); parent = parent.getParent()) {
                if ("QuerySubject".equals(objType)) {
                    id = ((QuerySubject)parent).identifier;
                    if (id == null || id.isEmpty()) {
                        return;
                    }
                    parts.add(id);
                    break;
                }
                if (!"QueryItem".equals(objType)) continue;
                id = ((QueryItem)parent).identifier;
                if (id == null || id.isEmpty()) {
                    return;
                }
                parts.add(id);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = s = parts.size() - 1; i >= 0; --i) {
                if (i != s) {
                    sb.append(".");
                }
                sb.append((String)parts.get(i));
            }
            obj.idForExpression = sb.toString();
        }
    }

    public static boolean isEmptyRef(String v) {
        return v == null || v.isEmpty() || "none".equals(v) || "None".equals(v) || "NONE".equals(v);
    }

    public static List<QueryItem> getAllQueryItemsInItems(List<ItemType> items) {
        ArrayList<QueryItem> qItems = new ArrayList<QueryItem>();
        if (items == null) {
            return qItems;
        }
        for (ItemType item : items) {
            if (item.queryItem != null) {
                qItems.add(item.queryItem);
                continue;
            }
            if (item.folder == null) continue;
            qItems.addAll(PropertySetter.getAllQueryItemsInItems(item.folder.item));
        }
        return qItems;
    }

    public static List<QueryItem> getAllQueryItemsInQuerySubject(QuerySubject qs) {
        return PropertySetter.getAllQueryItemsInItems(qs.item);
    }

    protected static void resetSplitToQueryItem(Module module, QueryItem srcQI, boolean bset) {
        String idForExpr = srcQI.idForExpression;
        if (idForExpr != null && !idForExpr.isEmpty()) {
            for (QuerySubject aQS : module.querySubject) {
                for (QueryItem aQI : PropertySetter.getAllQueryItemsInQuerySubject(aQS)) {
                    List sp;
                    if (srcQI.equals(aQI) || (sp = aQI.splitDefinition) == null || sp.isEmpty() || !idForExpr.equals(((SplitType)sp.get((int)0)).ref)) continue;
                    if (aQI.item != null) {
                        aQI.item.clear();
                    }
                    if (!bset) continue;
                    PropertySetter.addQueryItemsForSplit(srcQI, aQI);
                }
            }
        }
    }

    protected static void updateSplitRef(MoserObject obj, String oldValue, String newValue) {
        boolean bOldEmpty = PropertySetter.isEmptyRef(oldValue);
        boolean bNewEmpty = PropertySetter.isEmptyRef(newValue);
        if (bOldEmpty && bNewEmpty || !bOldEmpty && !bNewEmpty && newValue.equals(oldValue)) {
            return;
        }
        SplitType splitDef = (SplitType)obj;
        if (!InstanceType.REFERENCE.equals((Object)splitDef.instanceType)) {
            return;
        }
        Module module = MoserObject.getModuleObject(splitDef);
        if (module == null || !module.isOverrideMode()) {
            return;
        }
        MoserObject parent = splitDef.getParent();
        if (parent == null || !"QueryItem".equals(parent.getObjectType())) {
            return;
        }
        QueryItem targetQueryItem = (QueryItem)parent;
        splitDef.folderLabel = null;
        if (targetQueryItem.item != null) {
            targetQueryItem.item.clear();
        }
        if (bNewEmpty) {
            String[] oldParts;
            if (!bOldEmpty && (oldParts = oldValue.split("\\.")).length == 1) {
                PropertySetter.resetSplitToQueryItem(module, targetQueryItem, false);
            }
            return;
        }
        String[] parts = newValue.split("\\.");
        if (parts.length == 1) {
            splitDef.folderLabel = PropertySetter.splitToQuerySubject(targetQueryItem, splitDef, module, parts[0]);
            PropertySetter.resetSplitToQueryItem(module, targetQueryItem, true);
        } else {
            splitDef.folderLabel = PropertySetter.splitToComparableQueryItem(targetQueryItem, splitDef, module, parts[0], newValue);
        }
    }

    protected static QuerySubject getQuerySubjectById(Module module, String id) {
        if (module.querySubject == null) {
            return null;
        }
        for (QuerySubject qs : module.querySubject) {
            if (!id.equals(qs.identifier) && !id.equals(qs.idForExpression)) continue;
            return qs;
        }
        return null;
    }

    public static void ensureIdForExpression(String parentId, List<ItemType> items, HashMap<String, QueryItem> allQueryItems) {
        if (items == null) {
            return;
        }
        for (ItemType itm : items) {
            if (itm.queryItem != null) {
                if (itm.queryItem.idForExpression == null) {
                    itm.queryItem.idForExpression = parentId + "." + itm.queryItem.identifier;
                }
                allQueryItems.put(itm.queryItem.idForExpression, itm.queryItem);
                if (itm.queryItem.item == null) continue;
                PropertySetter.ensureIdForExpression(itm.queryItem.idForExpression, itm.queryItem.item, allQueryItems);
                continue;
            }
            if (itm.filter != null) {
                if (itm.filter.idForExpression != null) continue;
                itm.filter.idForExpression = parentId + "." + itm.filter.identifier;
                continue;
            }
            if (itm.folder == null) continue;
            PropertySetter.ensureIdForExpression(parentId, itm.folder.item, allQueryItems);
        }
    }

    private static boolean needCloneQueryItem(QueryItem qi, QuerySubject qs, HashMap<String, QueryItem> allQueryItems) {
        if (qs.itemNormalization == null) {
            return false;
        }
        if (qs.itemNormalization.itemNormalizationGroup == null) {
            return false;
        }
        for (ItemNormalizationGroupType g : qs.itemNormalization.itemNormalizationGroup) {
            String idforexpr;
            QueryItem foundQI;
            if (g.key == null || g.key.getKeyConstraint() != KeyConstraintType.UNIQUE || g.key.getKeyComposition() != KeyCompositionType.INDEPENDENT || (foundQI = allQueryItems.get(idforexpr = qs.identifier + "." + g.key.itemRef)) == null || !PropertySetter.compatibleDT(qi, foundQI)) continue;
            return true;
        }
        return false;
    }

    protected static boolean compatibleDT(QueryItem qi, QueryItem foundQI) {
        if (qi.highlevelDatatype == null || foundQI.highlevelDatatype == null) {
            return false;
        }
        if (qi.highlevelDatatype == HighLevelDataType.STRING && foundQI.highlevelDatatype == HighLevelDataType.STRING) {
            return true;
        }
        if (!(qi.highlevelDatatype != HighLevelDataType.INTEGER && qi.highlevelDatatype != HighLevelDataType.DECIMAL || foundQI.highlevelDatatype != HighLevelDataType.INTEGER && foundQI.highlevelDatatype != HighLevelDataType.DECIMAL)) {
            return true;
        }
        return !(qi.highlevelDatatype != HighLevelDataType.DATE && qi.highlevelDatatype != HighLevelDataType.DATETIME || foundQI.highlevelDatatype != HighLevelDataType.DATE && foundQI.highlevelDatatype != HighLevelDataType.DATETIME);
    }

    public static String splitToQuerySubject(QueryItem targetQueryItem, SplitType splitDef, Module module, String qsId) {
        QuerySubject sourceQuerySubject = PropertySetter.getQuerySubjectById(module, qsId);
        if (sourceQuerySubject == null) {
            return null;
        }
        if (sourceQuerySubject.item == null || sourceQuerySubject.item.isEmpty()) {
            return null;
        }
        HashMap<String, QueryItem> allQueryItems = new HashMap<String, QueryItem>();
        PropertySetter.ensureIdForExpression(sourceQuerySubject.identifier, sourceQuerySubject.item, allQueryItems);
        String parentIdForExpr = targetQueryItem.getIdForExpression();
        boolean bNeedCloneQueryItem = PropertySetter.needCloneQueryItem(targetQueryItem, sourceQuerySubject, allQueryItems);
        for (ItemType itm : sourceQuerySubject.item) {
            try {
                ItemType newItm = (ItemType)itm.clone();
                boolean[] b = new boolean[]{false, false};
                PropertySetter.adjustExpressionOfQueryItemFilter(newItm, b, parentIdForExpr, bNeedCloneQueryItem);
                if (!b[0] || b[1]) continue;
                if (targetQueryItem.item == null) {
                    targetQueryItem.item = new ArrayList();
                }
                targetQueryItem.item.add(newItm);
                newItm._parent = targetQueryItem;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return sourceQuerySubject.label;
    }

    protected static void adjustExpressionOfQueryItemFilter(ItemType item, boolean[] b, String pId, boolean bNeedCloneQueryItem) {
        if (item.namedSet != null || item.itemHierarchy != null || !bNeedCloneQueryItem && item.queryItem != null) {
            b[1] = true;
            return;
        }
        if (item.queryItem != null) {
            b[0] = true;
            item.queryItem.expression = item.queryItem.idForExpression;
            item.queryItem.idForExpression = pId + "." + item.queryItem.identifier;
            item.queryItem.instanceType = InstanceType.REFERENCE;
            if (item.queryItem.item != null) {
                for (ItemType t : item.queryItem.item) {
                    PropertySetter.adjustExpressionOfQueryItemFilter(t, b, item.queryItem.idForExpression, bNeedCloneQueryItem);
                }
            }
            return;
        }
        if (item.filter != null) {
            b[0] = true;
            item.filter.idForExpression = pId + "." + item.filter.identifier;
            item.filter.instanceType = InstanceType.REFERENCE;
            return;
        }
        if (item.folder != null && item.folder.item != null) {
            for (ItemType t : item.folder.item) {
                PropertySetter.adjustExpressionOfQueryItemFilter(t, b, pId, bNeedCloneQueryItem);
            }
        }
    }

    public static String splitToComparableQueryItem(QueryItem targetQueryItem, SplitType splitDef, Module module, String qsId, String idforexprSrcQueryItem) {
        String idforexprTarget = targetQueryItem.getIdForExpression();
        if (idforexprSrcQueryItem.equals(idforexprTarget)) {
            return null;
        }
        QuerySubject srcQuerySubject = PropertySetter.getQuerySubjectById(module, qsId);
        if (srcQuerySubject == null) {
            return null;
        }
        HashMap<String, QueryItem> allQueryItems = new HashMap<String, QueryItem>();
        PropertySetter.ensureIdForExpression(srcQuerySubject.identifier, srcQuerySubject.item, allQueryItems);
        QueryItem srcQueryItem = allQueryItems.get(idforexprSrcQueryItem);
        if (srcQueryItem == null) {
            return null;
        }
        return PropertySetter.addQueryItemsForSplit(srcQueryItem, targetQueryItem);
    }

    protected static String addQueryItemsForSplit(QueryItem srcQueryItem, QueryItem targetQueryItem) {
        if (srcQueryItem.item == null || srcQueryItem.item.isEmpty()) {
            return null;
        }
        try {
            QueryItem targetQIClone = (QueryItem)targetQueryItem.clone();
            targetQIClone.item = null;
            targetQIClone.splitDefinition = null;
            for (ItemType itm : srcQueryItem.item) {
                ItemType newItm = (ItemType)itm.clone();
                boolean[] b = new boolean[]{false, false};
                PropertySetter.adjustExpressionFromFilterToQueryItem(newItm, b, targetQIClone, srcQueryItem);
                if (!b[0] || b[1]) continue;
                if (targetQueryItem.item == null) {
                    targetQueryItem.item = new ArrayList();
                }
                targetQueryItem.item.add(newItm);
                newItm._parent = targetQueryItem;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return srcQueryItem.label;
    }

    protected static void adjustExpressionFromFilterToQueryItem(ItemType item, boolean[] b, QueryItem targetQI, QueryItem srcQueryItem) {
        if (item.getNamedSet() != null || item.getItemHierarchy() != null || item.getQueryItem() != null) {
            b[1] = true;
            return;
        }
        if (item.filter != null) {
            b[0] = true;
            try {
                QueryItem newQI = (QueryItem)targetQI.clone();
                newQI.identifier = item.filter.identifier;
                newQI.instanceType = InstanceType.REFERENCE;
                if (item.filter.label != null) {
                    newQI.label = item.filter.label + " [" + targetQI.label + "]";
                }
                newQI.expression = "case when " + item.filter.idForExpression + " then #$_this.parent.idForExpression# end";
                newQI.ref = null;
                newQI.idForExpression = targetQI.idForExpression + "." + newQI.identifier;
                item.queryItem = newQI;
                newQI._parent = item;
                item.filter = null;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return;
        }
        if (item.folder != null && item.folder.item != null) {
            for (ItemType t : item.folder.item) {
                PropertySetter.adjustExpressionFromFilterToQueryItem(t, b, targetQI, srcQueryItem);
            }
        }
    }

    private static void updateExpressionForGlobalCalculationFilter(Module module, ObjectType obj, String oldId, String newId) {
        ArrayList<ObjectType> candidates = new ArrayList<ObjectType>();
        ArrayList<String> exprs = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> idforExprs = new ArrayList<String>();
        PropertySetter.collectCandidatesForGlobaleCalculationFilter(module, obj, candidates, exprs, types, idforExprs);
        for (int i = 0; i < candidates.size(); ++i) {
            ObjectType o = candidates.get(i);
            String objType = types.get(i);
            JSONObject jFunc = PropertySetter.getJSONFunctionDef(o);
            if (jFunc != null && jFunc.get((Object)"elementOperands") != null) {
                JSONArray ops = (JSONArray)jFunc.get((Object)"elementOperands");
                boolean b = false;
                for (int j = 0; j < ops.size(); ++j) {
                    if (!oldId.equals(ops.get(j))) continue;
                    ops.set(j, (Object)newId);
                    b = true;
                    break;
                }
                if (!b) continue;
                PropertySetter.updateJSONFunctionDef(o, jFunc);
                PropertySetter.updateExpressionStringForGlobalCalculationFilter(o, objType, exprs.get(i), idforExprs.get(i), oldId, newId);
                continue;
            }
            PropertySetter.updateExpressionStringForGlobalCalculationFilter(o, objType, exprs.get(i), idforExprs.get(i), oldId, newId);
        }
    }

    private static void updateExpressionForQuerySubject(Module module, ObjectType obj, String oldId, String newId) {
        ArrayList<ObjectType> candidates = new ArrayList<ObjectType>();
        ArrayList<String> exprs = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> idforExprs = new ArrayList<String>();
        PropertySetter.collectCandidatesForQuerySubject(module, obj, candidates, exprs, types, idforExprs, oldId);
        for (int i = 0; i < candidates.size(); ++i) {
            ObjectType o = candidates.get(i);
            String objType = types.get(i);
            JSONObject jFunc = PropertySetter.getJSONFunctionDef(o);
            if (jFunc != null && jFunc.get((Object)"elementOperands") != null) {
                JSONArray ops = (JSONArray)jFunc.get((Object)"elementOperands");
                boolean b = false;
                for (int j = 0; j < ops.size(); ++j) {
                    String idforexpr = (String)ops.get(j);
                    String[] parts = idforexpr.split("\\.");
                    if (parts.length <= 1 || !oldId.equals(parts[0])) continue;
                    parts[0] = newId;
                    StringBuilder sb = new StringBuilder();
                    for (int k = 0; k < parts.length; ++k) {
                        if (k != 0) {
                            sb.append(".");
                        }
                        sb.append(parts[k]);
                    }
                    String newElem = sb.toString();
                    ops.set(j, (Object)newElem);
                    b = true;
                    break;
                }
                if (!b) continue;
                PropertySetter.updateJSONFunctionDef(o, jFunc);
                PropertySetter.updateExpressionStringForQuerySubject(o, objType, exprs.get(i), idforExprs.get(i), oldId, newId);
                continue;
            }
            PropertySetter.updateExpressionStringForQuerySubject(o, objType, exprs.get(i), idforExprs.get(i), oldId, newId);
        }
    }

    private static void updateExpressionForQueryItem(Module module, ObjectType obj, String oldIdforExpr, String newIdforExpr) {
        ArrayList<ObjectType> candidates = new ArrayList<ObjectType>();
        ArrayList<String> exprs = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> idforExprs = new ArrayList<String>();
        PropertySetter.collectCandidatesForQuerySubject(module, obj, candidates, exprs, types, idforExprs, null);
        for (int i = 0; i < candidates.size(); ++i) {
            ObjectType o = candidates.get(i);
            String objType = types.get(i);
            JSONObject jFunc = PropertySetter.getJSONFunctionDef(o);
            if (jFunc != null && jFunc.get((Object)"elementOperands") != null) {
                JSONArray ops = (JSONArray)jFunc.get((Object)"elementOperands");
                boolean b = false;
                for (int j = 0; j < ops.size(); ++j) {
                    if (!oldIdforExpr.equals(ops.get(j))) continue;
                    ops.set(j, (Object)newIdforExpr);
                    b = true;
                    break;
                }
                if (!b) continue;
                PropertySetter.updateJSONFunctionDef(o, jFunc);
                PropertySetter.updateExpressionStringForQueryItem(o, objType, exprs.get(i), idforExprs.get(i), oldIdforExpr, newIdforExpr);
                continue;
            }
            PropertySetter.updateExpressionStringForQueryItem(o, objType, exprs.get(i), idforExprs.get(i), oldIdforExpr, newIdforExpr);
        }
    }

    private static JSONObject getJSONFunctionDef(ObjectType o) {
        return PropertySetter.getJSONPropertyValue(o, "_MUI_expr");
    }

    private static JSONObject getJSONPropertyValue(ObjectType o, String propName) {
        List<PropertyType> props = o.basicGetProperty();
        if (props == null) {
            return null;
        }
        JSONObject jFunc = null;
        for (PropertyType p : props) {
            if (!propName.equals(p.getName())) continue;
            String funcStr = p.getValue();
            if (funcStr == null) break;
            try {
                jFunc = JSONObject.parse((String)funcStr);
            }
            catch (Exception exception) {}
            break;
        }
        return jFunc;
    }

    private static void updateJSONFunctionDef(ObjectType o, JSONObject j) {
        List<PropertyType> props = o.basicGetProperty();
        if (props == null) {
            return;
        }
        for (PropertyType p : props) {
            if (!"_MUI_expr".equals(p.getName())) continue;
            try {
                p.value = j.serialize();
            }
            catch (Exception exception) {}
            break;
        }
    }

    private static void updateExpressionStringForGlobalCalculationFilter(ObjectType targetObj, String targetObjType, String targetExpr, String targetIdforExpr, String oldId, String newId) {
        String newExpr = ItemScanner.replaceIdForExpr(targetObjType, targetExpr, targetIdforExpr, "Calculation", oldId, newId);
        if (newExpr != null) {
            if ("Calculation".equals(targetObjType)) {
                ((Calculation)targetObj).expression = newExpr;
            } else {
                ((Filter)targetObj).expression = newExpr;
            }
        }
    }

    private static void updateExpressionStringForQuerySubject(ObjectType targetObj, String targetObjType, String targetExpr, String sameQS, String oldId, String newId) {
        String newExpr = ItemScanner.replaceIdForExpr(targetObjType, targetExpr, sameQS, "QuerySubject", oldId, newId);
        if (newExpr != null) {
            String realObjType = targetObj.getObjectType();
            if ("Calculation".equals(realObjType)) {
                ((Calculation)targetObj).expression = newExpr;
            } else if ("Filter".equals(realObjType)) {
                ((Filter)targetObj).expression = newExpr;
            } else if ("QueryItem".equals(realObjType)) {
                ((QueryItem)targetObj).expression = newExpr;
            }
        }
    }

    private static void updateExpressionStringForQueryItem(ObjectType targetObj, String targetObjType, String targetExpr, String targetIdforExpr, String oldIdforExpr, String newIdforExpr) {
        String newExpr = ItemScanner.replaceIdForExpr(targetObjType, targetExpr, targetIdforExpr, "QueryItem", oldIdforExpr, newIdforExpr);
        if (newExpr != null) {
            String realObjType = targetObj.getObjectType();
            if ("Calculation".equals(realObjType)) {
                ((Calculation)targetObj).expression = newExpr;
            } else if ("Filter".equals(realObjType)) {
                ((Filter)targetObj).expression = newExpr;
            } else if ("QueryItem".equals(realObjType)) {
                ((QueryItem)targetObj).expression = newExpr;
            }
        }
    }

    public static void setIdentifier(ObjectType obj, String value, HashMap<String, String> idforExprToNewExpr) {
        if (idforExprToNewExpr != null) {
            ArrayList<ObjectType> candidates = new ArrayList<ObjectType>();
            ArrayList<String> exprs = new ArrayList<String>();
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<String> idforExprs = new ArrayList<String>();
            PropertySetter.collectCandidates(obj, candidates, exprs, types, idforExprs);
            for (int i = 0; i < candidates.size(); ++i) {
                String newExpr = idforExprToNewExpr.get(idforExprs.get(i));
                if (newExpr == null) continue;
                String objType = types.get(i);
                if ("Calculation".equals(objType)) {
                    Calculation c = (Calculation)candidates.get(i);
                    c.setExpression(newExpr);
                    continue;
                }
                if ("Filter".equals(objType)) {
                    Filter f = (Filter)candidates.get(i);
                    f.setExpression(newExpr);
                    continue;
                }
                if (!"QueryItem".equals(objType)) continue;
                QueryItem qi = (QueryItem)candidates.get(i);
                qi.setExpression(newExpr);
            }
        }
        obj.setIdentifier(value);
    }

    public static String getExtractIdentifiersSpec(ObjectType obj, String value) {
        String oldIdForExpr = obj.idForExpression;
        String oldValue = obj.identifier;
        Module module = MoserObject.getModuleObject(obj);
        if (module == null || oldValue == null || oldIdForExpr == null || oldValue.equals(value)) {
            return null;
        }
        String objType = obj.getObjectType();
        ArrayList<ObjectType> candidates = new ArrayList<ObjectType>();
        ArrayList<String> exprs = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> idforExprs = new ArrayList<String>();
        PropertySetter.collectCandidates(obj, candidates, exprs, types, idforExprs);
        if (candidates.isEmpty()) {
            return null;
        }
        return PropertySetter.buildSpec(oldIdForExpr, objType, value, exprs, types, idforExprs);
    }

    protected static void collectCandidates(ObjectType obj, ArrayList<ObjectType> candidates, ArrayList<String> exprs, ArrayList<String> types, ArrayList<String> idforExprs) {
        Module module = MoserObject.getModuleObject(obj);
        if (module == null) {
            return;
        }
        String objType = obj.getObjectType();
        if ("Calculation".equals(objType) || "Filter".equals(objType)) {
            PropertySetter.collectCandidatesForGlobaleCalculationFilter(module, obj, candidates, exprs, types, idforExprs);
        } else if ("QuerySubject".equals(objType)) {
            PropertySetter.collectCandidatesForQuerySubject(module, obj, candidates, exprs, types, idforExprs, null);
        } else if ("QueryItem".equals(objType)) {
            PropertySetter.collectCandidatesForQuerySubject(module, obj, candidates, exprs, types, idforExprs, null);
        }
    }

    protected static boolean objectWithExpr(String expr, String idForExpr) {
        return expr != null && !expr.isEmpty() && idForExpr != null && !idForExpr.isEmpty();
    }

    protected static void collectCandidatesForGlobaleCalculationFilter(Module module, ObjectType obj, ArrayList<ObjectType> candidates, ArrayList<String> exprs, ArrayList<String> types, ArrayList<String> idforExprs) {
        List<Filter> filters;
        List<Calculation> calcs = module.basicGetCalculation();
        if (calcs != null) {
            for (Calculation c : calcs) {
                if (c.equals(obj) || !PropertySetter.objectWithExpr(c.expression, c.idForExpression)) continue;
                candidates.add(c);
                exprs.add(c.expression);
                types.add("Calculation");
                idforExprs.add(c.idForExpression);
            }
        }
        if ((filters = module.basicGetFilter()) != null) {
            for (Filter f : filters) {
                if (f.equals(obj) || !PropertySetter.objectWithExpr(f.expression, f.idForExpression)) continue;
                candidates.add(f);
                exprs.add(f.expression);
                types.add("Filter");
                idforExprs.add(f.idForExpression);
            }
        }
    }

    public static List<ItemType> getItemsWithQueryItemFilter(List<ItemType> items) {
        ArrayList<ItemType> rtItems = new ArrayList<ItemType>();
        if (items == null) {
            return rtItems;
        }
        for (ItemType item : items) {
            if (item.getQueryItem() != null || item.getFilter() != null) {
                rtItems.add(item);
                continue;
            }
            if (item.getFolder() == null) continue;
            rtItems.addAll(PropertySetter.getItemsWithQueryItemFilter(item.getFolder().basicGetItem()));
        }
        return rtItems;
    }

    protected static void collectCandidatesForQuerySubject(Module module, ObjectType obj, ArrayList<ObjectType> candidates, ArrayList<String> exprs, ArrayList<String> types, ArrayList<String> idforExprs, String oldQSId) {
        List<Filter> list;
        List<Calculation> list2;
        List<QuerySubject> list3;
        String tp = obj.getObjectType();
        QuerySubject qs = null;
        String oldQSIdforExpr = null;
        if ("QuerySubject".equals(tp)) {
            qs = (QuerySubject)obj;
            oldQSIdforExpr = oldQSId != null ? oldQSId : qs.idForExpression;
        } else if ("QueryItem".equals(tp) || "Filter".equals(tp)) {
            qs = PropertySetter.getParentQuerySubject(obj);
            oldQSIdforExpr = qs.idForExpression;
        } else {
            return;
        }
        if (oldQSIdforExpr == null) {
            return;
        }
        for (ItemType itemType : PropertySetter.getItemsWithQueryItemFilter(qs.basicGetItem())) {
            QueryItem queryItem = itemType.getQueryItem();
            if (queryItem != null) {
                if (queryItem.equals(obj) || !PropertySetter.objectWithExpr(queryItem.expression, queryItem.idForExpression)) continue;
                candidates.add(queryItem);
                exprs.add(queryItem.expression);
                types.add("QueryItem");
                idforExprs.add(queryItem.idForExpression);
                continue;
            }
            Filter filter = itemType.getFilter();
            if (!filter.equals(obj) && !PropertySetter.objectWithExpr(filter.expression, filter.idForExpression)) continue;
            candidates.add(filter);
            exprs.add(filter.expression);
            types.add("QueryItem");
            idforExprs.add(filter.idForExpression);
        }
        List<Filter> embeddedFilters = qs.basicGetFilter();
        if (embeddedFilters != null) {
            for (Filter filter : embeddedFilters) {
                if (!PropertySetter.objectWithExpr(filter.expression, filter.idForExpression)) continue;
                candidates.add(filter);
                exprs.add(filter.expression);
                types.add("QueryItem");
                idforExprs.add(filter.idForExpression);
            }
        }
        if ((list3 = module.basicGetQuerySubject()) != null) {
            for (QuerySubject querySubject : list3) {
                if (querySubject.equals(qs) || !PropertySetter.hasReference(querySubject, qs, oldQSIdforExpr)) continue;
                for (ItemType item : PropertySetter.getItemsWithQueryItemFilter(querySubject.basicGetItem())) {
                    QueryItem qi = item.getQueryItem();
                    if (qi == null || qi.regularAggregate == RegularAggregateType.CALCULATED || !PropertySetter.objectWithExpr(qi.expression, qi.idForExpression)) continue;
                    candidates.add(qi);
                    exprs.add(qi.expression);
                    types.add("QueryItem");
                    idforExprs.add(qi.idForExpression);
                }
            }
        }
        if ((list2 = module.basicGetCalculation()) != null) {
            for (Calculation c : list2) {
                if (!PropertySetter.objectWithExpr(c.expression, c.idForExpression)) continue;
                candidates.add(c);
                exprs.add(c.expression);
                types.add("Calculation");
                idforExprs.add(c.idForExpression);
            }
        }
        if ((list = module.basicGetFilter()) != null) {
            for (Filter f : list) {
                if (!PropertySetter.objectWithExpr(f.expression, f.idForExpression)) continue;
                candidates.add(f);
                exprs.add(f.expression);
                types.add("Filter");
                idforExprs.add(f.idForExpression);
            }
        }
    }

    protected static boolean hasReference(QuerySubject aQS, QuerySubject qs, String oldQSId) {
        List<String> refs = aQS.basicGetRef();
        if (refs != null && refs.contains(oldQSId)) {
            return true;
        }
        QuerySubject.JoinOperation joinOp = aQS.getJoinOperation();
        return joinOp != null && (refs = joinOp.basicGetQueryRef()) != null && refs.contains(oldQSId);
    }

    public static String buildSpec(String oldIdForExpr, String objType, String newId, ArrayList<String> exprs, ArrayList<String> types, ArrayList<String> idforExprs) {
        return "{" + PropertySetter.wrapQuote("moserFunctionType") + ":" + PropertySetter.wrapQuote("extractIdentifiers") + "," + PropertySetter.buildExpressions(exprs) + "," + PropertySetter.buildFeedback(oldIdForExpr, objType, newId, types, idforExprs) + "}";
    }

    private static String buildExpressions(ArrayList<String> exprs) {
        StringBuilder sb1 = new StringBuilder();
        for (int i = 0; i < exprs.size(); ++i) {
            if (i > 0) {
                sb1.append(",");
            }
            sb1.append(PropertySetter.wrapQuote(exprs.get(i)));
        }
        return PropertySetter.wrapQuote("expressions") + ":[" + sb1.toString() + "]";
    }

    private static String buildFeedback(String oldIdForExpr, String objType, String newId, ArrayList<String> types, ArrayList<String> idforExprs) {
        StringBuilder sb1 = new StringBuilder();
        for (int i = 0; i < idforExprs.size(); ++i) {
            if (i > 0) {
                sb1.append(",");
            }
            sb1.append("{");
            sb1.append(PropertySetter.wrapSlashQuote("idForExpression"));
            sb1.append(":");
            sb1.append(PropertySetter.wrapSlashQuote(idforExprs.get(i)));
            sb1.append(",");
            sb1.append(PropertySetter.wrapSlashQuote("type"));
            sb1.append(":");
            sb1.append(PropertySetter.wrapSlashQuote(types.get(i)));
            sb1.append("}");
        }
        return PropertySetter.wrapQuote("feedback") + ":" + PropertySetter.wrapQuote("{" + PropertySetter.wrapSlashQuote("idForExpression") + ":" + PropertySetter.wrapSlashQuote(oldIdForExpr) + "," + PropertySetter.wrapSlashQuote("type") + ":" + PropertySetter.wrapSlashQuote(objType) + "," + PropertySetter.wrapSlashQuote("newIdentifier") + ":" + PropertySetter.wrapSlashQuote(newId) + "," + PropertySetter.wrapSlashQuote("expressions") + ":[" + sb1.toString() + "]}");
    }

    private static String wrapQuote(String s) {
        return "\"" + s + "\"";
    }

    private static String wrapSlashQuote(String s) {
        return "\\\"" + s + "\\\"";
    }

    public static boolean cleanQuerySubjectItemNormalization(QuerySubject qs, List<String> existingQI) {
        ItemNormalizationType itemNorm = qs.itemNormalization;
        if (itemNorm == null) {
            return false;
        }
        List<ItemNormalizationGroupType> grps = itemNorm.itemNormalizationGroup;
        if (grps == null || grps.isEmpty()) {
            return false;
        }
        if (existingQI.isEmpty()) {
            qs.itemNormalization = null;
            return true;
        }
        boolean bChanged = false;
        ArrayList<ItemNormalizationGroupType> lst = new ArrayList<ItemNormalizationGroupType>();
        for (ItemNormalizationGroupType g : grps) {
            lst.add(g);
        }
        for (ItemNormalizationGroupType ag : lst) {
            boolean bDelGrp = false;
            List<ItemNormalizationGroupType.Attribute> attrs = ag.attribute;
            ItemNormalizationGroupType.Key k = ag.key;
            if (attrs != null && !attrs.isEmpty()) {
                int sz = attrs.size();
                for (int i = sz - 1; i >= 0; --i) {
                    if (existingQI.contains(attrs.get((int)i).itemRef)) continue;
                    bChanged = true;
                    attrs.remove(i);
                }
            }
            if (k != null) {
                bDelGrp = !existingQI.contains(k.itemRef);
            } else {
                boolean bl = bDelGrp = attrs == null || attrs.isEmpty();
            }
            if (!bDelGrp) continue;
            bChanged = true;
            String gpId = ag.identifier;
            List<String> paranetGrps = ag.parentGroupRef;
            int idx = grps.indexOf(ag);
            if (idx >= 0) {
                grps.remove(idx);
            }
            for (ItemNormalizationGroupType otherGrp : grps) {
                List<String> otherParanetGrps = otherGrp.parentGroupRef;
                if (otherParanetGrps == null || otherParanetGrps.isEmpty() || !otherParanetGrps.contains(gpId)) continue;
                idx = otherParanetGrps.indexOf(gpId);
                if (idx >= 0) {
                    otherParanetGrps.remove(idx);
                }
                if (paranetGrps == null) continue;
                for (String sg : paranetGrps) {
                    if (otherParanetGrps.contains(sg)) continue;
                    otherParanetGrps.add(sg);
                }
            }
        }
        if (grps.isEmpty()) {
            bChanged = true;
            qs.itemNormalization = null;
        }
        return bChanged;
    }

    public static void addQueryItemToItemNormalization(QuerySubject qs, QueryItem queryItem, ObjectFactory objectFactory) {
        if (queryItem.hidden != null && queryItem.hidden.booleanValue()) {
            return;
        }
        if (qs.itemNormalization == null) {
            return;
        }
        if (qs.itemNormalization.itemNormalizationGroup == null || qs.itemNormalization.itemNormalizationGroup.isEmpty()) {
            return;
        }
        JSONObject jFunc = PropertySetter.getJSONFunctionDef(queryItem);
        if (jFunc == null) {
            return;
        }
        if (RegularAggregateType.CALCULATED == queryItem.regularAggregate) {
            return;
        }
        ItemNormalizationGroupType pkGrp = PropertySetter.getSimplePrimaryKeyGroup(qs.itemNormalization.itemNormalizationGroup);
        if (pkGrp != null) {
            if (queryItem.identifier.equals(pkGrp.key.itemRef)) {
                return;
            }
            if (pkGrp.attribute != null) {
                for (ItemNormalizationGroupType.Attribute attr : pkGrp.attribute) {
                    if (!queryItem.identifier.equals(attr.itemRef)) continue;
                    return;
                }
            }
            PropertySetter.addNewAttributeToGroup(objectFactory, pkGrp, queryItem);
        } else {
            JSONObject jP;
            String func = (String)jFunc.get((Object)"func");
            boolean bGetIdsFromExpr = "customCalculation".equals(func);
            if ("split".equals(func) && (jP = PropertySetter.getJSONPropertyValue(queryItem, "_MUI_splitOrigin")) != null) {
                jFunc = jP;
            }
            HashMap<String, String> allIds = new HashMap<String, String>();
            ArrayList<String> idList = new ArrayList<String>();
            if (!bGetIdsFromExpr) {
                if (!PropertySetter.getIdsFromPropertyJSONValue(idList, allIds, jFunc, qs.getIdentifier())) {
                    return;
                }
            } else {
                List<String[]> ids = ItemScanner.collectIdentifiers(queryItem.getExpression());
                for (String[] id : ids) {
                    if (PropertySetter.addQueryItemIdParts(idList, id, allIds, qs.getIdentifier())) continue;
                    return;
                }
            }
            if (idList.size() == 0) {
                return;
            }
            for (ItemNormalizationGroupType grp : qs.itemNormalization.itemNormalizationGroup) {
                int n = 0;
                if (grp.key != null && grp.key.itemRef != null && allIds.containsKey(grp.key.itemRef)) {
                    ++n;
                }
                if (grp.attribute != null && !grp.attribute.isEmpty()) {
                    for (ItemNormalizationGroupType.Attribute a : grp.attribute) {
                        if (a.itemRef == null || !allIds.containsKey(a.itemRef)) continue;
                        ++n;
                    }
                }
                if (n != idList.size()) continue;
                PropertySetter.addNewAttributeToGroup(objectFactory, grp, queryItem);
                return;
            }
        }
    }

    protected static void addNewAttributeToGroup(ObjectFactory objectFactory, ItemNormalizationGroupType pkGrp, QueryItem queryItem) {
        ItemNormalizationGroupType.Attribute newAttr = objectFactory.createItemNormalizationGroupTypeAttribute();
        newAttr.itemRef = queryItem.identifier;
        newAttr.sqlOperator = SqlOperatorType.MINIMUM;
        pkGrp.addAttribute(newAttr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ItemNormalizationGroupType getSimplePrimaryKeyGroup(List<ItemNormalizationGroupType> grps) {
        if (grps.size() == 1) {
            ItemNormalizationGroupType g = grps.get(0);
            if (g.key == null || g.key.getKeyConstraint() != KeyConstraintType.UNIQUE) return null;
            return g;
        }
        ItemNormalizationGroupType pkGrp = null;
        HashMap<String, ItemNormalizationGroupType> idToGrp = new HashMap<String, ItemNormalizationGroupType>();
        for (ItemNormalizationGroupType g : grps) {
            if (g.identifier == null) {
                return null;
            }
            if (g.key == null) {
                return null;
            }
            if (g.key.getKeyConstraint() == KeyConstraintType.UNIQUE) {
                if (g.parentGroupRef != null && !g.parentGroupRef.isEmpty() && g.key.getKeyComposition() == KeyCompositionType.INDEPENDENT) {
                    return null;
                }
                if (pkGrp != null) return null;
                pkGrp = g;
            } else if (g.attribute != null && !g.attribute.isEmpty()) {
                return null;
            }
            idToGrp.put(g.identifier, g);
        }
        if (pkGrp == null) return pkGrp;
        int nChain = 1;
        List<String> parentGrps = pkGrp.parentGroupRef;
        while (parentGrps != null && !parentGrps.isEmpty()) {
            if (parentGrps.size() > 1) {
                return null;
            }
            ++nChain;
            parentGrps = ((ItemNormalizationGroupType)idToGrp.get((Object)parentGrps.get((int)0))).parentGroupRef;
        }
        if (nChain == grps.size()) return pkGrp;
        return null;
    }

    protected static boolean getIdsFromPropertyJSONValue(ArrayList<String> idList, HashMap<String, String> allIds, JSONObject jFunc, String qsId) {
        String orgId;
        if (jFunc == null) {
            return false;
        }
        String basedObjId = (String)jFunc.get((Object)"basedOnMoserObjectId");
        if (basedObjId != null && !basedObjId.isEmpty() && !PropertySetter.addQueryItemId(idList, basedObjId, allIds, qsId)) {
            return false;
        }
        String basedObj = (String)jFunc.get((Object)"basedOnMoserObject");
        if (basedObj != null && !basedObj.isEmpty() && !PropertySetter.addQueryItemId(idList, basedObj, allIds, qsId)) {
            return false;
        }
        JSONArray operands = (JSONArray)jFunc.get((Object)"elementOperands");
        if (operands != null) {
            for (Object o : operands) {
                String sId = (String)o;
                if (sId.isEmpty() || PropertySetter.addQueryItemId(idList, sId, allIds, qsId)) continue;
                return false;
            }
        }
        return (orgId = (String)jFunc.get((Object)"originalColumnIdentifier")) == null || orgId.isEmpty() || PropertySetter.addQueryItemId(idList, orgId, allIds, qsId);
    }

    protected static boolean addQueryItemId(ArrayList<String> idList, String basedObj, HashMap<String, String> allIds, String qsId) {
        String[] parts = basedObj.split("\\.");
        return PropertySetter.addQueryItemIdParts(idList, parts, allIds, qsId);
    }

    protected static boolean addQueryItemIdParts(ArrayList<String> idList, String[] parts, HashMap<String, String> allIds, String qsId) {
        if (parts.length == 1) {
            if (!allIds.containsKey(parts[0])) {
                allIds.put(parts[0], parts[0]);
                idList.add(parts[0]);
            }
            return true;
        }
        if (parts.length == 2 && parts[0].equals(qsId)) {
            if (!allIds.containsKey(parts[1])) {
                allIds.put(parts[1], parts[1]);
                idList.add(parts[1]);
            }
            return true;
        }
        return false;
    }
}

