/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.V5QueryExpressionParserTokenValidator;
import java.util.ArrayList;
import java.util.List;

public class ItemScanner {
    private ItemScanner() {
    }

    public static List<String[]> collectIdentifiers(String expr) {
        ArrayList<String[]> rtLst = new ArrayList<String[]>();
        if (expr == null || expr.isEmpty()) {
            return rtLst;
        }
        int length = expr.length();
        int pos = 0;
        while (pos < length) {
            int nextpos;
            ArrayList<String> parts;
            boolean[] bvalid;
            int aChar = expr.codePointAt(pos);
            if (aChar == 35) {
                pos = ItemScanner.skipMacro(expr, pos + 1);
                continue;
            }
            if (aChar == 39) {
                pos = ItemScanner.skipSingleQuoteString(expr, pos + 1);
                continue;
            }
            if (aChar == 34) {
                pos = ItemScanner.skipDoubleQuoteString(expr, pos + 1);
                continue;
            }
            if (aChar == 63) {
                pos = ItemScanner.skipPrompt(expr, pos + 1);
                continue;
            }
            if (ItemScanner.isComment(expr, pos)) {
                pos = ItemScanner.skipComment(expr, pos + 2);
                continue;
            }
            if (ItemScanner.isMultiLineComment(expr, pos)) {
                pos = ItemScanner.skipMultiLineComment(expr, pos + 2);
                continue;
            }
            if (V5QueryExpressionParserTokenValidator.isLetter(aChar) || aChar == 95) {
                bvalid = new boolean[]{true};
                parts = new ArrayList<String>();
                nextpos = ItemScanner.skipIdentifier(expr, pos + 1, bvalid, parts);
                if (bvalid[0] && !parts.isEmpty() && ItemScanner.isValidId(parts)) {
                    rtLst.add(ItemScanner.generateParts(parts));
                }
                pos = nextpos;
                continue;
            }
            if (aChar == 91) {
                bvalid = new boolean[]{true};
                parts = new ArrayList();
                nextpos = ItemScanner.skipBracketName(expr, pos + 1, bvalid, parts);
                if (bvalid[0] && !parts.isEmpty()) {
                    rtLst.add(ItemScanner.generateParts(parts));
                }
                pos = nextpos;
                continue;
            }
            ++pos;
        }
        return rtLst;
    }

    private static boolean isValidId(List<String> parts) {
        return parts.size() != 1 || !IdentifierUtil.isKeyword(parts.get(0));
    }

    private static String[] generateParts(List<String> parts) {
        String[] p = new String[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            p[i] = parts.get(i);
        }
        return p;
    }

    private static String generatePart(String expr, int st, int end) {
        StringBuilder sb = new StringBuilder();
        int length = expr.length();
        for (int i = st; i < end && i < length; ++i) {
            int c = expr.codePointAt(i);
            sb.appendCodePoint(c);
        }
        return sb.toString();
    }

    private static int skipIdentifier(String expr, int st, boolean[] bvalid, List<String> parts) {
        int length;
        int nextPos = ItemScanner.skipPart(expr, st);
        int nextPosSkipWhiteSpec = ItemScanner.skipWhiteSpace(expr, nextPos);
        if (nextPosSkipWhiteSpec >= (length = expr.length())) {
            bvalid[0] = true;
            parts.add(ItemScanner.generatePart(expr, st - 1, nextPos));
            return nextPosSkipWhiteSpec;
        }
        int nextChar = expr.codePointAt(nextPosSkipWhiteSpec);
        if (nextChar == 40) {
            bvalid[0] = false;
            return nextPosSkipWhiteSpec;
        }
        if (nextChar != 46) {
            bvalid[0] = true;
            parts.add(ItemScanner.generatePart(expr, st - 1, nextPos));
            return nextPosSkipWhiteSpec;
        }
        int posAfterDot = ItemScanner.skipWhiteSpace(expr, nextPosSkipWhiteSpec + 1);
        if (posAfterDot >= length) {
            bvalid[0] = false;
            return posAfterDot;
        }
        int nextnextChar = expr.codePointAt(posAfterDot);
        if (!V5QueryExpressionParserTokenValidator.isLetter(nextnextChar) && nextnextChar != 95) {
            bvalid[0] = false;
            return posAfterDot;
        }
        parts.add(ItemScanner.generatePart(expr, st - 1, nextPos));
        return ItemScanner.skipIdentifier(expr, posAfterDot + 1, bvalid, parts);
    }

    private static int skipBracketName(String expr, int st, boolean[] bvalid, List<String> parts) {
        int length;
        int nextPos = ItemScanner.skipBracketPart(expr, st);
        int nextPosSkipWhiteSpec = ItemScanner.skipWhiteSpace(expr, nextPos);
        if (nextPosSkipWhiteSpec >= (length = expr.length())) {
            bvalid[0] = true;
            parts.add(ItemScanner.generatePart(expr, st - 1, nextPos));
            return nextPosSkipWhiteSpec;
        }
        int nextChar = expr.codePointAt(nextPosSkipWhiteSpec);
        if (nextChar == 40) {
            bvalid[0] = false;
            return nextPosSkipWhiteSpec;
        }
        if (nextChar != 46) {
            bvalid[0] = true;
            parts.add(ItemScanner.generatePart(expr, st - 1, nextPos));
            return nextPosSkipWhiteSpec;
        }
        int posAfterDot = ItemScanner.skipWhiteSpace(expr, nextPosSkipWhiteSpec + 1);
        if (posAfterDot >= length) {
            bvalid[0] = false;
            return posAfterDot;
        }
        int nextnextChar = expr.codePointAt(posAfterDot);
        if (nextnextChar != 91) {
            bvalid[0] = false;
            return posAfterDot;
        }
        parts.add(ItemScanner.generatePart(expr, st - 1, nextPos));
        return ItemScanner.skipBracketName(expr, posAfterDot + 1, bvalid, parts);
    }

    private static int skipWhiteSpace(String expr, int st) {
        int aChar;
        int pos;
        int length = expr.length();
        for (pos = st; pos < length && ItemScanner.isWhiteSpace(aChar = expr.codePointAt(pos)); ++pos) {
        }
        return pos;
    }

    private static int skipPart(String expr, int st) {
        int c;
        int pos;
        int length = expr.length();
        for (pos = st; pos < length && (V5QueryExpressionParserTokenValidator.isLetterOrDigit(c = expr.codePointAt(pos)) || c == 95); ++pos) {
        }
        return pos;
    }

    private static int skipBracketPart(String expr, int st) {
        int length = expr.length();
        int pos = st;
        while (pos < length) {
            int aChar = expr.codePointAt(pos);
            if (aChar == 93) {
                if (pos == length - 1) {
                    return length;
                }
                int nextPos = pos + 1;
                if (nextPos < length && expr.codePointAt(nextPos) == 93) {
                    pos = nextPos + 1;
                    continue;
                }
                return nextPos;
            }
            ++pos;
        }
        return pos;
    }

    private static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13;
    }

    private static int skipMacro(String expr, int st) {
        int length = expr.length();
        int pos = st;
        while (pos < length) {
            int aChar = expr.codePointAt(pos);
            if (aChar == 35) {
                return ++pos;
            }
            if (aChar == 39) {
                pos = ItemScanner.skipSingleQuoteString(expr, pos + 1);
                continue;
            }
            if (aChar == 34) {
                pos = ItemScanner.skipDoubleQuoteString(expr, pos + 1);
                continue;
            }
            if (aChar == 63) {
                pos = ItemScanner.skipPrompt(expr, pos + 1);
                continue;
            }
            if (ItemScanner.isComment(expr, pos)) {
                pos = ItemScanner.skipComment(expr, pos + 2);
                continue;
            }
            if (ItemScanner.isMultiLineComment(expr, pos)) {
                pos = ItemScanner.skipMultiLineComment(expr, pos + 2);
                continue;
            }
            ++pos;
        }
        return pos;
    }

    private static boolean isComment(String expr, int st) {
        int length = expr.length();
        if (st + 1 < length) {
            int firstChar = expr.codePointAt(st);
            int secondChar = expr.codePointAt(st + 1);
            return firstChar == 47 && secondChar == 47 || firstChar == 45 && secondChar == 45;
        }
        return false;
    }

    private static boolean isMultiLineComment(String expr, int st) {
        int length = expr.length();
        if (st + 1 < length) {
            int firstChar = expr.codePointAt(st);
            int secondChar = expr.codePointAt(st + 1);
            return firstChar == 47 && secondChar == 42;
        }
        return false;
    }

    private static int skipSingleQuoteString(String expr, int st) {
        int length = expr.length();
        int pos = st;
        while (pos < length) {
            int aChar = expr.codePointAt(pos);
            if (aChar == 39) {
                if (pos == length - 1) {
                    return length;
                }
                int nextPos = pos + 1;
                if (nextPos < length && expr.codePointAt(nextPos) == 39) {
                    pos = nextPos + 1;
                    continue;
                }
                return nextPos;
            }
            ++pos;
        }
        return pos;
    }

    private static int skipDoubleQuoteString(String expr, int st) {
        int length = expr.length();
        int pos = st;
        while (pos < length) {
            int aChar = expr.codePointAt(pos);
            if (aChar == 34) {
                if (pos == length - 1) {
                    return length;
                }
                int nextPos = pos + 1;
                if (nextPos < length && expr.codePointAt(nextPos) == 34) {
                    pos = nextPos + 1;
                    continue;
                }
                return nextPos;
            }
            ++pos;
        }
        return pos;
    }

    private static int skipPrompt(String expr, int st) {
        int pos;
        int length = expr.length();
        for (pos = st; pos < length; ++pos) {
            int aChar = expr.codePointAt(pos);
            if (aChar != 63) continue;
            return ++pos;
        }
        return pos;
    }

    private static int skipComment(String expr, int st) {
        int pos;
        int length = expr.length();
        for (pos = st; pos < length; ++pos) {
            int aChar = expr.codePointAt(pos);
            if (aChar != 10 && aChar != 13) continue;
            return ++pos;
        }
        return pos;
    }

    private static int skipMultiLineComment(String expr, int st) {
        int pos;
        int length = expr.length();
        for (pos = st; pos < length; ++pos) {
            int nextPos;
            int aChar = expr.codePointAt(pos);
            if (aChar != 42 || (nextPos = pos + 1) >= length || expr.codePointAt(nextPos) != 47) continue;
            return ++nextPos;
        }
        return pos;
    }

    public static String replaceIdForExpr(String targetObjType, String expr, String targetIdforExpr, String srcObjType, String oldSrcId, String newSrcId) {
        if (expr == null || expr.isEmpty()) {
            return null;
        }
        boolean bChanged = false;
        StringBuilder sb = new StringBuilder();
        String[] srcParts = oldSrcId.split("\\.");
        int length = expr.length();
        int pos = 0;
        while (pos < length) {
            int st;
            String newPart;
            boolean b;
            int nextpos;
            ArrayList<String> parts;
            boolean[] bvalid;
            int aChar = expr.codePointAt(pos);
            int oldPos = pos;
            if (aChar == 35) {
                pos = ItemScanner.skipMacro(expr, pos + 1);
                sb.append(ItemScanner.generatePart(expr, oldPos, pos));
                continue;
            }
            if (aChar == 39) {
                pos = ItemScanner.skipSingleQuoteString(expr, pos + 1);
                sb.append(ItemScanner.generatePart(expr, oldPos, pos));
                continue;
            }
            if (aChar == 34) {
                pos = ItemScanner.skipDoubleQuoteString(expr, pos + 1);
                sb.append(ItemScanner.generatePart(expr, oldPos, pos));
                continue;
            }
            if (aChar == 63) {
                pos = ItemScanner.skipPrompt(expr, pos + 1);
                sb.append(ItemScanner.generatePart(expr, oldPos, pos));
                continue;
            }
            if (ItemScanner.isComment(expr, pos)) {
                pos = ItemScanner.skipComment(expr, pos + 2);
                sb.append(ItemScanner.generatePart(expr, oldPos, pos));
                continue;
            }
            if (ItemScanner.isMultiLineComment(expr, pos)) {
                pos = ItemScanner.skipMultiLineComment(expr, pos + 2);
                sb.append(ItemScanner.generatePart(expr, oldPos, pos));
                continue;
            }
            if (V5QueryExpressionParserTokenValidator.isLetter(aChar) || aChar == 95) {
                bvalid = new boolean[]{true};
                parts = new ArrayList<String>();
                nextpos = ItemScanner.skipIdentifier(expr, pos + 1, bvalid, parts);
                b = false;
                if (bvalid[0] && !parts.isEmpty() && ItemScanner.isValidId(parts) && (newPart = ItemScanner.matchOp(parts, targetObjType, srcParts, srcObjType, newSrcId, false, targetIdforExpr)) != null) {
                    sb.append(newPart);
                    bChanged = true;
                    b = true;
                    st = ItemScanner.getWhiteSpace(expr, nextpos - 1);
                    if (st >= 0) {
                        sb.append(ItemScanner.generatePart(expr, st, nextpos));
                    }
                }
                pos = nextpos;
                if (b) continue;
                sb.append(ItemScanner.generatePart(expr, oldPos, pos));
                continue;
            }
            if (aChar == 91) {
                bvalid = new boolean[]{true};
                parts = new ArrayList();
                nextpos = ItemScanner.skipBracketName(expr, pos + 1, bvalid, parts);
                b = false;
                if (bvalid[0] && !parts.isEmpty() && (newPart = ItemScanner.matchOp(parts, targetObjType, srcParts, srcObjType, newSrcId, true, targetIdforExpr)) != null) {
                    sb.append(newPart);
                    bChanged = true;
                    b = true;
                    st = ItemScanner.getWhiteSpace(expr, nextpos - 1);
                    if (st >= 0) {
                        sb.append(ItemScanner.generatePart(expr, st, nextpos));
                    }
                }
                pos = nextpos;
                if (b) continue;
                sb.append(ItemScanner.generatePart(expr, oldPos, pos));
                continue;
            }
            sb.append(ItemScanner.generatePart(expr, oldPos, ++pos));
        }
        if (!bChanged) {
            return null;
        }
        return sb.toString();
    }

    private static int getWhiteSpace(String expr, int lastPos) {
        int aChar;
        int st = -1;
        int i = lastPos;
        while (i >= 0 && ItemScanner.isWhiteSpace(aChar = expr.codePointAt(i))) {
            st = i--;
        }
        return st;
    }

    private static String matchOp(ArrayList<String> parts, String targetObjType, String[] srcParts, String srcObjType, String newSrcId, boolean bBracket, String targetIdforExpr) {
        if ("Calculation".equals(srcObjType)) {
            if (!"Calculation".equals(targetObjType) && !"Filter".equals(targetObjType)) {
                return null;
            }
            return ItemScanner.matchGlobalCalcFilter(srcParts, parts, newSrcId, bBracket);
        }
        if ("QuerySubject".equals(srcObjType)) {
            if (!("Calculation".equals(targetObjType) || "Filter".equals(targetObjType) || "QueryItem".equals(targetObjType))) {
                return null;
            }
            return ItemScanner.matchQuerySubject(srcParts, parts, newSrcId, bBracket);
        }
        if ("QueryItem".equals(srcObjType)) {
            if (!("Calculation".equals(targetObjType) || "Filter".equals(targetObjType) || "QueryItem".equals(targetObjType))) {
                return null;
            }
            return ItemScanner.matchQueryItem(srcParts, parts, newSrcId, bBracket, targetObjType, targetIdforExpr);
        }
        return null;
    }

    private static String matchGlobalCalcFilter(String[] srcParts, ArrayList<String> targetParts, String newSrcId, boolean bBracket) {
        if (srcParts.length != 1 || targetParts.size() != 1) {
            return null;
        }
        String target = targetParts.get(0);
        if (bBracket) {
            target = target.substring(1, target.length() - 1);
        }
        if (srcParts[0].equals(target)) {
            if (bBracket) {
                return "[" + newSrcId + "]";
            }
            return newSrcId;
        }
        return null;
    }

    private static String matchQuerySubject(String[] srcParts, ArrayList<String> targetParts, String newSrcId, boolean bBracket) {
        if (srcParts.length != 1 || targetParts.isEmpty()) {
            return null;
        }
        if (targetParts.size() == 1) {
            String[] parts;
            String target = targetParts.get(0);
            if (bBracket && (parts = (target = target.substring(1, target.length() - 1)).split("\\.")).length > 1 && srcParts[0].equals(parts[0])) {
                parts[0] = newSrcId;
                return "[" + ItemScanner.generateIdFromParts(parts, 0) + "]";
            }
        } else {
            String[] parts = ItemScanner.generateParts(targetParts);
            if (parts.length > 1) {
                if (bBracket) {
                    String p = "[" + srcParts[0] + "]";
                    if (p.equals(parts[0])) {
                        parts[0] = "[" + newSrcId + "]";
                        return ItemScanner.generateIdFromParts(parts, 0);
                    }
                } else if (srcParts[0].equals(parts[0])) {
                    parts[0] = newSrcId;
                    return ItemScanner.generateIdFromParts(parts, 0);
                }
            }
        }
        return null;
    }

    private static String matchQueryItem(String[] srcParts, ArrayList<String> targetParts, String newSrcId, boolean bBracket, String targetObjType, String targetIdforExpr) {
        if (srcParts.length < 2) {
            return null;
        }
        if ("Calculation".equals(targetObjType) || "Filter".equals(targetObjType)) {
            return ItemScanner.matchQueryItemByIdForExpr(srcParts, targetParts, newSrcId, bBracket);
        }
        if ("QueryItem".equals(targetObjType)) {
            String[] targetQIParts = targetIdforExpr.split("\\.");
            if (!srcParts[0].equals(targetQIParts[0])) {
                return ItemScanner.matchQueryItemByIdForExpr(srcParts, targetParts, newSrcId, bBracket);
            }
            String[] tParts = ItemScanner.generateParts(targetParts);
            String target = tParts[0];
            if (bBracket) {
                target = target.substring(1, target.length() - 1);
            }
            if (!srcParts[0].equals(target) && ItemScanner.partsEquals(srcParts, tParts, bBracket, 1)) {
                String[] parts = newSrcId.split("\\.");
                if (bBracket) {
                    for (int i = 0; i < parts.length; ++i) {
                        parts[i] = "[" + parts[i] + "]";
                    }
                }
                return ItemScanner.generateIdFromParts(parts, 1);
            }
            return ItemScanner.matchQueryItemByIdForExpr(srcParts, targetParts, newSrcId, bBracket);
        }
        return null;
    }

    private static String matchQueryItemByIdForExpr(String[] srcParts, ArrayList<String> targetParts, String newSrcId, boolean bBracket) {
        if (targetParts.size() == 1) {
            if (bBracket) {
                String target = targetParts.get(0);
                String[] parts = (target = target.substring(1, target.length() - 1)).split("\\.");
                if (ItemScanner.partsEquals(srcParts, parts, false, 0)) {
                    return "[" + newSrcId + "]";
                }
            }
        } else {
            String[] tParts = ItemScanner.generateParts(targetParts);
            if (ItemScanner.partsEquals(srcParts, tParts, bBracket, 0)) {
                if (bBracket) {
                    String[] parts = newSrcId.split("\\.");
                    for (int i = 0; i < parts.length; ++i) {
                        parts[i] = "[" + parts[i] + "]";
                    }
                    return ItemScanner.generateIdFromParts(parts, 0);
                }
                return newSrcId;
            }
        }
        return null;
    }

    private static String generateIdFromParts(String[] parts, int st) {
        StringBuilder sb = new StringBuilder();
        for (int i = st; i < parts.length; ++i) {
            if (i != st) {
                sb.append(".");
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    protected static boolean partsEquals(String[] srcParts, String[] parts, boolean bBracket, int st) {
        int srcLength = srcParts.length - st;
        if (srcLength <= 0 || srcLength != parts.length) {
            return false;
        }
        int i = st;
        int j = 0;
        while (i < srcParts.length) {
            String target = parts[j];
            if (bBracket) {
                target = target.substring(1, target.length() - 1);
            }
            if (!srcParts[i].equals(target)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }
}

