/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.storageservice.application;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.storageservice.application.StorageService;
import com.ibm.bi.storageservice.utils.LearningType;
import com.ibm.bi.storageservice.utils.Utils;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileStorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(UserProfileStorageService.class);
    private static final String REC_MODEL = "recommendationModel";

    @Override
    public boolean storeRecModel(String recModelString, LearningType learningType, RESTClient client) {
        boolean isModelStored;
        block7: {
            String upsUrl = "/bi/v1/users/~/" + learningType.getText();
            isModelStored = true;
            if ((recModelString = Utils.compressRecModel(recModelString)) != null) {
                JsonObject document = new JsonObject();
                document.put(REC_MODEL, (Object)recModelString);
                try {
                    String existingRecModelId = this.getExistingRecModelId(client, learningType);
                    if (existingRecModelId != null) {
                        upsUrl = upsUrl + "/" + existingRecModelId;
                        client.updateResource(upsUrl, "application/json", document);
                    } else {
                        client.createResource(upsUrl, "application/json", document);
                    }
                    Response.Status storeRecModelStatus = Response.Status.fromStatusCode((int)client.getResponseCode());
                    if (storeRecModelStatus.getFamily() == Response.Status.Family.SUCCESSFUL) {
                        log.info("Recommendation Model successfully stored in UPS");
                        break block7;
                    }
                    log.error(UserProfileStorageService.getErrorString(client.getErrorResponseString()));
                    isModelStored = false;
                }
                catch (IOException e) {
                    log.error(UserProfileStorageService.getErrorString(e.getMessage()));
                }
            } else {
                log.error("Error storing Recommendation Model in UPS because compression of model failed");
                isModelStored = false;
            }
        }
        return isModelStored;
    }

    @Override
    public String getRecModel(RESTClient restClient, LearningType learningType) {
        String url = "/bi/v1/users/~/" + learningType.getText();
        String recModel = "";
        long startTime = System.currentTimeMillis();
        try {
            JsonArray response = restClient.getResources(url, "application/json");
            if (response != null && !response.isEmpty()) {
                JsonObject offlineRecModelResult = response.getObject(0);
                recModel = offlineRecModelResult.getString(REC_MODEL);
                log.info("Fetched Recommendation Model  " + recModel);
            }
        }
        catch (Exception e) {
            log.error("Could not fetch Recommendation Model " + e.getMessage());
        }
        log.info("Fetching Recommendation Model from UPS took: " + (System.currentTimeMillis() - startTime) + " ms");
        return recModel;
    }

    public String getUncompressedRecModel(RESTClient restClient, LearningType learningType) {
        String compressedRecModel = this.getRecModel(restClient, learningType);
        return Utils.uncompressRecModel(compressedRecModel);
    }

    @Override
    public void deleteRecModel(RESTClient restClient, LearningType learningType) {
        String id = this.getExistingRecModelId(restClient, learningType);
        if (id != null) {
            String url = "/bi/v1/users/~/" + learningType.getText() + "/" + id;
            try {
                restClient.deleteResource(url, "application/json");
            }
            catch (IOException e) {
                log.info("Failed to delete model: " + id);
            }
        }
    }

    private String getExistingRecModelId(RESTClient restClient, LearningType learningType) {
        String url = "/bi/v1/users/~/" + learningType.getText();
        String existingRecModelId = null;
        long startTime = System.currentTimeMillis();
        try {
            JsonArray response = restClient.getResources(url, "application/json");
            if (response != null && !response.isEmpty()) {
                JsonObject offlineRecModelResult = response.getObject(0);
                existingRecModelId = offlineRecModelResult.getString("id");
                log.info("Fetched existing Recommendation Model Id: " + existingRecModelId);
            } else {
                log.info("No existing Recommendation Model found");
            }
        }
        catch (Exception e) {
            log.error("Could not get existing Recommendation Model " + e.getMessage());
        }
        log.info("Fetching existing Recommendation Model from UPS took: " + (System.currentTimeMillis() - startTime) + " ms");
        return existingRecModelId;
    }

    private static String getErrorString(String errorString) {
        return "Error storing Recommendation Model in UPS " + errorString;
    }
}

