/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.bi.recommendationmodel.Column;

public class Slot {
    private String name;
    @JsonProperty(value="columns")
    private Column columns;

    protected Slot(String name, int columnSize) {
        this.name = name;
        this.columns = new Column();
        this.columns.setColumnCount(columnSize);
    }

    @JsonIgnore
    public Column getColumns() {
        return this.columns;
    }

    @JsonGetter
    public String getName() {
        return this.name;
    }

    protected Slot() {
    }

    protected Slot(Slot slot, double freqWeight) {
        this.name = slot.getName();
        this.columns = new Column(slot.getColumns(), freqWeight);
    }

    protected void merge(Slot targetSlot) {
        Column targetColumns = this.getColumns();
        Column sourceColumns = targetSlot.getColumns();
        targetColumns.merge(sourceColumns);
    }
}

