/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.bi.recommendationmodel.StatisticBucketRange;
import com.ibm.bi.recommendationmodel.StatisticBucketSerializer;
import com.ibm.bi.recommendationmodel.StatisticType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonSerialize(using=StatisticBucketSerializer.class)
public class StatisticBucket {
    private Double start;
    private Double end;
    private int frequency;

    protected StatisticBucket(Double start, Double end) {
        this.start = start;
        this.end = end;
        this.frequency = 0;
    }

    protected StatisticBucket(StatisticBucket inputStatisticBucket, Double inputRecModelWeight) {
        this.start = inputStatisticBucket.getStart();
        this.end = inputStatisticBucket.getEnd();
        this.frequency = (int)Math.round((double)inputStatisticBucket.getFrequency() * inputRecModelWeight);
    }

    public void incrementFrequency() {
        ++this.frequency;
    }

    @JsonCreator
    protected StatisticBucket(@JsonProperty(value="start") Double start, @JsonProperty(value="end") Double end, @JsonProperty(value="frequency") int frequency) {
        this.start = start;
        this.end = end;
        this.frequency = frequency;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public double getStart() {
        return this.start == null ? Double.NEGATIVE_INFINITY : this.start;
    }

    public double getEnd() {
        return this.end == null ? Double.POSITIVE_INFINITY : this.end;
    }

    protected void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public Boolean isValueWithinRange(Double value) {
        double bucketStart = this.getStart();
        double bucketEnd = this.getEnd();
        Double roundedValue = (double)Math.round(value * 100.0) / 100.0;
        return roundedValue >= bucketStart && roundedValue <= bucketEnd;
    }

    public static StatisticBucket getStatisticBucketRange(StatisticType statisticType, Double value) {
        if (statisticType != null) {
            switch (statisticType) {
                case DISTINCT_COUNT: {
                    ArrayList<StatisticBucket> distinctCount = new ArrayList<StatisticBucket>();
                    for (Map.Entry<Double, Double> entry : StatisticBucketRange.DISTINCT_COUNT.entrySet()) {
                        distinctCount.add(new StatisticBucket(entry.getKey(), entry.getValue()));
                    }
                    return StatisticBucket.getStatisticBucketByValue(value, distinctCount);
                }
                case DENSITY: {
                    ArrayList<StatisticBucket> density = new ArrayList<StatisticBucket>();
                    for (Map.Entry<Double, Double> entry : StatisticBucketRange.DENSITY.entrySet()) {
                        density.add(new StatisticBucket(entry.getKey(), entry.getValue()));
                    }
                    return StatisticBucket.getStatisticBucketByValue(value, density);
                }
                case MIN_VALUE: {
                    ArrayList<StatisticBucket> min = new ArrayList<StatisticBucket>();
                    for (Map.Entry<Double, Double> entry : StatisticBucketRange.MIN.entrySet()) {
                        min.add(new StatisticBucket(entry.getKey(), entry.getValue()));
                    }
                    return StatisticBucket.getStatisticBucketByValue(value, min);
                }
                case MAX_VALUE: {
                    ArrayList<StatisticBucket> max = new ArrayList<StatisticBucket>();
                    for (Map.Entry<Double, Double> entry : StatisticBucketRange.MAX.entrySet()) {
                        max.add(new StatisticBucket(entry.getKey(), entry.getValue()));
                    }
                    return StatisticBucket.getStatisticBucketByValue(value, max);
                }
            }
        }
        return null;
    }

    public static StatisticBucket getStatisticBucketByValue(Double value, List<StatisticBucket> statisticBucketList) {
        return statisticBucketList.stream().filter(statisticBucket -> statisticBucket.isValueWithinRange(value)).findFirst().orElse(null);
    }

    protected Boolean isEqual(StatisticBucket sourceStatBucket) {
        return Objects.equals(this.getStart(), sourceStatBucket.getStart()) && Objects.equals(this.getEnd(), sourceStatBucket.getEnd());
    }

    protected void merge(StatisticBucket sourceDistinctCount) {
        this.frequency += sourceDistinctCount.getFrequency();
    }
}

