/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.stats.strategy;

import com.ibm.smarts.dds.core.numerics.Column;
import com.ibm.smarts.dds.core.numerics.StatsKey;
import com.ibm.smarts.dds.core.stats.strategy.CommonStatsStrategy;
import com.ibm.smarts.model.value.IntegerValue;
import com.ibm.smarts.model.value.LongValue;
import com.ibm.smarts.model.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NominalStatsStrategy
extends CommonStatsStrategy {
    private static final Logger logger = LoggerFactory.getLogger(NominalStatsStrategy.class);
    private static final int MAX_COLUMN_CATEGORIES = 50;
    private static final int MAX_DISTINCT_SAMPLES = 1000;
    private Map<String, Integer> indexMap;
    private int indexCount;

    @Override
    public void calculateStats(Column column) {
        super.calculateStats(column);
        if (column.getSamples().isEmpty()) {
            logger.info("There are no samples for column: {} , statistics will not be calculated", (Object)column.getId());
            return;
        }
        Map<String, Long> counts = column.getSamples().stream().filter(s -> Objects.nonNull(s) && StringUtils.isNotBlank((CharSequence)s.stringValue())).collect(Collectors.groupingBy(s -> s.stringValue(), Collectors.counting()));
        List entries = counts.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
        ArrayList<String> allCategories = new ArrayList<String>();
        ArrayList<Integer> allFrequencies = new ArrayList<Integer>();
        int nValid = 0;
        for (int i = 0; i < entries.size(); ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            int n = ((Long)entry.getValue()).intValue();
            if (i < 1000) {
                allCategories.add((String)entry.getKey());
                allFrequencies.add(n);
            }
            nValid += n;
        }
        int countCaseInsensitive = 0;
        HashSet<String> categoriesLowercased = new HashSet<String>();
        for (String category : counts.keySet()) {
            if (!categoriesLowercased.add(category.toLowerCase())) continue;
            ++countCaseInsensitive;
        }
        column.setUnivariateStat(StatsKey.unique, (Value)new LongValue((long)countCaseInsensitive));
        column.setUnivariateStat(StatsKey.valid, (Value)new IntegerValue(nValid));
        column.setUnivariateStat(StatsKey.validNumeric, (Value)new IntegerValue(0));
        this.setSampleDistinctValues(allCategories);
        this.setSampleDistinctValuesCount(allFrequencies);
        column.setUseful(NominalStatsStrategy.isUseful(column));
        int maxCategories = Math.min(entries.size(), 50);
        this.makeIndexMap(allCategories.subList(0, maxCategories), allFrequencies.subList(0, maxCategories));
        this.setDensityEstimation(column);
    }

    private static boolean isUseful(Column col) {
        List<Integer> counts = col.getSampleDistinctValuesCount();
        return !counts.isEmpty() && counts.get(0) >= 3;
    }

    @Override
    public int getGroupCount() {
        return Math.min(50, this.getSampleDistinctValues().size());
    }

    private void makeIndexMap(List<String> mostFrequent, List<Integer> frequencies) {
        List<Integer> counts = frequencies;
        if (counts.isEmpty() || counts.get(0) < 3) {
            this.indexMap = null;
            this.indexCount = 0;
        }
        List<String> categories = mostFrequent;
        this.indexMap = new HashMap<String, Integer>(categories.size());
        for (int i = 0; i < categories.size(); ++i) {
            this.indexMap.put(categories.get(i), i);
        }
        this.indexCount = this.indexMap.size();
    }

    @Override
    public int getCategoryCount() {
        return this.indexCount;
    }

    @Override
    public Map<String, Integer> getCategoryIndex() {
        return this.indexMap;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }
}

