/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.value.decor;

import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import java.util.function.Function;

public class UniformValueDecorator {
    private UniformValueDecorator() {
    }

    public static boolean evaluateUniformValues(ColumnInfo column) {
        DataType dt = column.getDataType();
        if (dt.isNumeric()) {
            return UniformValueDecorator.evaluateUniformNumericValues(column);
        }
        if (dt.isString()) {
            return UniformValueDecorator.evaluateUniformStringValues(column);
        }
        return false;
    }

    private static boolean evaluateUniformStringValues(ColumnInfo column) {
        int len = -1;
        for (String sample : column.getSamples()) {
            if (sample == null || sample.length() == 0) continue;
            if (len == -1) {
                len = sample.length();
                continue;
            }
            if (len == sample.length()) continue;
            return false;
        }
        return true;
    }

    private static boolean evaluateUniformNumericValues(ColumnInfo column) {
        int maxLen;
        Function<StatisticType, Statistic> statistic = t -> column.getStatistics().stream().filter(s -> s.getType() == t).findFirst().orElse(null);
        Statistic minValue = statistic.apply(StatisticType.MIN_VALUE);
        Statistic maxValue = statistic.apply(StatisticType.MAX_VALUE);
        if (minValue == null || maxValue == null || minValue.getValue() == null || maxValue.getValue() == null || minValue.getValue().isNull() || maxValue.getValue().isNull()) {
            return false;
        }
        int minLen = minValue.getValue().stringValue().length();
        return minLen == (maxLen = maxValue.getValue().stringValue().length());
    }
}

