/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.modifiers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterAggregation;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.NumericOperator;
import com.ibm.smarts.common.modifiers.PreOrPostAggregation;
import com.ibm.smarts.schema.AggregationType;
import java.util.Objects;

public class NumericFilter
extends BaseFilter {
    private String value;
    private NumericOperator operator = NumericOperator.EQUALS;
    private FilterAggregation filterAggregation;

    @JsonCreator
    public NumericFilter(@JsonProperty(value="columnId") String columnId, @JsonProperty(value="filterId") String filterId, @JsonProperty(value="label") String label, @JsonProperty(value="value") String value, @JsonProperty(value="op") NumericOperator op) {
        super(columnId, filterId, label);
        this.setValue(value);
        this.setOperator(op);
    }

    public NumericFilter(String columnId, String filterId, String label, String value, NumericOperator op, FilterAggregation filterAggregation) {
        this(columnId, filterId, label, value, op);
        this.setFilterAggregation(filterAggregation);
    }

    public NumericFilter(NumericFilter source) {
        super(source.getColumnId(), source.getFilterId(), source.getLabel());
        this.setValue(source.getValue());
        this.setOperator(source.getOperator());
        this.setFilterAggregation(source.getFilterAggregation());
    }

    public static NumericFilter negate(NumericFilter source) {
        NumericFilter filter = new NumericFilter(source);
        NumericOperator operator = filter.getOperator();
        FilterAggregation filterAggregation = filter.getFilterAggregation();
        switch (source.getOperator()) {
            case LESS_THAN: {
                operator = NumericOperator.GREATER_THAN;
                break;
            }
            case GREATER_THAN: {
                operator = NumericOperator.LESS_THAN;
                break;
            }
            case LESS_THAN_EQUALS: {
                operator = NumericOperator.GREATER_THAN_EQUALS;
                break;
            }
            case GREATER_THAN_EQUALS: {
                operator = NumericOperator.LESS_THAN_EQUALS;
                break;
            }
            case EQUALS: {
                operator = NumericOperator.NOT_EQUALS;
                break;
            }
            case NOT_EQUALS: {
                operator = NumericOperator.EQUALS;
            }
        }
        filter.setOperator(operator);
        filter.setFilterAggregation(filterAggregation);
        return filter;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public NumericOperator getOperator() {
        return this.operator;
    }

    public void setOperator(NumericOperator op) {
        this.operator = op;
    }

    public FilterAggregation getFilterAggregation() {
        return this.filterAggregation;
    }

    public void setFilterAggregation(FilterAggregation filterAggregation) {
        this.filterAggregation = filterAggregation != null ? filterAggregation : new FilterAggregation(AggregationType.NONE, PreOrPostAggregation.PRE);
    }

    @Override
    public FilterType getType() {
        return FilterType.NUMERIC;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        super.toJSONObject(obj);
        obj.put((Object)"value", (Object)this.getValue());
        obj.put((Object)"operator", (Object)this.getOperator().name());
        if (this.getFilterAggregation() != null) {
            JSONObject filterAggregationObj = new JSONObject();
            filterAggregationObj.put((Object)"preOrPostAggregation", (Object)this.getFilterAggregation().getPreOrPostAggregation().name());
            filterAggregationObj.put((Object)"aggregationType", (Object)this.getFilterAggregation().getAggregationType().name());
            obj.put((Object)"filterAggregation", (Object)filterAggregationObj);
        }
        return obj;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumericFilter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NumericFilter that = (NumericFilter)o;
        return Objects.equals(this.getValue(), that.getValue()) && this.getOperator() == that.getOperator() && Objects.equals(this.getFilterAggregation(), that.getFilterAggregation());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getValue(), this.getOperator(), this.getFilterAggregation()});
    }
}

