/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq;

import com.ibm.smarts.common.mq.SmartsModuleMessageGroup;
import com.ibm.smarts.common.mq.SmartsModuleTask;
import com.ibm.smarts.common.mq.function.SmartsModuleFunction;
import com.ibm.smarts.common.mq.function.SmartsModuleFunctionResult;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.mq.message.SmartsModuleStatus;
import com.ibm.smarts.core.api.Handlers;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.mq.TypedMessageConsumer;
import com.ibm.smarts.core.mq.TypedMessageProducer;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.util.RequestContext;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModuleConsumer<T extends SmartsModuleMessage>
implements TypedMessageConsumer<T>,
Handlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModuleConsumer.class);
    protected final SmartsModuleTask task;
    protected final SmartsModuleFunction<T> function;

    public SmartsModuleConsumer(SmartsModuleTask task, SmartsModuleFunction<T> function) {
        this.task = task;
        this.function = function;
    }

    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, T message) {
        SmartsModuleStatus status = ((SmartsModuleMessage)message).getStatus();
        SmartsModuleFunctionResult functionResult = null;
        if (status == null || status.isSuccess() || !this.task.applyOnSuccessOnly) {
            try {
                functionResult = (SmartsModuleFunctionResult)this.handle(Handlers.onBehalfOf(this.function), rc, context -> this.function.apply(rc, producerProvider, (SmartsModuleMessage)message));
                status = SmartsModuleStatus.success();
            }
            catch (Throwable e) {
                LOGGER.error("task failed: " + this.task.id, e);
                boolean isSuccess = false;
                boolean includeCause = false;
                ArrayList<String> errors = new ArrayList<String>();
                ArrayList<String> warnings = new ArrayList<String>();
                ArrayList<String> dataSourceExceptions = new ArrayList<String>();
                Throwable c = e.getCause();
                if (c instanceof JaxRs20Exceptions.ResponseProcessingException) {
                    if ((c = c.getCause()) instanceof JaxRs20Exceptions.DataSourceException) {
                        Response response = ((JaxRs20Exceptions.DataSourceException)c).getResponse();
                        dataSourceExceptions.add(response.getEntity().toString());
                        isSuccess = ((JaxRs20Exceptions.DataSourceException)c).isWarning();
                    } else {
                        includeCause = true;
                    }
                }
                if (isSuccess) {
                    warnings.add(e.getMessage());
                    functionResult = new SmartsModuleFunctionResult();
                } else {
                    errors.add(e.getMessage());
                    if (includeCause) {
                        errors.add(c.getMessage());
                    }
                }
                status = new SmartsModuleStatus(isSuccess, errors, warnings, dataSourceExceptions);
            }
        }
        for (String exchange : this.task.outgoingExchanges) {
            SmartsModuleMessage outMessage;
            SmartsModuleMessage smartsModuleMessage = outMessage = functionResult != null ? functionResult.getOutgoingMessage(exchange) : null;
            if (outMessage == null) {
                outMessage = SmartsModuleMessageGroup.messageFor(exchange, ((SmartsModuleMessage)message).getSmartsModuleId(), ((SmartsModuleMessage)message).getDatasetId(), ((SmartsModuleMessage)message).getResourceURI());
            }
            outMessage.setStatus(status);
            TypedMessageProducer producer = producerProvider.producer(SmartsModuleMessage.class);
            producer.takeMessage(SmartsModuleMessageGroup.defaultQueueFor(exchange), (Object)outMessage);
        }
    }

    public Class<T> getItemClass() {
        return this.function.getMessageClass();
    }
}

