/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq.progress;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.mq.SmartsModuleTask;
import com.ibm.smarts.common.mq.message.SmartsModuleStatus;
import com.ibm.smarts.common.mq.progress.SmartsModuleTaskProgress;
import com.ibm.smarts.schema.SmartsModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SmartsModuleProgress {
    public final List<SmartsModuleTask> tasks;
    public final Map<String, SmartsModuleTaskProgress> progress;
    private SmartsModule completedSmartsModule;

    @JsonCreator
    public SmartsModuleProgress(@JsonProperty(value="tasks") List<SmartsModuleTask> tasks, @JsonProperty(value="progress") Map<String, SmartsModuleTaskProgress> progress) {
        this.tasks = tasks;
        this.progress = progress;
    }

    public SmartsModuleProgress(List<SmartsModuleTask> tasks) {
        this(tasks, new HashMap<String, SmartsModuleTaskProgress>());
    }

    public void add(SmartsModuleTaskProgress taskProgress) {
        this.progress.put(taskProgress.taskId, taskProgress);
    }

    public void addAll(List<SmartsModuleTaskProgress> taskProgressList) {
        taskProgressList.forEach(this::add);
    }

    public SmartsModuleTaskProgress getTaskProgress(String taskId) {
        return this.progress.get(taskId);
    }

    @JsonIgnore
    public boolean isDone() {
        return this.incompleteTasks().isEmpty();
    }

    public List<SmartsModuleTask> incompleteTasks() {
        ArrayList<SmartsModuleTask> result = new ArrayList<SmartsModuleTask>();
        if (this.tasks != null) {
            for (SmartsModuleTask task : this.tasks) {
                SmartsModuleTaskProgress taskProgress = this.progress.get(task.id);
                if (taskProgress != null && taskProgress.isDone()) continue;
                result.add(task);
            }
        }
        return result;
    }

    public List<SmartsModuleTask> completedTasks() {
        ArrayList<SmartsModuleTask> result = new ArrayList<SmartsModuleTask>();
        for (SmartsModuleTask task : this.tasks) {
            SmartsModuleTaskProgress taskProgress = this.progress.get(task.id);
            if (taskProgress == null || !taskProgress.isDone()) continue;
            result.add(task);
        }
        return result;
    }

    public Map<SmartsModuleTask, SmartsModuleStatus> completedTasks(String key) {
        HashMap<SmartsModuleTask, SmartsModuleStatus> result = new HashMap<SmartsModuleTask, SmartsModuleStatus>();
        for (SmartsModuleTask task : this.tasks) {
            SmartsModuleTaskProgress taskProgress = this.progress.get(task.id);
            if (taskProgress == null) {
                result.put(task, new SmartsModuleStatus(false, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>()));
                continue;
            }
            SmartsModuleStatus status = taskProgress.getStatus(key);
            if (status == null) continue;
            result.put(task, status);
        }
        return result;
    }

    public void setCompletedSmartsModule(SmartsModule completedSmartsModule) {
        this.completedSmartsModule = completedSmartsModule;
    }

    public SmartsModule getCompletedSmartsModule() {
        return this.completedSmartsModule;
    }
}

