/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.rest.util;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.smarts.core.api.Credentials;
import com.ibm.smarts.core.api.ICredentials;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.exceptions.ServiceException;
import com.ibm.smarts.core.exceptions.json.JsonSerializeException;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.Request;
import com.ibm.smarts.core.util.RequestContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServiceUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(RestServiceUtil.class);
    private static final String BA_SECURITY_HEADER = "ba-scx-subscription";
    private static final String BA_SECURITY_HEADER_TID = "tid";
    private static final String BA_SECURITY_HEADER_USERID = "userid";
    private static final String KEY_VALUE_SEPARATER = "=";
    private static final String SECTION_SEPARATER = ";";
    private static final String UTF_8 = "UTF-8";

    public static Response GETjson(Object obj) {
        return RestServiceUtil.createResponse(Response.Status.OK, obj);
    }

    public static Response POSTjson(Object obj) {
        return RestServiceUtil.createResponse(Response.Status.CREATED, obj);
    }

    public static Response PUTjson(Object obj) {
        return RestServiceUtil.createResponse(Response.Status.OK, obj);
    }

    public static Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public static Response badRequest() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    public static Response forbidden() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public static Response createResponse(Response.Status status, Object obj) {
        String json;
        if (obj == null) {
            json = "{}";
        } else if (obj instanceof String) {
            json = (String)obj;
        } else {
            try {
                json = JsonParserHelper.toJson((Object)obj);
            }
            catch (JsonSerializeException ex) {
                LOGGER.error("Failed to generate JSON", (Throwable)ex);
                return RestServiceUtil.handleException(ex);
            }
        }
        return RestServiceUtil.getResponse(status, json);
    }

    public static Response getResponse(Response.Status statusCode, String entity) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)statusCode);
        String res = entity;
        return responseBuilder.entity((Object)res).type("application/json").build();
    }

    public static Response handleException(Throwable th) {
        Object serviceException = th instanceof ServiceException ? (ServiceException)th : new InternalException(th, th.getMessage(), new Object[0]);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        ObjectNode error = root.putObject("error");
        error.put("status", serviceException.httpStatus);
        error.put("error_code", serviceException.msg.name);
        String message = serviceException.getMessage();
        if (serviceException.getCause() != null) {
            LOGGER.error(message, serviceException.getCause());
        } else {
            LOGGER.error(message, (Object)serviceException.getLocalizedMessage());
        }
        error.put("message", message);
        Response.ResponseBuilder responseBuilder = Response.status((int)serviceException.httpStatus);
        Response ret = responseBuilder.entity((Object)root.toString()).type("application/json").build();
        return ret;
    }

    private static Map<String, List<String>> buildHeaderMap(HttpHeaders httpHeaders) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        MultivaluedMap mm = httpHeaders.getRequestHeaders();
        for (String key : mm.keySet()) {
            ArrayList<String> newValues = new ArrayList<String>();
            List values = httpHeaders.getRequestHeader(key);
            if (values != null) {
                for (String value : values) {
                    newValues.add(value);
                }
            }
            ret.put(key, newValues);
        }
        return ret;
    }

    public static RequestContext extractRequestContext(HttpHeaders httpHeaders) {
        Locale locale = Locale.getDefault();
        Locale productLocale = Locale.getDefault();
        Map<String, List<String>> headers = RestServiceUtil.buildHeaderMap(httpHeaders);
        ICredentials cred = RestServiceUtil.extractCredentials(headers);
        Request req = new Request(locale, productLocale, cred);
        RequestContext ret = new RequestContext(req);
        req.setHttpHeaders(headers);
        return ret;
    }

    static ICredentials extractCredentials(Map<String, List<String>> headerProperties) {
        return RestServiceUtil.extractCredentials(headerProperties, BA_SECURITY_HEADER, BA_SECURITY_HEADER_USERID, BA_SECURITY_HEADER_TID);
    }

    private static ICredentials extractCredentials(Map<String, List<String>> headerProperties, String headerKey, String useridKey, String tidKey) {
        String userid = null;
        String tid = null;
        List<String> headerList = headerProperties.get(headerKey);
        if (headerList != null && !headerList.isEmpty()) {
            String header = headerList.get(0);
            String decodedValue = null;
            try {
                String[] splitColon;
                decodedValue = URLDecoder.decode(header, UTF_8);
                for (String str : splitColon = decodedValue.split(SECTION_SEPARATER)) {
                    if (str.startsWith(useridKey)) {
                        userid = RestServiceUtil.extractedHeaderValue(str);
                    }
                    if (!str.startsWith(tidKey)) continue;
                    tid = RestServiceUtil.extractedHeaderValue(str);
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Unable to decode securty header", (Throwable)e);
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userid, tid})) {
            return new Credentials(userid, tid);
        }
        return null;
    }

    private static String extractedHeaderValue(String value) {
        try {
            return value.substring(value.indexOf(KEY_VALUE_SEPARATER) + 1);
        }
        catch (Exception e) {
            return null;
        }
    }
}

