/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core;

import com.ibm.smarts.core.lifecycle.IComponentLifecycle;
import com.ibm.smarts.core.lifecycle.IComponentLifecycleOperations;
import com.ibm.smarts.core.lifecycle.ILifecycleManager;
import com.ibm.smarts.core.lifecycle.IManagedLifecycle;
import com.ibm.smarts.core.lifecycle.LifecycleManager;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.fields.recommender.core.autosuggest.FieldsDiscoverer;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersAnalysisContext;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersDiscoverer;
import com.ibm.smarts.fields.recommender.core.keywords.WeightedKeywordsDiscoverer;
import com.ibm.smarts.fields.recommender.core.targets.TargetsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.targets.TargetsDiscoverer;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.FieldsRecommendationType;
import com.ibm.smarts.schema.InfluencerTuningParams;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.WeightedKeyword;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterestingFieldsRecommenderImpl
implements InterestingFieldsRecommender,
IComponentLifecycle,
IManagedLifecycle {
    private final LifecycleManager clh;
    private final KnowledgeDiscoveryService knowledgeDiscoveryService;
    private final InfluencersDiscoverer influencersDiscoverer;
    private final TargetsDiscoverer targetsDiscoverer;
    private final WeightedKeywordsDiscoverer weightedKeywordsDiscover;
    private final FieldsDiscoverer fieldsDiscover;
    private static final Logger LOGGER = LoggerFactory.getLogger(InterestingFieldsRecommenderImpl.class);

    public InterestingFieldsRecommenderImpl(KnowledgeDiscoveryService kds) {
        this.knowledgeDiscoveryService = kds;
        this.clh = new LifecycleManager((IComponentLifecycle)this, new IComponentLifecycleOperations[0]);
        this.influencersDiscoverer = new InfluencersDiscoverer(this.knowledgeDiscoveryService);
        this.targetsDiscoverer = new TargetsDiscoverer();
        this.weightedKeywordsDiscover = new WeightedKeywordsDiscoverer();
        this.fieldsDiscover = new FieldsDiscoverer();
    }

    @Override
    public FieldsRecommendation recommendInterestingFields(RequestContext requestContext, SmartsModule smartsModule, AnalysisScope scope) {
        return this.recommendInterestingFields(requestContext, smartsModule, scope, null);
    }

    @Override
    public FieldsRecommendation recommendInterestingFields(RequestContext requestContext, SmartsModule smartsModule, AnalysisScope scope, Map<String, Map<Pair<String, String>, BivariateStatistics>> bivariatesMap) {
        Instant before = Instant.now();
        FieldsRecommendation fieldsRecommendation = this.targetsDiscoverer.recommend(new TargetsAnalysisContext(requestContext, smartsModule, scope, bivariatesMap));
        fieldsRecommendation.setType(FieldsRecommendationType.INTERESTING);
        LOGGER.warn(String.format(" Recommending InterestingFields for [%s] took [%s]ms ", smartsModule.getName(), Duration.between(before, Instant.now()).toMillis()));
        return fieldsRecommendation;
    }

    @Override
    public FieldsRecommendation recommendPotentialTargets(RequestContext requestContext, SmartsModule smartsModule, AnalysisScope scope) {
        return this.targetsDiscoverer.recommend(new TargetsAnalysisContext(requestContext, smartsModule, scope, null));
    }

    @Override
    public FieldsRecommendation recommendInfluencers(RequestContext requestContext, SmartsModule smartsModule, String targetFieldID, String targetFieldTableID, AnalysisScope scope) {
        Instant before = Instant.now();
        FieldsRecommendation fieldsRecommendation = this.influencersDiscoverer.recommend(new InfluencersAnalysisContext(requestContext, smartsModule, targetFieldID, targetFieldTableID, scope));
        LOGGER.warn(String.format("Recommending Influencers of [%s] in [%s] took [%s]ms ", targetFieldID, smartsModule.getName(), Duration.between(before, Instant.now()).toMillis()));
        return fieldsRecommendation;
    }

    @Override
    public FieldsRecommendation recommendInfluencers(RequestContext requestContext, SmartsModule smartsModule, String targetFieldIDForExpression, AnalysisScope scope) {
        return this.influencersDiscoverer.recommend(new InfluencersAnalysisContext(requestContext, smartsModule, targetFieldIDForExpression, scope, null, (List<String>)null, null));
    }

    @Override
    public FieldsRecommendation recommendInfluencers(RequestContext requestContext, SmartsModule smartsModule, String targetFieldIDForExpression, AnalysisScope scope, InfluencerTuningParams tuningParams) {
        return this.recommendInfluencers(requestContext, smartsModule, targetFieldIDForExpression, scope, tuningParams, (List<String>)null);
    }

    @Override
    public FieldsRecommendation recommendInfluencers(RequestContext requestContext, SmartsModule smartsModule, String targetFieldIDForExpression, AnalysisScope scope, InfluencerTuningParams tuningParams, Set<String> joinableTableIdList) {
        return this.influencersDiscoverer.recommend(new InfluencersAnalysisContext(requestContext, smartsModule, targetFieldIDForExpression, scope, tuningParams, joinableTableIdList, null));
    }

    @Override
    @Nullable
    public FieldsRecommendation recommendInfluencers(@Nonnull RequestContext requestContext, @Nonnull SmartsModule smartsModule, @Nonnull String targetFieldIDForExpression, @Nullable AnalysisScope scope, @Nullable InfluencerTuningParams tuningParams, @Nullable List<String> relatedFields) {
        return this.influencersDiscoverer.recommend(new InfluencersAnalysisContext(requestContext, smartsModule, targetFieldIDForExpression, scope, tuningParams, relatedFields, null));
    }

    @Override
    public FieldsRecommendation recommendInfluencers(RequestContext requestContext, SmartsModule smartsModule, String targetFieldIDForExpression, AnalysisScope scope, InfluencerTuningParams tuningParams, Set<String> joinableTableIdList, Map<String, Map<Pair<String, String>, BivariateStatistics>> bivariatesMap) {
        Instant before = Instant.now();
        FieldsRecommendation fieldsRecommendation = this.influencersDiscoverer.recommend(new InfluencersAnalysisContext(requestContext, smartsModule, targetFieldIDForExpression, scope, tuningParams, joinableTableIdList, bivariatesMap));
        LOGGER.warn(String.format(" Recommending Influencers of [%s] in [%s] took [%s]ms ", targetFieldIDForExpression, smartsModule.getName(), Duration.between(before, Instant.now()).toMillis()));
        return fieldsRecommendation;
    }

    @Override
    public FieldsRecommendation recommendInfluencers(@Nonnull RequestContext requestContext, @Nonnull SmartsModule smartsModule, @Nonnull String targetFieldIDForExpression, @Nullable AnalysisScope scope, @Nullable InfluencerTuningParams tuningParams, @Nullable List<String> relatedFields, @Nullable Map<String, Map<Pair<String, String>, BivariateStatistics>> bivariatesMap) {
        return this.influencersDiscoverer.recommend(new InfluencersAnalysisContext(requestContext, smartsModule, targetFieldIDForExpression, scope, tuningParams, relatedFields, bivariatesMap));
    }

    @Override
    public List<WeightedKeyword> recommendWeightedKeywords(RequestContext requestContext, SmartsModule smartsModule) {
        FieldsRecommendation interestingFields = this.recommendInterestingFields(requestContext, smartsModule, null);
        return this.weightedKeywordsDiscover.recommend(requestContext, smartsModule, interestingFields);
    }

    @Override
    public FieldsRecommendation getAllFields(RequestContext requestContext, SmartsModule smartsModule) {
        return this.fieldsDiscover.recommend(requestContext, smartsModule);
    }

    public ILifecycleManager getLifecycleManager() {
        return this.clh;
    }

    public void initialize(RequestContext rc) {
        LOGGER.info("<TCL> Component initialize InterestingFieldsRecommender");
    }

    public void shutDown(RequestContext rc) {
        LOGGER.info("<TCL> Component shutdown InterestingFieldsRecommender");
    }

    @Override
    public KnowledgeDiscoveryService getKnowledgeDiscoveryService() {
        return this.knowledgeDiscoveryService;
    }
}

