/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import com.ibm.smarts.model.stats.StatisticsFactory;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import java.util.List;

public class StatisticsUtil {
    private StatisticsUtil() {
    }

    public static Value getStatisticValue(ColumnInfo columnInfo, StatisticType statType) {
        Statistic stat = columnInfo.getStatistics().stream().filter(s -> s.getType() == statType).findFirst().orElse(null);
        if (stat != null) {
            return stat.getValue();
        }
        return null;
    }

    public static void setMaxValue(ColumnInfo columnInfo, Value maxValue) {
        boolean found = false;
        List<Statistic> stats = columnInfo.getStatistics();
        for (int i = 0; i < stats.size() && !found; ++i) {
            Statistic stat = stats.get(i);
            if (stat.getType() != StatisticType.MAX_VALUE) continue;
            stat.setValue(maxValue);
            found = true;
        }
        if (!found) {
            stats.add(StatisticsFactory.createMaxValue(maxValue));
        }
    }

    public static void setMinValue(ColumnInfo columnInfo, Value minValue) {
        boolean found = false;
        List<Statistic> stats = columnInfo.getStatistics();
        for (int i = 0; i < stats.size() && !found; ++i) {
            Statistic stat = stats.get(i);
            if (stat.getType() != StatisticType.MIN_VALUE) continue;
            stat.setValue(minValue);
            found = true;
        }
        if (!found) {
            stats.add(StatisticsFactory.createMaxValue(minValue));
        }
    }
}

