/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.ModuleInfo;
import com.ibm.smarts.model.builder.SmartsModuleInfo;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.common.util.QuerySubjectUtil;
import com.ibm.smarts.pipeline.apis.FlowExecutor;
import com.ibm.smarts.pipeline.apis.IContext;
import com.ibm.smarts.pipeline.apis.IProgressUpdater;
import com.ibm.smarts.pipeline.internal.FlowData;
import com.ibm.smarts.pipeline.internal.Task;
import com.ibm.smarts.schema.AnalysisModeType;
import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.AnalysisTask;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.AnalysisPhaseUtil;
import com.ibm.smarts.schema.util.SmartsModuleFactory;
import com.ibm.smarts.smartsmodule.builder.SmartsModuleBuilderSettings;
import com.ibm.smarts.smartsmodule.builder.exceptions.SmartsBuilderException;
import com.ibm.smarts.smartsmodule.builder.internal.AnalysisFlowBuilder;
import com.ibm.smarts.smartsmodule.builder.internal.DeltaProcessor;
import com.ibm.smarts.smartsmodule.builder.internal.ModulePreProcessor;
import com.ibm.smarts.smartsmodule.builder.internal.ModuleStoreProgressUpdater;
import com.ibm.smarts.smartsmodule.builder.internal.SmartsModulePreProcessor;
import com.ibm.smarts.smartsmodule.builder.tasks.ClassifyColumnsTask;
import com.ibm.smarts.smartsmodule.builder.tasks.ColumnEmbeddingTask;
import com.ibm.smarts.smartsmodule.builder.tasks.InitialPublishingTask;
import com.ibm.smarts.smartsmodule.builder.tasks.PersistStatusTask;
import com.ibm.smarts.smartsmodule.builder.tasks.PredictTask;
import com.ibm.smarts.smartsmodule.builder.tasks.PublishingTask;
import com.ibm.smarts.smartsmodule.builder.tasks.SamplesTask;
import com.ibm.smarts.smartsmodule.builder.tasks.TokenizeColumnsTask;
import com.ibm.smarts.store.api.exceptions.RecordAlreadyExistsException;
import com.ibm.smarts.store.api.provider.IFlowExecutorStore;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IModuleStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModuleBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModuleBuilder.class);

    private SmartsModuleBuilder() {
    }

    public static Pair<String, SmartsModule> build(ModuleInfo moduleInfo, SmartsModuleInfo smartsModuleInfo, SmartsModuleBuilderSettings settings) throws SmartsBuilderException {
        String smartsModuleUri = SmartsModuleBuilder.resolveSmartsModuleUri(settings.getPublishingURI(), moduleInfo);
        if (!SmartsModuleBuilder.acquirePermission(smartsModuleUri, settings)) {
            LOGGER.info("Failed to get permission to build SmartsModule {} because it's being built by other process", (Object)smartsModuleUri);
            return new ImmutablePair((Object)smartsModuleUri, null);
        }
        LOGGER.info("Start building SmartsModule {}", (Object)smartsModuleUri);
        Pair<SmartsModule, List<FlowData<SmartsTaskContext>>> analysisFlows = SmartsModuleBuilder.buildAnalysisFlows(smartsModuleUri, moduleInfo, smartsModuleInfo, settings);
        if (((List)analysisFlows.getValue()).isEmpty()) {
            LOGGER.info("Running analysis tasks are not necessary for SmartsModule {}", (Object)smartsModuleUri);
            SmartsModule smartsModule = (SmartsModule)analysisFlows.getKey();
            smartsModule.setAnalysisState(AnalysisStateType.DONE);
            return new ImmutablePair((Object)smartsModuleUri, (Object)smartsModule);
        }
        LOGGER.debug("Analysis workflow for SmartsModule {} is defined as {}.", (Object)smartsModuleUri, analysisFlows.getValue());
        FlowExecutor<SmartsTaskContext> flowExecutor = SmartsModuleBuilder.setup(smartsModuleUri, (SmartsModule)analysisFlows.getKey(), settings);
        return SmartsModuleBuilder.executeAnalysisFlow(settings, smartsModuleUri, analysisFlows, flowExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acquirePermission(String smartsModuleUri, SmartsModuleBuilderSettings settings) throws SmartsBuilderException {
        boolean isPermissionGranted = false;
        if (settings.getPublishingURI() == null) {
            isPermissionGranted = true;
        } else {
            LOGGER.info("Acquire permission to build SmartsModule {}", (Object)smartsModuleUri);
            try {
                IRecord masterSmartsModuleRecord = null;
                SmartsModule masterSmartsModule = SmartsModuleFactory.createSmartsModule();
                masterSmartsModule.setAnalysisState(AnalysisStateType.IN_PROGRESS);
                IInMemoryModuleStore smartModuleStore = settings.getStoreProvider().getModuleStore(settings.getRequestContext());
                try {
                    smartModuleStore.store(IRecord.create((Object)masterSmartsModule, (String)smartsModuleUri), smartsModuleUri);
                }
                catch (RecordAlreadyExistsException e) {
                    LOGGER.info("Building SmartsModule {} is in progress", (Object)smartsModuleUri);
                    boolean bl = false;
                    if (!isPermissionGranted) {
                        IInMemoryModuleStore smartModuleStore2 = settings.getStoreProvider().getModuleStore(settings.getRequestContext());
                        smartModuleStore2.deleteById(smartsModuleUri);
                    }
                    return bl;
                }
                try {
                    masterSmartsModuleRecord = settings.getPersistenceProvider().get(settings.getRequestContext(), smartsModuleUri, Collections.singletonList("SmartsModule"), SmartsModuleOptions.DEFAULT_GET_PATTERN);
                    if (masterSmartsModuleRecord == null || masterSmartsModuleRecord.getRecord() == null) {
                        throw new JaxRs20Exceptions.NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                    }
                    if (!SmartsModuleBuilder.isInProgress((SmartsModule)masterSmartsModuleRecord.getRecord(), settings.getSystemConfig())) {
                        String masterSmartsModuleUri = (String)masterSmartsModuleRecord.getResourceURI().get("SmartsModule");
                        settings.setMasterSmartsModuleUri(masterSmartsModuleUri);
                        ((SmartsModule)masterSmartsModuleRecord.getRecord()).setAnalysisState(AnalysisStateType.IN_PROGRESS);
                        StoreStatus status = settings.getPersistenceProvider().update(settings.getRequestContext(), "SmartsModule", masterSmartsModuleRecord, Collections.singletonList("SmartsModule"), masterSmartsModuleUri);
                        if (status.isSuccess()) {
                            isPermissionGranted = true;
                        }
                    }
                }
                catch (JaxRs20Exceptions.NotFoundException e) {
                    StoreStatus status = settings.getPersistenceProvider().create(settings.getRequestContext(), "SmartsModule", IRecord.create((Object)masterSmartsModule, (String)smartsModuleUri), Collections.singletonList("SmartsModule"));
                    if (status.isSuccess()) {
                        settings.setMasterSmartsModuleUri(status.getResourceURI());
                        isPermissionGranted = true;
                    }
                }
            }
            finally {
                if (!isPermissionGranted) {
                    IInMemoryModuleStore smartModuleStore = settings.getStoreProvider().getModuleStore(settings.getRequestContext());
                    smartModuleStore.deleteById(smartsModuleUri);
                }
            }
        }
        return isPermissionGranted;
    }

    public static Pair<String, SmartsModule> executeAnalysisFlow(SmartsModuleBuilderSettings settings, String smartsModuleUri, Pair<SmartsModule, List<FlowData<SmartsTaskContext>>> analysisFlows, FlowExecutor<SmartsTaskContext> flowExecutor) {
        SmartsModuleBuilder.persistStatus(settings, smartsModuleUri);
        CompletableFuture future = flowExecutor.execute((List)analysisFlows.getValue());
        if (settings.isPublishing()) {
            ((CompletableFuture)future.handle((r, e) -> {
                SmartsModuleBuilder.persistStatus(settings, smartsModuleUri);
                return null;
            })).handle((r, e) -> {
                SmartsModuleBuilder.cleanup(smartsModuleUri, settings.getStoreProvider(), settings.getRequestContext());
                return null;
            });
            return new ImmutablePair((Object)smartsModuleUri, null);
        }
        try {
            future.get();
            IInMemoryModuleStore smartModuleStore = settings.getStoreProvider().getModuleStore(settings.getRequestContext());
            SmartsModule resultSmartsModule = smartModuleStore.getById(smartsModuleUri);
            ImmutablePair immutablePair = new ImmutablePair((Object)smartsModuleUri, (Object)resultSmartsModule);
            return immutablePair;
        }
        catch (InterruptedException | ExecutionException e2) {
            throw new InternalException("Failed to execute smarts module analysis flow." + smartsModuleUri, new Object[0]);
        }
        finally {
            SmartsModuleBuilder.cleanup(smartsModuleUri, settings.getStoreProvider(), settings.getRequestContext());
        }
    }

    private static void persistStatus(SmartsModuleBuilderSettings settings, String smartsModuleUri) {
        SmartsTaskContext smartsTaskContext = new SmartsTaskContext(smartsModuleUri, settings.getRequestContext(), settings.getStoreProvider());
        smartsTaskContext.setMasterSmartsModuleURI(settings.getMasterSmartsModuleUri());
        if (settings.isPublishing()) {
            try {
                PersistStatusTask.getInstance().execute((IContext)smartsTaskContext);
            }
            catch (Exception e) {
                throw new InternalException("Failed to publish entities in CM for: {0}, cause: {1}", new Object[]{smartsModuleUri, e.getCause()});
            }
        }
    }

    public static FlowExecutor<SmartsTaskContext> setup(String smartsModuleUri, SmartsModule smartsModule, SmartsModuleBuilderSettings settings) {
        IStoreProvider storeProvider = settings.getStoreProvider();
        ExecutorService executorService = settings.getExecutorService();
        RequestContext requestContext = settings.getRequestContext();
        boolean isEmbeddingEnabled = settings.isEmbeddingEnabled();
        IInMemoryModuleStore smartModuleStore = storeProvider.getModuleStore(requestContext);
        smartModuleStore.deleteById(smartsModuleUri);
        if (!smartModuleStore.store(IRecord.create((Object)smartsModule, (String)smartsModuleUri), smartsModuleUri).isSuccess()) {
            throw new InternalException("failed to store smarts module {0}", new Object[]{smartsModuleUri});
        }
        ArrayList<Task> tasks = new ArrayList<Task>(Arrays.asList(InitialPublishingTask.getInstance(), SamplesTask.getInstance(), TokenizeColumnsTask.getInstance(), PredictTask.getInstance(), ClassifyColumnsTask.getInstance(), PublishingTask.getInstance()));
        if (isEmbeddingEnabled) {
            tasks.add(ColumnEmbeddingTask.getInstance());
        }
        Consumer<String> statusPublisher = uri -> SmartsModuleBuilder.persistStatus(settings, uri);
        ModuleStoreProgressUpdater progressUpdater = new ModuleStoreProgressUpdater((IModuleStore)smartModuleStore, statusPublisher, settings.getStatusPublishingBatchSize());
        FlowExecutor flowExecutor = new FlowExecutor(executorService, tasks, (IProgressUpdater)progressUpdater);
        IFlowExecutorStore flowExecutorStore = storeProvider.getFlowExecutorStore();
        if (!flowExecutorStore.store(IRecord.create((Object)flowExecutor, (String)smartsModuleUri)).isSuccess()) {
            throw new InternalException("Failed to store {0} into FlowExecutor store.", new Object[]{smartsModuleUri});
        }
        return flowExecutor;
    }

    private static void cleanup(String smartsModuleUri, IStoreProvider storeProvider, RequestContext requestContext) {
        if (!storeProvider.getFlowExecutorStore().deleteById(smartsModuleUri).isSuccess()) {
            throw new InternalException("Failed to clean up {0} from FlowExecutor store.", new Object[]{smartsModuleUri});
        }
        if (!storeProvider.getModuleStore(requestContext).deleteById(smartsModuleUri).isSuccess()) {
            throw new InternalException("Failed to clean up {0} from in memory SmartsModule Store.", new Object[]{smartsModuleUri});
        }
    }

    public static Pair<SmartsModule, List<FlowData<SmartsTaskContext>>> buildAnalysisFlows(String smartsModuleUri, ModuleInfo moduleInfo, SmartsModuleInfo smartsModuleInfo, SmartsModuleBuilderSettings settings) throws SmartsBuilderException {
        if (settings == null) {
            throw new SmartsBuilderException("settings are required");
        }
        if (settings.getRequestContext() == null) {
            throw new SmartsBuilderException("requestContext is missing");
        }
        Module module = ModulePreProcessor.execute(moduleInfo, settings);
        Map<String, String> sortColumns = module.getQuerySubject().stream().filter(qs -> QuerySubjectUtil.firstColumnRowIdentifier((QuerySubject)qs) != null).collect(Collectors.toMap(ObjectType::getIdentifier, qs -> "_row_id"));
        settings.setSortColumns(sortColumns);
        if (settings.isOverwriting()) {
            IRecord smartsModuleRecord = settings.getPersistenceProvider().get(settings.getRequestContext(), smartsModuleUri, Collections.emptyList(), SmartsModuleOptions.GET_EMPTY_PATTERN);
            List uriToBeDeleted = Collections.emptyList();
            if (smartsModuleRecord.getResourceURI() != null) {
                uriToBeDeleted = smartsModuleRecord.getResourceURI().entrySet().stream().filter(e -> !((String)e.getKey()).equals("SmartsModule")).map(Map.Entry::getValue).collect(Collectors.toList());
            }
            if (!uriToBeDeleted.isEmpty()) {
                settings.getPersistenceProvider().delete(settings.getRequestContext(), smartsModuleUri, smartsModuleRecord.getRecordVersion(), uriToBeDeleted);
            }
        }
        SmartsModule sm = SmartsModulePreProcessor.process(module, smartsModuleInfo, settings);
        sm.setAnalysisState(AnalysisStateType.IN_PROGRESS);
        DeltaProcessor deltaProcessor = new DeltaProcessor(moduleInfo.hasOverwrites());
        HashMap<String, List<DeltaAnalysisScope>> deltaAnalysisMap = new HashMap<String, List<DeltaAnalysisScope>>();
        deltaProcessor.execute(sm, module, deltaAnalysisMap);
        List<FlowData<SmartsTaskContext>> analysisFlows = AnalysisFlowBuilder.buildAnalysisFlow(smartsModuleUri, sm, deltaAnalysisMap, settings);
        SmartsModuleBuilder.createAnalysisPhases(sm, analysisFlows);
        sm.setAnalysisMode(settings.isDeepAnalysis() ? AnalysisModeType.DEEP : AnalysisModeType.SHALLOW);
        return new ImmutablePair((Object)sm, analysisFlows);
    }

    public static String resolveSmartsModuleUri(String resourceUri, ModuleInfo moduleInfo) throws SmartsBuilderException {
        String smartsModuleId = null;
        if (resourceUri != null) {
            smartsModuleId = resourceUri;
        } else if (moduleInfo.getModuleUri() != null) {
            smartsModuleId = SmartsModuleBuilder.buildSmartsModuleId(moduleInfo.getModuleUri());
        } else if (moduleInfo.getModule() != null) {
            smartsModuleId = SmartsModuleBuilder.buildSmartsModuleId(moduleInfo.getModule().getIdentifier());
        }
        if (smartsModuleId != null) {
            return smartsModuleId;
        }
        throw new SmartsBuilderException("Resource URI, Module URI and Module Identifier are all NULL.");
    }

    private static String buildSmartsModuleId(String id) {
        return id + "-" + UUID.randomUUID().toString();
    }

    private static void createAnalysisPhases(SmartsModule smartsModule, List<FlowData<SmartsTaskContext>> analysisFlows) {
        analysisFlows.forEach(flowData -> {
            AnalysisTask analysisTask;
            DatasetInfo datasetInfo = SmartsModuleBuilder.mapDatasetInfo(smartsModule, ((SmartsTaskContext)flowData.getContext()).getAtomId());
            if (datasetInfo == null) {
                throw new InternalException("Dataset with Id: {0} is absent in the Smarts module, while creating analysis phases ", new Object[]{((SmartsTaskContext)flowData.getContext()).getAtomId()});
            }
            AnalysisPhase analysisPhase = AnalysisPhaseUtil.createInitialAnalysisPhase((AnalysisStateType)AnalysisStateType.IN_PROGRESS);
            if (flowData.getInitialTask() != null) {
                analysisTask = new AnalysisTask();
                SmartsModuleBuilder.setAnalysisTask(analysisTask, flowData.getInitialTask());
                analysisPhase.getCompletedTasks().add(analysisTask);
            }
            flowData.getTasks().forEach(task -> {
                AnalysisTask analysisTask = new AnalysisTask();
                SmartsModuleBuilder.setAnalysisTask(analysisTask, task);
                analysisPhase.getCompletedTasks().add(analysisTask);
            });
            if (flowData.getFinalTask() != null) {
                analysisTask = new AnalysisTask();
                SmartsModuleBuilder.setAnalysisTask(analysisTask, flowData.getFinalTask());
                analysisPhase.getCompletedTasks().add(analysisTask);
            }
            datasetInfo.getAnalysisPhases().clear();
            datasetInfo.getAnalysisPhases().add(analysisPhase);
        });
    }

    private static boolean isInProgress(SmartsModule smartsModule, Properties config) {
        if (smartsModule == null) {
            return false;
        }
        return smartsModule.getAnalysisState() == AnalysisStateType.IN_PROGRESS;
    }

    private static void setAnalysisTask(AnalysisTask analysisTask, Task task) {
        analysisTask.setId(task.getID());
        analysisTask.setDescription(task.getID());
        analysisTask.setName(task.getID());
    }

    public static DatasetInfo mapDatasetInfo(SmartsModule smartsModule, String atomId) {
        return smartsModule.getDatasets().stream().filter(ds -> ds.getId().equalsIgnoreCase(atomId)).findFirst().orElse(null);
    }
}

