/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.entity_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.uima_annotator.entity_analysis.Method;
import com.ibm.dltj.uima_annotator.entity_analysis.MethodCRFExtractor;
import com.ibm.dltj.uima_annotator.entity_analysis.Parameter;
import com.ibm.dltj.uima_annotator.util.ConfigurationParameterUtil;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.Language;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public final class EntityExtractor
extends CasAnnotator_ImplBase {
    private TypeSystem _typeSystem;
    private String[] _sofaNames;
    private final Map<String, Reference<Method>> _methods = new HashMap<String, Reference<Method>>();

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        ConfigurationParameterUtil configurationParameterUtil = new ConfigurationParameterUtil(uimaContext);
        this._sofaNames = configurationParameterUtil.getGlobalStringArray(Parameter.SofaNames, new String[]{"_InitialView"});
        this._methods.clear();
        assert (this._sofaNames != null);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this._typeSystem = typeSystem;
        try {
            for (Reference<Method> reference : this._methods.values()) {
                Method method;
                if (reference == null || (method = reference.get()) == null) continue;
                method.typeSystemInit(this._typeSystem);
            }
        }
        catch (DLTException dLTException) {
            throw new AnalysisEngineProcessException((Throwable)dLTException);
        }
    }

    public void setResultSpecification(ResultSpecification resultSpecification) {
        super.setResultSpecification(resultSpecification);
        for (Reference<Method> reference : this._methods.values()) {
            Method method;
            if (reference == null || (method = reference.get()) == null) continue;
            method.setResultSpecification(resultSpecification);
        }
    }

    public void process(CAS cAS) throws AnalysisEngineProcessException {
        try {
            for (String string : this._sofaNames) {
                Iterator iterator = cAS.getViewIterator(string);
                while (iterator.hasNext()) {
                    CAS cAS2 = (CAS)iterator.next();
                    Method method = this.getMethod(cAS2.getDocumentLanguage());
                    if (method == null) continue;
                    method.process(cAS2);
                }
            }
        }
        catch (IOException iOException) {
            throw new AnalysisEngineProcessException((Throwable)iOException);
        }
        catch (DLTException dLTException) {
            throw new AnalysisEngineProcessException((Throwable)dLTException);
        }
    }

    private Method getMethod(String string) throws IOException, DLTException {
        Reference<Method> reference;
        String string2 = Language.normalize((String)string);
        if (this._methods.containsKey(string2)) {
            reference = this._methods.get(string2);
            if (reference == null) {
                return null;
            }
            Method method = (Method)reference.get();
            if (method != null) {
                return method;
            }
        }
        if ((reference = this.createMethod(string)) == null) {
            this._methods.put(string2, null);
            return null;
        }
        ((Method)((Object)reference)).typeSystemInit(this._typeSystem);
        ((Method)((Object)reference)).setResultSpecification(this.getResultSpecification());
        this._methods.put(string2, new SoftReference<Object>(reference));
        return reference;
    }

    private Method createMethod(String string) throws IOException, DLTException {
        Logger logger = this.getContext().getLogger();
        ConfigurationParameterUtil configurationParameterUtil = new ConfigurationParameterUtil(this.getContext());
        File file = new File(configurationParameterUtil.getGlobalString(Parameter.Path));
        File file2 = null;
        if (file.isAbsolute()) {
            String string2;
            Iterator<String> iterator = this.getCandidateLanguages(string).iterator();
            while (iterator.hasNext() && !(file2 = new File(file, (string2 = iterator.next()) + File.separator + "ee.dic")).exists()) {
            }
        } else {
            ResourceManager resourceManager = ((UimaContextAdmin)this.getContext()).getResourceManager();
            for (String string3 : this.getCandidateLanguages(string)) {
                URL uRL = resourceManager.resolveRelativePath(file.getPath() + File.separator + string3 + File.separator + "ee.dic");
                if (uRL == null) continue;
                try {
                    file2 = new File(uRL.toURI());
                    if (!file2.exists()) continue;
                    break;
                }
                catch (URISyntaxException uRISyntaxException) {
                }
            }
        }
        if (file2 == null || !file2.exists()) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, Messages.getFormattedMessage("EntityExtractor.Warning_dictionary_not_found", string, file2));
            }
            return null;
        }
        return new MethodCRFExtractor(this.getContext(), string, file2);
    }

    private List<String> getCandidateLanguages(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        while (n != -1) {
            string = string.substring(0, n);
            arrayList.add(string);
            n = string.lastIndexOf(45);
        }
        arrayList.add("x-unspecified");
        return arrayList;
    }
}

