/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.entity_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.uima_annotator.entity_analysis.Method;
import com.ibm.dltj.uima_annotator.entity_analysis.MethodCRFLearner;
import com.ibm.dltj.uima_annotator.entity_analysis.Parameter;
import com.ibm.dltj.uima_annotator.util.ConfigurationParameterUtil;
import com.ibm.langware.annotator.Copyright;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.Language;
import org.apache.uima.resource.ResourceInitializationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public final class EntityLearner
extends CasAnnotator_ImplBase {
    private TypeSystem _typeSystem;
    private String[] _sofaNames;
    private final Map<String, Method> _methods = new HashMap<String, Method>();

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        ConfigurationParameterUtil configurationParameterUtil = new ConfigurationParameterUtil(uimaContext);
        this._sofaNames = configurationParameterUtil.getGlobalStringArray(Parameter.SofaNames, new String[]{"_InitialView"});
        this._methods.clear();
        assert (this._sofaNames != null);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this._typeSystem = typeSystem;
        try {
            for (Method method : this._methods.values()) {
                if (method == null) continue;
                method.typeSystemInit(typeSystem);
            }
        }
        catch (DLTException dLTException) {
            throw new AnalysisEngineProcessException((Throwable)dLTException);
        }
    }

    public void setResultSpecification(ResultSpecification resultSpecification) {
        super.setResultSpecification(resultSpecification);
        for (Method method : this._methods.values()) {
            if (method == null) continue;
            method.setResultSpecification(resultSpecification);
        }
    }

    public void process(CAS cAS) throws AnalysisEngineProcessException {
        try {
            for (String string : this._sofaNames) {
                Iterator iterator = cAS.getViewIterator(string);
                while (iterator.hasNext()) {
                    CAS cAS2 = (CAS)iterator.next();
                    Method method = this.getMethod(cAS2.getDocumentLanguage());
                    if (method == null) continue;
                    method.process(cAS2);
                }
            }
        }
        catch (IOException iOException) {
            throw new AnalysisEngineProcessException((Throwable)iOException);
        }
        catch (DLTException dLTException) {
            throw new AnalysisEngineProcessException((Throwable)dLTException);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            for (Method method : this._methods.values()) {
                if (method == null) continue;
                method.collectionProcessComplete();
            }
        }
        catch (DLTException dLTException) {
            throw new AnalysisEngineProcessException((Throwable)dLTException);
        }
        finally {
            this._methods.clear();
        }
    }

    private Method getMethod(String string) throws IOException, DLTException {
        String string2 = Language.normalize((String)string);
        if (this._methods.containsKey(string2)) {
            return this._methods.get(string2);
        }
        Method method = this.createMethod(string);
        if (method == null) {
            this._methods.put(string2, null);
            return null;
        }
        method.typeSystemInit(this._typeSystem);
        method.setResultSpecification(this.getResultSpecification());
        this._methods.put(string2, method);
        return method;
    }

    private Method createMethod(String string) throws IOException, DLTException {
        ConfigurationParameterUtil configurationParameterUtil = new ConfigurationParameterUtil(this.getContext());
        File file = new File(configurationParameterUtil.getGlobalString(Parameter.Path));
        File file2 = null;
        file2 = file.isAbsolute() ? new File(file, "ee.dic") : new File("resources" + File.separator + file.getPath() + File.separator + string + File.separator + "ee.dic");
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        return new MethodCRFLearner(this.getContext(), string, file2);
    }
}

