/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Entry;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.annotate.Annotate;
import com.ibm.dltj.annotate.AnnotateContext;
import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.annotate.Validate;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.GrammarGloss;
import com.ibm.dltj.gloss.JaMorphGloss;
import com.ibm.dltj.gloss.JkomCollectionGloss;
import com.ibm.dltj.gloss.KoMorphGloss;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MWGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.PhoneticSpellingGloss;
import com.ibm.dltj.gloss.ZhCposGloss;
import com.ibm.dltj.nondeterm.AdvancedLookupDriver;
import com.ibm.dltj.parser.PretokenizedParsingStream;
import com.ibm.dltj.uima_annotator.lex_analysis.ConfigurationMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.LanguageDictionaries;
import com.ibm.dltj.uima_annotator.lex_analysis.LexicalAnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.ResultSpecMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.uima_annotator.lex_analysis.TypeSystemMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.generic.AnnotateContextImpl;
import com.ibm.dltj.uima_annotator.lex_analysis.generic.AnnotateExContext;
import com.ibm.dltj.uima_annotator.pos_analysis.PartOfSpeechAnalyzer;
import com.ibm.dltj.uima_annotator.pos_analysis.PartOfSpeechAnnotationCreator;
import com.ibm.dltj.uima_annotator.util.Language;
import com.ibm.dltj.util.ListBase;
import com.ibm.dltj.util.PooledItemAllocator;
import com.ibm.icu.text.Normalizer;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import com.ibm.langware.annotator.TokenProperties;
import com.ibm.langware.annotator.jFrostAEProcessException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class AnnotationsCreator
implements PartOfSpeechAnnotationCreator {
    private static final String CLASS_NAME = AnnotationsCreator.class.getName();
    private final LexicalAnalyzerContext mContext;
    private final ConfigurationMgr mConfigMgr;
    private final TypeSystemMgr mTSMgr;
    private final ResultSpecMgr mRSpecMgr;
    protected AnnotateExContext mAnnotateContext;
    protected final TokenProperties mTokenProps;
    protected LowLevelCAS mLLCas;
    protected LowLevelIndexRepository mLLIndexRep;
    protected boolean mHasLemmaIndex = false;
    protected int mSofaFSAddr;
    protected char[] mDocumentTextCharArray;
    protected final StringCharacterIterator mDocumentCharIterator;
    private AdvancedLookupDriver mRuleBasedNormalizer;
    protected static final int COUNTER_START = 1;
    protected int mTokenNbr;
    protected int mSentenceNbr;
    protected int mParagraphNbr;
    protected boolean mSentenceBreakEncountered;
    protected int mBeginOfNextSentence;
    protected int mEndOfLastSentence;
    protected boolean mParagraphBreakEncountered;
    protected int mBeginOfNextParagraph;
    private int mLastGenericMWUBegin;
    private int mLastGenericMWUEnd;
    protected int mEmptyFsListAddr = 0;
    protected int mCompoundType = 0;
    private int mLastCompoundAddr;
    private int mDecompListAddr = 0;
    private int mLastDecompListItemAddr = 0;
    private int mDecompAnRouteAddr = 0;
    private int mDecompAnRouteListAppendAddr = 0;
    private Comparator mGlossComparator;
    private Comparator mActualComparator;
    private boolean enableLemmaPooling = true;
    private final HashMap<TokenInfo.LemmaEntry, TokenInfo.LemmaEntry> mLemmasMap = new HashMap();
    private final HashMap<String, Integer> mStringsMap = new HashMap();
    private PartOfSpeechAnalyzer mPartOfSpeechAnalyzer;
    PooledItemAllocator<TokenInfo> mTokenAllocator;

    public AnnotationsCreator(LexicalAnalyzerContext lexicalAnalyzerContext) {
        this.mContext = lexicalAnalyzerContext;
        this.mConfigMgr = (ConfigurationMgr)this.mContext.getConfigurationManager();
        this.mTSMgr = (TypeSystemMgr)this.mContext.getTypeSystemManager();
        this.mRSpecMgr = (ResultSpecMgr)this.mContext.getResultSpecManager();
        this.mTokenProps = new TokenProperties();
        this.mDocumentCharIterator = new StringCharacterIterator("");
    }

    public void init(CAS cAS) throws AnalysisEngineProcessException {
        Dictionary[] dictionaryArray;
        this.mLLCas = cAS.getLowLevelCAS();
        this.mLLIndexRep = this.mLLCas.ll_getIndexRepository();
        this.mHasLemmaIndex = this.mLLIndexRep.ll_getIndex("Lemma Index") != null;
        SofaFS sofaFS = cAS.getSofa();
        this.mSofaFSAddr = sofaFS != null ? this.mLLCas.ll_getFSRef((FeatureStructure)sofaFS) : 0;
        this.mDocumentTextCharArray = cAS.getDocumentText().toCharArray();
        this.mDocumentCharIterator.setText(cAS.getDocumentText());
        this.enableLemmaPooling = this.mConfigMgr.mLemmaPoolingThreshold < 0 ? false : this.mConfigMgr.mLemmaPoolingThreshold < this.mDocumentTextCharArray.length;
        this.mEmptyFsListAddr = this.mLLCas.ll_createFS(this.mTSMgr.mEFsListTypeCode);
        if (this.mConfigMgr.mCreateGenericAnnotations) {
            this.mAnnotateContext = new AnnotateContextImpl(cAS, this.mContext);
        }
        if (this.mRSpecMgr.mIsPosTagReq) {
            if (this.mPartOfSpeechAnalyzer == null) {
                this.mPartOfSpeechAnalyzer = new PartOfSpeechAnalyzer();
            }
            this.mPartOfSpeechAnalyzer.open(cAS, this.mContext.getUimaContext());
            this.mTokenAllocator = this.mPartOfSpeechAnalyzer.getTokenAllocator();
        } else {
            if (this.mPartOfSpeechAnalyzer != null) {
                this.mPartOfSpeechAnalyzer.close();
            }
            if (!(this.mTokenAllocator instanceof PooledItemAllocator.Singleton)) {
                this.mTokenAllocator = new PooledItemAllocator.Singleton((ListBase)new TokenInfo());
            }
        }
        this.mTokenAllocator.reset();
        if ((this.mConfigMgr.mDoRuleBasedNormalization4All || this.mConfigMgr.mDoRuleBasedNormalization4Katakana) && (dictionaryArray = this.mContext.mLanguageDicts.getDictsOfType(LanguageDictionaries.DICT_TYPE_LOOKUP)) != null && dictionaryArray.length > 0) {
            this.mRuleBasedNormalizer = new AdvancedLookupDriver(dictionaryArray);
            this.mRuleBasedNormalizer.whiteSpaceTokenization = false;
            this.mRuleBasedNormalizer.doKatakanaMiddleDot = false;
            this.mRuleBasedNormalizer.doWhiteSpaces = false;
            this.mRuleBasedNormalizer.extraRanking = true;
        }
        this.mActualComparator = this.mContext.mLanguageDicts.getLanguage().isLanguageOfType(Language.LanguageType.EU) ? this.mGlossComparator : null;
        this.initMemberVars();
    }

    public void reset() throws AnalysisEngineProcessException {
        this.resetMemberVars();
        this.mLLCas = null;
        this.mLLIndexRep = null;
        this.mSofaFSAddr = 0;
        this.mAnnotateContext = null;
        this.mDocumentTextCharArray = null;
        this.mDocumentCharIterator.setText("");
        this.mRuleBasedNormalizer = null;
        if (this.mPartOfSpeechAnalyzer != null) {
            this.mPartOfSpeechAnalyzer.close();
        }
        if (this.mTokenAllocator != null) {
            this.mTokenAllocator.reset();
        }
    }

    private void initMemberVars() {
        this.mTokenNbr = 1;
        this.mSentenceNbr = 1;
        this.mParagraphNbr = 1;
        this.mSentenceBreakEncountered = true;
        this.mParagraphBreakEncountered = true;
        this.mBeginOfNextSentence = 0;
        this.mEndOfLastSentence = 0;
        this.mBeginOfNextParagraph = 0;
        this.mLastGenericMWUBegin = 0;
        this.mLastGenericMWUEnd = 0;
        this.mCompoundType = 0;
        this.mLemmasMap.clear();
        this.mStringsMap.clear();
    }

    private void resetMemberVars() throws AnalysisEngineProcessException {
        this.processPartOfSpeech();
        this.initMemberVars();
    }

    public void createNewParagraphAnnotation(int n, int n2) throws AnalysisEngineProcessException {
        this.processPartOfSpeech();
        this.mParagraphBreakEncountered = true;
        if (!this.mRSpecMgr.mIsParagraphReq || n == n2) {
            return;
        }
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mParagraphTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mSofaFeatCode, this.mSofaFSAddr);
        if (this.mRSpecMgr.mIsParagraphNbrReq) {
            this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mParagraphNumFeatCode, this.mParagraphNbr);
        }
        this.mLLIndexRep.ll_addFS(n3);
        ++this.mParagraphNbr;
        if (this.mConfigMgr.mUseRelativeTokenAndSentenceNumbers) {
            this.mSentenceNbr = 1;
        }
    }

    public void createNewSentenceAnnotation(int n, int n2) throws AnalysisEngineProcessException {
        this.processPartOfSpeech();
        this.mSentenceBreakEncountered = true;
        this.mEndOfLastSentence = n2;
        if (!this.mRSpecMgr.mIsSentenceReq || n == n2) {
            return;
        }
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mSentenceTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mSofaFeatCode, this.mSofaFSAddr);
        if (this.mRSpecMgr.mIsSentenceNbrReq) {
            this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mSentenceNumFeatCode, this.mSentenceNbr);
        }
        this.mLLIndexRep.ll_addFS(n3);
        ++this.mSentenceNbr;
        if (this.mConfigMgr.mUseRelativeTokenAndSentenceNumbers) {
            this.mTokenNbr = 1;
        }
    }

    public int createNewTokenAnnotation(TokenInfo tokenInfo, boolean bl) throws AnalysisEngineProcessException {
        boolean bl2;
        int n = tokenInfo.addr;
        boolean bl3 = bl2 = bl && !this.mConfigMgr.mCreateCompoundPartsInsteadOfToken;
        if (n == 0) {
            int n2 = bl2 ? this.mTSMgr.mCompoundPartTypeCode : this.mTSMgr.getTokenSubtype(this.mDocumentTextCharArray, tokenInfo.begin, tokenInfo.end);
            tokenInfo.addr = n = this.mLLCas.ll_createFS(n2);
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mStartFeatCode, tokenInfo.begin);
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mEndFeatCode, tokenInfo.end);
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mSofaFeatCode, this.mSofaFSAddr);
            this.setTokenAnnotationFeatures(n, tokenInfo.begin, tokenInfo.end, tokenInfo.wclass, tokenInfo.type.isDictMatch, this.mTokenNbr);
            if (bl && this.mConfigMgr.mCreateDecompStructure) {
                this.linkCompoundPart(n);
            } else {
                this.mLLIndexRep.ll_addFS(n);
            }
        } else {
            this.setTokenAnnotationFeatures(n, tokenInfo.begin, tokenInfo.end, tokenInfo.wclass, tokenInfo.type.isDictMatch, this.mTokenNbr);
            if (bl && this.mConfigMgr.mCreateDecompStructure) {
                this.linkCompoundPart(n);
                this.mLLIndexRep.ll_removeFS(n);
            }
        }
        ++this.mTokenNbr;
        this.checkAndMarkNextBoundaryBegin(tokenInfo.begin);
        if (!this.mRSpecMgr.mIsPosTagReq || this.mPartOfSpeechAnalyzer == null || bl2 || !this.mPartOfSpeechAnalyzer.addToken(tokenInfo)) {
            this.annotateLemmaEntriesAndPOSTag(n, tokenInfo, null);
        }
        return n;
    }

    public int createNewMWUAnnotation(TokenInfo tokenInfo) {
        assert (tokenInfo.addr == 0);
        int n = tokenInfo.begin;
        int n2 = tokenInfo.end;
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mMWUTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mSofaFeatCode, this.mSofaFSAddr);
        if (this.mRSpecMgr.mIsTokenPropsReq) {
            this.mTokenProps.initFromCharArray(this.mDocumentTextCharArray, n, n2 - n);
            int n4 = this.mTokenProps.getInt();
            this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mTokenPropsFeatCode, n4);
            this.mTokenProps.reset();
        }
        if (this.mRSpecMgr.mIsFrostTokentypeReq) {
            this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mFrostTokenTypeFeatCode, 99);
        }
        if (this.mConfigMgr.mLemmatizationEnabled) {
            if (this.mRSpecMgr.mIsLemmaEntriesAtTokenReq) {
                this.mLLCas.ll_setRefValue(n3, this.mTSMgr.mLemmaEntriesListFeatCode, 0);
            }
            this.annotateLemmaEntriesAndPOSTag(n3, tokenInfo, null);
        }
        this.mLLIndexRep.ll_addFS(n3);
        this.checkAndMarkNextBoundaryBegin(n);
        return n3;
    }

    public int createNewCompoundAnnotation(TokenInfo tokenInfo, boolean bl) throws AnalysisEngineProcessException {
        int n;
        this.mLastCompoundAddr = n = this.createNewTokenAnnotation(tokenInfo, false);
        return n;
    }

    private void linkCompoundPart(int n) {
        int n2 = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
        this.mLLCas.ll_setRefValue(n2, this.mTSMgr.mHeadFeatCode, n);
        this.mLLCas.ll_setRefValue(n2, this.mTSMgr.mTailFeatCode, this.mEmptyFsListAddr);
        if (this.mDecompAnRouteListAppendAddr == 0) {
            this.mDecompAnRouteAddr = this.mLLCas.ll_createFS(this.mTSMgr.mDecompAnalysisTypeCode);
            this.mLLCas.ll_setRefValue(this.mDecompAnRouteAddr, this.mTSMgr.mDecompAnRouteFeatCode, n2);
        } else {
            this.mLLCas.ll_setRefValue(this.mDecompAnRouteListAppendAddr, this.mTSMgr.mTailFeatCode, n2);
        }
        this.mDecompAnRouteListAppendAddr = n2;
    }

    public void finalizeDecompositionAnalysisFS() {
        if (this.mDecompAnRouteAddr == 0) {
            return;
        }
        int n = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
        this.mLLCas.ll_setRefValue(n, this.mTSMgr.mHeadFeatCode, this.mDecompAnRouteAddr);
        this.mLLCas.ll_setRefValue(n, this.mTSMgr.mTailFeatCode, this.mEmptyFsListAddr);
        if (this.mLastDecompListItemAddr == 0) {
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mTailFeatCode, this.mDecompListAddr);
            this.mDecompListAddr = n;
        } else {
            this.mLLCas.ll_setRefValue(this.mLastDecompListItemAddr, this.mTSMgr.mTailFeatCode, n);
        }
        this.mLastDecompListItemAddr = n;
        this.mDecompAnRouteAddr = 0;
        this.mDecompAnRouteListAppendAddr = 0;
    }

    public void setTokenAnnotationFeatures(int n, int n2, int n3, int n4, boolean bl, int n5) throws AnalysisEngineProcessException {
        if (n == 0) {
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.INVALID_FS_ADRESS__SEVERE.name(), new Object[]{n});
        }
        if (this.mRSpecMgr.mIsTokenPropsReq) {
            this.mTokenProps.initFromCharArray(this.mDocumentTextCharArray, n2, n3 - n2);
            int n6 = this.mTokenProps.getInt();
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mTokenPropsFeatCode, n6);
            this.mTokenProps.reset();
        }
        if (this.mRSpecMgr.mIsFrostTokentypeReq && this.mLLCas.ll_getIntValue(n, this.mTSMgr.mFrostTokenTypeFeatCode) == 0) {
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mFrostTokenTypeFeatCode, n4);
        }
        if (this.mRSpecMgr.mIsDictionaryMatchReq) {
            this.mLLCas.ll_setBooleanValue(n, this.mTSMgr.mDictionaryMatch, bl);
        }
        if (this.mRSpecMgr.mIsTokenNbrReq) {
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mTokenNumFeatCode, n5);
        }
        if (this.mRSpecMgr.mIsSynonymsReq) {
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mSynonymEntriesListFeatCode, this.mEmptyFsListAddr);
            String string = this.getTextSpan(n2, n3);
            this.extractSynonymsForToken(n, string);
        }
    }

    public void createNewSynonymFS(int n, String string) throws AnalysisEngineProcessException {
        if (!this.mRSpecMgr.mIsSynonymsReq) {
            return;
        }
        if (n == 0) {
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.INVALID_FS_ADRESS__SEVERE.name(), new Object[]{n});
        }
        int n2 = this.mLLCas.ll_createFS(this.mTSMgr.mSynonymTypeCode);
        this.mLLCas.ll_setStringValue(n2, this.mTSMgr.mKeyFeatCode, string, false);
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
        this.mLLCas.ll_setRefValue(n3, this.mTSMgr.mHeadFeatCode, n2);
        int n4 = this.mLLCas.ll_getRefValue(n, this.mTSMgr.mSynonymEntriesListFeatCode);
        this.mLLCas.ll_setRefValue(n3, this.mTSMgr.mTailFeatCode, n4);
        this.mLLCas.ll_setRefValue(n, this.mTSMgr.mSynonymEntriesListFeatCode, n3);
    }

    private int getLemmaFS(TokenInfo.LemmaEntry lemmaEntry) {
        if (lemmaEntry.fsReference == 0) {
            if (this.enableLemmaPooling) {
                TokenInfo.LemmaEntry lemmaEntry2 = this.mLemmasMap.get((Object)lemmaEntry);
                if (lemmaEntry2 == null) {
                    int n;
                    lemmaEntry.fsReference = n = this.createNewLemmaFS(lemmaEntry);
                    lemmaEntry2 = new TokenInfo.LemmaEntry(lemmaEntry);
                    this.mLemmasMap.put(lemmaEntry2, lemmaEntry2);
                } else {
                    lemmaEntry.fsReference = lemmaEntry2.fsReference;
                }
            } else {
                lemmaEntry.fsReference = this.createNewLemmaFS(lemmaEntry);
            }
        }
        return lemmaEntry.fsReference;
    }

    public int createNewLemmaFS(TokenInfo.LemmaEntry lemmaEntry) {
        int n = this.mLLCas.ll_createFS(this.mTSMgr.mLemmaTypeCode);
        if (this.enableLemmaPooling) {
            if (this.mStringsMap.containsKey(lemmaEntry.getLemmaString())) {
                this.mLLCas.ll_setIntValue(n, this.mTSMgr.mKeyFeatCode, this.mStringsMap.get(lemmaEntry.getLemmaString()).intValue());
            } else {
                this.mLLCas.ll_setStringValue(n, this.mTSMgr.mKeyFeatCode, lemmaEntry.getLemmaString());
                this.mStringsMap.put(lemmaEntry.getLemmaString(), this.mLLCas.ll_getIntValue(n, this.mTSMgr.mKeyFeatCode));
            }
        } else {
            this.mLLCas.ll_setStringValue(n, this.mTSMgr.mKeyFeatCode, lemmaEntry.getLemmaString());
        }
        if (this.mRSpecMgr.mIsPosAtLemmaReq) {
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mPosFeatCode, lemmaEntry.pos);
        }
        if (this.mRSpecMgr.mIsLemmaStopwordReq) {
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mIsLemmaStopwordFeatCode, lemmaEntry.stop);
        }
        if (this.mRSpecMgr.mIsFrostConstraintsReq) {
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mFrostConstraintsFeatCode, lemmaEntry.constraints);
        }
        if (this.mRSpecMgr.mIsFrostMorphbitmaksReq && lemmaEntry.morphBitMaskArray.length != 0) {
            int n2 = this.mLLCas.ll_createArray(this.mTSMgr.mIntArrayTypeCode, lemmaEntry.morphBitMaskArray.length);
            for (int i = 0; i < lemmaEntry.morphBitMaskArray.length; ++i) {
                this.mLLCas.ll_setIntArrayValue(n2, i, lemmaEntry.morphBitMaskArray[i]);
            }
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mFrostMorphBitMasksFeatCode, n2);
        }
        if (this.mRSpecMgr.mIsFrostExtendedPosReq) {
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mFrostExtPosFeatCode, lemmaEntry.extPos);
        }
        if (this.mRSpecMgr.mIsFrostJPStartReq) {
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mFrostJPStartFeatCode, lemmaEntry.jpStart);
        }
        if (this.mRSpecMgr.mIsFrostJKomReq) {
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mFrostJKomFeatCode, lemmaEntry.jkom);
        }
        if (this.mHasLemmaIndex && !this.isInCompound()) {
            this.mLLIndexRep.ll_addFS(n);
        }
        return n;
    }

    @Override
    public void annotateLemmaEntriesAndPOSTag(int n, TokenInfo tokenInfo, String string) {
        if (n <= 0) {
            return;
        }
        if (!tokenInfo.isEmpty()) {
            int n2;
            if (this.mRSpecMgr.mIsLemmaAtTokenReq) {
                n2 = this.getLemmaFS((TokenInfo.LemmaEntry)tokenInfo.getFirst());
                this.mLLCas.ll_setRefValue(n, this.mTSMgr.mLemmaAtTokenFeatCode, n2);
            }
            if (this.mRSpecMgr.mIsLemmaEntriesAtTokenReq) {
                int n3;
                n2 = 0;
                if (!this.mRSpecMgr.mIsTokenReq && (n2 = this.mLLCas.ll_getRefValue(n, this.mTSMgr.mLemmaEntriesListFeatCode)) != 0 && (n3 = this.mLLCas.ll_getArraySize(n2)) != tokenInfo.size()) {
                    n2 = 0;
                }
                if (n2 == 0) {
                    n2 = this.mLLCas.ll_createArray(this.mTSMgr.mFsArrayTypeCode, tokenInfo.size());
                }
                n3 = 0;
                Iterator iterator = tokenInfo.iterator();
                while (iterator.hasNext()) {
                    TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
                    int n4 = this.getLemmaFS(lemmaEntry);
                    this.mLLCas.ll_setRefArrayValue(n2, n3++, n4);
                }
                this.mLLCas.ll_setRefValue(n, this.mTSMgr.mLemmaEntriesListFeatCode, n2);
            }
        }
        if (this.mRSpecMgr.mIsPosTagReq && string != null) {
            this.mLLCas.ll_setStringValue(n, this.mTSMgr.mPosTagFeatCode, string);
        }
    }

    public void processGloss(TokenInfo tokenInfo, Gloss gloss) {
        int n = tokenInfo.begin;
        int n2 = tokenInfo.end;
        TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)tokenInfo.getCurItem();
        try {
            lemmaEntry = this.extractLemmaForToken(lemmaEntry, n, n2, gloss);
        }
        catch (Exception exception) {
            lemmaEntry = null;
            this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.ResultHandler__Exception_Retrieving_Lemma__FINEST.name(), this.getTextSpan(n, n2)), exception);
        }
        if (!(gloss instanceof Annotate) || n2 <= this.mLastGenericMWUEnd && n >= this.mLastGenericMWUBegin && (n != this.mLastGenericMWUBegin || n2 != this.mLastGenericMWUEnd)) {
            if (lemmaEntry != null) {
                tokenInfo.commitItem();
            }
            return;
        }
        int n3 = this.runGlossAnnotate(n, n2, (Annotate)gloss, lemmaEntry);
        if (n3 != 0) {
            if (lemmaEntry != null) {
                lemmaEntry.annoReference = n3;
                tokenInfo.commitItem();
            }
            if (this.isTokenAnno(n3)) {
                tokenInfo.type = tokenInfo.type.promote(TokenInfo.BasicType.STD);
                if (tokenInfo.addr != 0) {
                    if (this.mContext.isTraceEnabled()) {
                        this.mContext.logMsg(Level.WARNING, CLASS_NAME, "runAnnotates", Messages.MessageKeys.ResultHandler__multiple_token_annos__WARNING.name(), gloss);
                    }
                } else {
                    tokenInfo.addr = n3;
                }
            } else if (tokenInfo.type == TokenInfo.BasicType.MWU) {
                tokenInfo.type = TokenInfo.BasicType.MWU_ANNOTATED;
            }
            this.mLastGenericMWUBegin = n;
            this.mLastGenericMWUEnd = n2;
        }
    }

    public void processUnknown(TokenInfo tokenInfo) {
        Object object;
        String string;
        if (!this.mConfigMgr.mLemmatizationEnabled) {
            return;
        }
        String string2 = null;
        if (this.mConfigMgr.mDoLookupVariant) {
            string2 = this.lookupVariantInVariantDict(tokenInfo.begin, tokenInfo.end);
        }
        if (string2 == null && (this.mConfigMgr.mDoRuleBasedNormalization4All || this.mConfigMgr.mDoRuleBasedNormalization4Katakana && tokenInfo.wclass == 304) && this.mContext.mLanguageDicts.getLanguage().isLanguageOfType(Language.LanguageType.JA) && (string2 = this.lookupRuleBasedVariant(string = Normalizer.normalize((String)(object = this.getTextSpan(tokenInfo.begin, tokenInfo.end)), (Normalizer.Mode)Normalizer.NFKD))) != null) {
            string2 = Normalizer.normalize((String)string2, (Normalizer.Mode)Normalizer.NFKC);
        }
        if (string2 != null) {
            object = (TokenInfo.LemmaEntry)tokenInfo.getCurItem();
            object.reset();
            object.setLemmaString(string2);
            object.pos = 0;
            tokenInfo.commitItem();
        }
    }

    public void processAnnotateOnly(int n, int n2, Gloss gloss) {
        if (!(gloss instanceof Annotate) || n2 <= this.mLastGenericMWUEnd && n >= this.mLastGenericMWUBegin && (n != this.mLastGenericMWUBegin || n2 != this.mLastGenericMWUEnd)) {
            return;
        }
        if (n2 > this.mLastGenericMWUEnd || n < this.mLastGenericMWUBegin || n == this.mLastGenericMWUBegin && n2 == this.mLastGenericMWUEnd) {
            TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)((TokenInfo)((Object)this.mTokenAllocator.getCurItem())).getCurItem();
            try {
                lemmaEntry = this.extractLemmaForToken(lemmaEntry, n, n2, gloss);
            }
            catch (Exception exception) {
                lemmaEntry = null;
                this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.ResultHandler__Exception_Retrieving_Lemma__FINEST.name(), this.getTextSpan(n, n2)), exception);
            }
            this.runGlossAnnotate(n, n2, (Annotate)gloss, lemmaEntry);
            this.mLastGenericMWUBegin = n;
            this.mLastGenericMWUEnd = n2;
        }
    }

    public TokenInfo.LemmaEntry extractLemmaForToken(TokenInfo.LemmaEntry lemmaEntry, int n, int n2, Gloss gloss) throws DLTException {
        Object object;
        lemmaEntry.reset();
        MidGloss midGloss = null;
        LemmaGenerator lemmaGenerator = null;
        if (gloss instanceof MidGloss) {
            midGloss = (MidGloss)gloss;
            lemmaGenerator = midGloss.getLemmaGloss();
        } else if (gloss instanceof MWGloss) {
            MWGloss mWGloss = (MWGloss)gloss;
            lemmaGenerator = mWGloss;
            if (mWGloss.getUserGloss() instanceof MidGloss) {
                midGloss = (MidGloss)mWGloss.getUserGloss();
            }
        }
        if (midGloss == null) {
            return null;
        }
        boolean bl = false;
        FeatureSetGloss featureSetGloss = midGloss.getFeatureGloss();
        if (featureSetGloss != null) {
            lemmaEntry.pos = featureSetGloss.getPOS();
            if (featureSetGloss.getDet() > 0 && (lemmaEntry.pos < 9 || lemmaEntry.pos > 10)) {
                lemmaEntry.pos = 10;
            }
            if (this.mRSpecMgr.mIsLemmaStopwordReq) {
                lemmaEntry.stop = featureSetGloss.getStop();
            }
            if (this.mRSpecMgr.mIsFrostConstraintsReq) {
                lemmaEntry.constraints = featureSetGloss.getBOFA();
            }
            bl |= true;
        }
        Language.LanguageType languageType = this.mContext.mLanguageDicts.getLanguage().getLanguageType();
        switch (languageType) {
            case JA: {
                object = (JaMorphGloss)midGloss.getGloss(JaMorphGloss.class);
                if (object == null) break;
                if (this.mRSpecMgr.mIsFrostExtendedPosReq || this.mRSpecMgr.mIsPosTagReq) {
                    lemmaEntry.extPos = object.getJPOS();
                }
                if (this.mRSpecMgr.mIsFrostJPStartReq) {
                    lemmaEntry.jpStart = object.getPhraseStart();
                }
                if (this.mRSpecMgr.mIsFrostJKomReq) {
                    lemmaEntry.jkom = object.getJKOM();
                }
                bl |= true;
                break;
            }
            case KO: {
                KoMorphGloss koMorphGloss = (KoMorphGloss)midGloss.getGloss(KoMorphGloss.class);
                if (koMorphGloss == null) break;
                if (this.mRSpecMgr.mIsFrostExtendedPosReq || this.mRSpecMgr.mIsPosTagReq) {
                    lemmaEntry.extPos = koMorphGloss.getPOS();
                }
                if (this.mRSpecMgr.mIsFrostJPStartReq) {
                    lemmaEntry.jpStart = koMorphGloss.getPhraseStart();
                }
                if (this.mRSpecMgr.mIsFrostJKomReq) {
                    lemmaEntry.jkom = koMorphGloss.getMorph();
                }
                bl |= true;
                break;
            }
            case ZH: {
                ZhCposGloss zhCposGloss = (ZhCposGloss)midGloss.getGloss(ZhCposGloss.class);
                if (zhCposGloss == null) break;
                lemmaEntry.pos = ZhCposGloss.getPOSbyCPOS((int)zhCposGloss.value[0]);
                if (this.mRSpecMgr.mIsFrostExtendedPosReq || this.mRSpecMgr.mIsPosTagReq) {
                    lemmaEntry.extPos = zhCposGloss.value[0];
                }
                bl |= true;
                break;
            }
            case EU: {
                GrammarGloss grammarGloss;
                if (!this.mRSpecMgr.mIsFrostMorphbitmaksReq && !this.mRSpecMgr.mIsPosTagReq || (grammarGloss = midGloss.getGrammarGloss()) == null) break;
                lemmaEntry.morphBitMaskArray = grammarGloss.mask;
                bl |= true;
                break;
            }
        }
        if (lemmaGenerator != null) {
            lemmaEntry.lemmaGloss = lemmaGenerator;
            bl |= true;
        }
        if (bl) {
            lemmaEntry.surfaceString = this.getTextSpan(n, n2);
            if (this.mConfigMgr.mDoLookupVariant && (object = this.lookupVariantInVariantDict(n, n2)) != null) {
                lemmaEntry.setLemmaString((String)object);
            }
            return lemmaEntry;
        }
        return null;
    }

    private void extractSynonymsForToken(int n, String string) {
        Dictionary[] dictionaryArray;
        for (Dictionary dictionary : dictionaryArray = this.mContext.mLanguageDicts.getDictsOfType(LanguageDictionaries.DICT_TYPE_SYNONYM)) {
            try {
                Entry entry = dictionary.lookupWord(string);
                int n2 = 0;
                if (entry != null && entry.valid()) {
                    n2 = entry.getType() == 22 || entry.getType() == 2 ? entry.getSynCount() : 1;
                }
                for (int i = 0; i < n2; ++i) {
                    try {
                        String string2 = entry.getSynonym(i);
                        if (this.mContext.isTraceEnabled()) {
                            this.mContext.logMsg(Level.FINEST, CLASS_NAME, "setTokenAnnotationFeatures", Messages.MessageKeys.AnnotationsCreator__Creating_synonym_for_token__FINEST.name(), string2, string);
                        }
                        this.createNewSynonymFS(n, string2);
                        continue;
                    }
                    catch (DLTException dLTException) {
                        this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.AnnotationsCreator__Error_retrieving_synonym_x_of_y_for_token_ignoring_error__FINEST.name(), i + 1, n2, Integer.valueOf(string)), (Exception)((Object)dLTException));
                        continue;
                    }
                    catch (AnalysisEngineProcessException analysisEngineProcessException) {
                        this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.AnnotationsCreator__Error_creating_synonym_x_of_y_for_token_ignoring_error__FINEST.name(), i + 1, n2, Integer.valueOf(string)), (Exception)((Object)analysisEngineProcessException));
                    }
                }
            }
            catch (DLTException dLTException) {
                this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.AnnotationsCreator__Error_looking_up_synonyms_for_token_ignoring_error__FINEST.name(), string, dictionary), (Exception)((Object)dLTException));
            }
        }
    }

    public String lookupVariantInVariantDict(int n, int n2) {
        Dictionary[] dictionaryArray;
        if (n == n2) {
            return null;
        }
        for (Dictionary dictionary : dictionaryArray = this.mContext.mLanguageDicts.getDictsOfType(LanguageDictionaries.DICT_TYPE_VARIANT)) {
            try {
                this.mDocumentCharIterator.setIndex(n);
                GlossCollection glossCollection = dictionary.get((CharacterIterator)this.mDocumentCharIterator, n2 - n);
                if (glossCollection == null) continue;
                for (Gloss gloss : glossCollection) {
                    if (!(gloss instanceof JkomCollectionGloss)) continue;
                    for (Gloss gloss2 : ((JkomCollectionGloss)gloss).element) {
                        if (!(gloss2 instanceof PhoneticSpellingGloss)) continue;
                        return ((PhoneticSpellingGloss)gloss2).value;
                    }
                }
            }
            catch (DLTException dLTException) {
                this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.AnnotationsCreator__Error_looking_up_variants_for_token_ignoring_error__FINEST.name(), this.getTextSpan(n, n2)), (Exception)((Object)dLTException));
            }
        }
        return null;
    }

    public String lookupRuleBasedVariant(String string) {
        Dictionary[] dictionaryArray = this.mContext.mLanguageDicts.getDictsOfType(LanguageDictionaries.DICT_TYPE_TCR);
        if (string == null || string.length() == 0 || this.mRuleBasedNormalizer == null || dictionaryArray == null || dictionaryArray.length == 0) {
            return null;
        }
        for (int i = 0; i < dictionaryArray.length; ++i) {
            try {
                this.mRuleBasedNormalizer.setRules(dictionaryArray[i]);
                String[] stringArray = this.mRuleBasedNormalizer.match(string, 4, 1);
                if (stringArray == null) continue;
                for (String string2 : stringArray) {
                    if (string2.length() == 0) continue;
                    return string2;
                }
                continue;
            }
            catch (DLTException dLTException) {
                this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.AnnotationsCreator__Error_look_up_rulebasedVariants_for_token_ignoring_error__FINEST.name(), string), (Exception)((Object)dLTException));
            }
        }
        return null;
    }

    public boolean isTokenAnno(int n) {
        return n == 0 ? false : this.mTSMgr.isSubtype(this.mTSMgr.mTokenTypeCode, this.mLLCas.ll_getFSRefType(n));
    }

    public int runGlossAnnotate(int n, int n2, Annotate annotate, TokenInfo.LemmaEntry lemmaEntry) {
        if (!this.mConfigMgr.mCreateGenericAnnotations) {
            return 0;
        }
        int n3 = 0;
        try {
            if (this.mContext.isTraceEnabled()) {
                this.mContext.logMsg(Level.FINEST, CLASS_NAME, "runGlossAnnotate", Messages.MessageKeys.AnnotationsCreator__annotate__FINEST.name(), annotate);
            }
            this.mAnnotateContext.setTokenBoundaries(n, n2, this.mSofaFSAddr, lemmaEntry != null ? lemmaEntry.getLemmaString() : null);
            if (!(annotate instanceof Validate) || ((Validate)annotate).validate((AnnotateContext)this.mAnnotateContext)) {
                annotate.annotate((AnnotateContext)this.mAnnotateContext);
                n3 = this.mAnnotateContext.getTopFSAddr();
                if (lemmaEntry != null) {
                    this.mAnnotateContext.addLemmaFS(n3, this.getLemmaFS(lemmaEntry));
                }
                this.checkAndMarkNextBoundaryBegin(n);
            }
            this.mAnnotateContext.resetTokenBoundaries();
        }
        catch (AnnotateException annotateException) {
            this.mContext.logErrorMsg(Level.FINEST, CLASS_NAME, "runGlossAnnotate", Messages.MessageKeys.AnnotationsCreator__annotateException__FINEST.name(), (Exception)((Object)annotateException));
        }
        return n3;
    }

    public void startCompoundGroup(int n) {
        this.mCompoundType = n;
        this.mDecompListAddr = this.mEmptyFsListAddr;
        this.mLastDecompListItemAddr = 0;
        this.mDecompAnRouteAddr = 0;
        this.mDecompAnRouteListAppendAddr = 0;
    }

    public void closeCompoundGroup() throws AnalysisEngineProcessException {
        this.mCompoundType = 0;
        if (this.mConfigMgr.mCreateDecompStructure && this.mLastCompoundAddr > 0) {
            this.finalizeDecompositionAnalysisFS();
            this.mLLCas.ll_setRefValue(this.mLastCompoundAddr, this.mTSMgr.mDecompFeatCode, this.mDecompListAddr);
        }
        this.mLastCompoundAddr = 0;
    }

    public boolean isInCompound(int n) {
        return n == this.mCompoundType;
    }

    public boolean isInCompound() {
        return this.mCompoundType != 0;
    }

    public boolean isToCompoundStructure() {
        return this.mConfigMgr.mCreateDecompStructure && this.isInCompound();
    }

    public boolean isParagraphBreakEncountered() {
        return this.mParagraphBreakEncountered;
    }

    public int getBeginOfNextParagraph() {
        return this.mBeginOfNextParagraph;
    }

    public boolean isSentenceBreakEncountered() {
        return this.mSentenceBreakEncountered;
    }

    public int getBeginOfNextSentence() {
        return this.mBeginOfNextSentence;
    }

    public String getTextSpan(int n, int n2) {
        return new String(this.mDocumentTextCharArray, n, n2 - n);
    }

    PretokenizedParsingStream.LUIterator<PretokenizedParsingStream.Token> getTokensIterator() {
        return new PretokenizedParsingStream.LUIterator<PretokenizedParsingStream.Token>(){
            final LowLevelIterator ll_itr;
            {
                this.ll_itr = AnnotationsCreator.this.mLLIndexRep.ll_getIndex("AnnotationIndex", ((AnnotationsCreator)AnnotationsCreator.this).mTSMgr.mTokenTypeCode).ll_iterator();
            }

            public PretokenizedParsingStream.Token get() throws NoSuchElementException {
                return new PretokenizedParsingStream.Token(){
                    final int fsRef;
                    final int begin;
                    final int end;
                    TokenInfo token;
                    boolean hasLemmaEntries;
                    {
                        this.fsRef = ll_itr.ll_get();
                        this.begin = AnnotationsCreator.this.mLLCas.ll_getIntValue(this.fsRef, ((AnnotationsCreator)AnnotationsCreator.this).mTSMgr.mStartFeatCode);
                        this.end = AnnotationsCreator.this.mLLCas.ll_getIntValue(this.fsRef, ((AnnotationsCreator)AnnotationsCreator.this).mTSMgr.mEndFeatCode);
                    }

                    public PretokenizedParsingStream.LexicalUnitType getType() {
                        return PretokenizedParsingStream.LexicalUnitType.Token;
                    }

                    public int getBegin() {
                        return this.begin;
                    }

                    public int getEnd() {
                        return this.end;
                    }

                    public void prepare() {
                        boolean bl = ((AnnotationsCreator)AnnotationsCreator.this).mTSMgr.mDictionaryMatch > 0 ? AnnotationsCreator.this.mLLCas.ll_getBooleanValue(this.fsRef, ((AnnotationsCreator)AnnotationsCreator.this).mTSMgr.mDictionaryMatch) : false;
                        this.token = AnnotationsCreator.this.getToken(this.fsRef, this.begin, this.end);
                        this.hasLemmaEntries = AnnotationsCreator.this.getLemmaEntries(this.fsRef, this.token);
                        this.token.accommodate(bl || this.hasLemmaEntries ? 0 : -1, bl ? TokenInfo.BasicType.STD : (this.hasLemmaEntries ? TokenInfo.BasicType.STD_GENERIC : TokenInfo.BasicType.UNKNOWN));
                    }

                    public boolean doOOVLookup() {
                        return !this.hasLemmaEntries;
                    }

                    public void processGlosses(GlossCollection glossCollection) {
                        TokenInfo.BasicType basicType = glossCollection.isGeneric() ? TokenInfo.BasicType.STD_GENERIC : TokenInfo.BasicType.STD;
                        this.token.accommodate(0, basicType);
                        AnnotationsCreator.this.sortGlossCollection(glossCollection);
                        for (Gloss gloss : glossCollection) {
                            AnnotationsCreator.this.processGloss(this.token, gloss);
                        }
                    }

                    public void commit(int n) {
                        this.token.accommodate(n, TokenInfo.BasicType.UNKNOWN);
                        this.commit();
                    }

                    public void commit() {
                        if (!this.hasLemmaEntries && this.token.isEmpty()) {
                            AnnotationsCreator.this.processUnknown(this.token);
                        }
                        AnnotationsCreator.this.finalizeToken();
                    }
                };
            }

            public boolean isValid() {
                return this.ll_itr.isValid();
            }

            public void moveToFirst() {
                this.ll_itr.moveToFirst();
            }

            public void moveToLast() {
                this.ll_itr.moveToLast();
            }

            public void moveToNext() {
                this.ll_itr.moveToNext();
            }

            public void moveToPrevious() {
                this.ll_itr.moveToPrevious();
            }

            public boolean hasNext() {
                return this.isValid();
            }

            public PretokenizedParsingStream.Token next() {
                PretokenizedParsingStream.Token token = this.get();
                this.moveToNext();
                return token;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private TokenInfo getToken(int n, int n2, int n3) {
        TokenInfo tokenInfo = (TokenInfo)((Object)this.mTokenAllocator.getCurItem());
        tokenInfo.reset(n2, n3, -1, TokenInfo.BasicType.UNKNOWN);
        tokenInfo.addr = this.adjustTokenType(n, n2, n3);
        return tokenInfo;
    }

    private int adjustTokenType(int n, int n2, int n3) {
        int n4;
        if (!this.mConfigMgr.mAdjustToSpecialTokenTypes) {
            return n;
        }
        int n5 = this.mLLCas.ll_getFSRefType(n);
        if (n5 != (n4 = this.mTSMgr.getTokenSubtype(this.mDocumentTextCharArray, n2, n3))) {
            this.mLLCas.ll_setIntValue(n, 0, n4);
        }
        return n;
    }

    private boolean getLemmaEntries(int n, TokenInfo tokenInfo) {
        int n2;
        int n3;
        if (n == 0) {
            return false;
        }
        if (this.mTSMgr.mLemmaEntriesListFeatCode > 0 && (n3 = this.mLLCas.ll_getRefValue(n, this.mTSMgr.mLemmaEntriesListFeatCode)) != 0 && (n2 = this.mLLCas.ll_getArraySize(n3)) > 0) {
            for (int i = 0; i < n2; ++i) {
                int n4 = this.mLLCas.ll_getRefArrayValue(n3, i);
                if (n4 == 0 || this.getLemmaEntry(n4, (TokenInfo.LemmaEntry)tokenInfo.getCurItem()) == null) continue;
                tokenInfo.commitItem();
            }
            return true;
        }
        if (this.mTSMgr.mLemmaAtTokenFeatCode > 0 && (n3 = this.mLLCas.ll_getRefValue(n, this.mTSMgr.mLemmaAtTokenFeatCode)) != 0) {
            if (this.getLemmaEntry(n3, (TokenInfo.LemmaEntry)tokenInfo.getCurItem()) != null) {
                tokenInfo.commitItem();
            }
            return true;
        }
        return false;
    }

    private TokenInfo.LemmaEntry getLemmaEntry(int n, TokenInfo.LemmaEntry lemmaEntry) {
        TokenInfo.LemmaEntry lemmaEntry2;
        int n2;
        int n3;
        if (!this.mConfigMgr.mLemmatizationEnabled && !this.mRSpecMgr.mIsPosTagReq) {
            return null;
        }
        assert (n != 0);
        assert (this.mLLCas.ll_getFSRefType(n) == this.mTSMgr.mLemmaTypeCode);
        lemmaEntry.reset();
        lemmaEntry.fsReference = n;
        String string = this.mLLCas.ll_getStringValue(n, this.mTSMgr.mKeyFeatCode);
        lemmaEntry.setLemmaString(string);
        if (this.enableLemmaPooling && !this.mStringsMap.containsKey(string)) {
            this.mStringsMap.put(string, this.mLLCas.ll_getIntValue(n, this.mTSMgr.mKeyFeatCode));
        }
        if (this.mTSMgr.mPosFeatCode > 0) {
            lemmaEntry.pos = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mPosFeatCode);
        }
        if (this.mTSMgr.mIsLemmaStopwordFeatCode > 0) {
            lemmaEntry.stop = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mIsLemmaStopwordFeatCode);
        }
        if (this.mTSMgr.mFrostConstraintsFeatCode > 0) {
            lemmaEntry.constraints = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mFrostConstraintsFeatCode);
        }
        if (this.mTSMgr.mFrostMorphBitMasksFeatCode > 0 && (n3 = this.mLLCas.ll_getRefValue(n, this.mTSMgr.mFrostMorphBitMasksFeatCode)) != 0 && (n2 = this.mLLCas.ll_getArraySize(n3)) > 0) {
            lemmaEntry.morphBitMaskArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                lemmaEntry.morphBitMaskArray[i] = this.mLLCas.ll_getIntArrayValue(n3, i);
            }
        }
        if (this.mTSMgr.mFrostExtPosFeatCode > 0) {
            lemmaEntry.extPos = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mFrostExtPosFeatCode);
        }
        if (this.mTSMgr.mFrostJPStartFeatCode > 0) {
            lemmaEntry.jpStart = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mFrostJPStartFeatCode);
        }
        if (this.mTSMgr.mFrostJKomFeatCode > 0) {
            lemmaEntry.jkom = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mFrostJKomFeatCode);
        }
        if (this.mHasLemmaIndex && !this.isInCompound()) {
            this.mLLIndexRep.ll_addFS(n);
        }
        if (this.enableLemmaPooling && (lemmaEntry2 = this.mLemmasMap.get((Object)lemmaEntry)) == null) {
            lemmaEntry2 = new TokenInfo.LemmaEntry(lemmaEntry);
            this.mLemmasMap.put(lemmaEntry2, lemmaEntry2);
        }
        return lemmaEntry;
    }

    public void initGlossComparator(String string) {
        this.mGlossComparator = null;
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(string);
            this.mGlossComparator = (Comparator)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.mContext.logMsg(Level.CONFIG, CLASS_NAME, "initGlossComparator", Messages.MessageKeys.AnnotationsCreator__Cannot_Init_GC_Comparator__CONFIG.name(), string, "Comparator Class Not Found");
        }
        catch (Exception exception) {
            this.mContext.logMsg(Level.CONFIG, CLASS_NAME, "initGlossComparator", Messages.MessageKeys.AnnotationsCreator__Cannot_Init_GC_Comparator__CONFIG.name(), string, exception.getLocalizedMessage());
        }
    }

    public void sortGlossCollection(GlossCollection glossCollection) {
        if (this.mActualComparator != null) {
            try {
                glossCollection.sort(this.mActualComparator);
            }
            catch (Exception exception) {
                this.mContext.logErrorMsg(Level.FINEST, CLASS_NAME, "sortGlossCollection", Messages.MessageKeys.AnnotationsCreator__GC_Sorting_Failed__FINEST.name(), exception);
            }
        }
    }

    public void checkAndMarkNextBoundaryBegin(int n) {
        if (this.mSentenceBreakEncountered) {
            this.mBeginOfNextSentence = n;
            this.mSentenceBreakEncountered = false;
        } else if (n < this.mBeginOfNextSentence && this.mEndOfLastSentence <= n) {
            this.mBeginOfNextSentence = n;
        }
        if (this.mParagraphBreakEncountered) {
            this.mBeginOfNextParagraph = n;
            this.mParagraphBreakEncountered = false;
        } else if (this.mBeginOfNextSentence < this.mBeginOfNextParagraph) {
            this.mBeginOfNextParagraph = this.mBeginOfNextSentence;
        }
    }

    public TokenInfo addToken(int n, int n2, int n3, TokenInfo.BasicType basicType) {
        TokenInfo tokenInfo = (TokenInfo)((Object)this.mTokenAllocator.getCurItem());
        if (tokenInfo.begin == n && tokenInfo.end == n2) {
            tokenInfo.accommodate(n3, basicType);
        } else {
            tokenInfo = this.finalizeToken();
            tokenInfo.reset(n, n2, n3, basicType);
        }
        return tokenInfo;
    }

    public TokenInfo finalizeToken() {
        TokenInfo tokenInfo = (TokenInfo)((Object)this.mTokenAllocator.getCurItem());
        if (tokenInfo.end > 0) {
            try {
                tokenInfo.type.performAnnotation(this, tokenInfo);
                tokenInfo = (TokenInfo)((Object)this.mTokenAllocator.getCurItem());
            }
            catch (AnalysisEngineProcessException analysisEngineProcessException) {
                this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.ResultHandler__Exception_In_CreateStd__FINEST.name(), this.getTextSpan(tokenInfo.begin, tokenInfo.end)), (Exception)((Object)analysisEngineProcessException));
            }
        }
        tokenInfo.reset(0, 0, 0, TokenInfo.BasicType.UNKNOWN);
        return tokenInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPartOfSpeech() throws AnalysisEngineProcessException {
        if (this.mPartOfSpeechAnalyzer == null) {
            return;
        }
        try {
            this.mPartOfSpeechAnalyzer.process(this);
        }
        finally {
            if (this.mTokenAllocator != null) {
                ((TokenInfo)((Object)this.mTokenAllocator.getCurItem())).reset(0, 0, 0, TokenInfo.BasicType.UNKNOWN);
            }
        }
    }
}

