/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis.es;

import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.uima_annotator.lex_analysis.es.AnnotationsCreatorOF;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ResultSpecMgrOF;
import com.ibm.langware.annotator.Copyright;
import java.text.CharacterIterator;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class ResultHandlerQP
implements ParsingStream {
    private final AnnotationsCreatorOF mAnnoCreator;
    QueryProcessingType type;

    public ResultHandlerQP(AnnotationsCreatorOF annotationsCreatorOF) {
        this.mAnnoCreator = annotationsCreatorOF;
        this.type = null;
    }

    public void createUnknown(int n, int n2, int n3, int n4) {
    }

    public void createBreakpoint(int n, int n2, int n3) {
    }

    public void createPunctuation(int n, int n2, int n3, int n4) {
    }

    public int startGroup(int n, int n2, int n3) {
        return 0;
    }

    public void addToFork() {
    }

    public void close() {
    }

    public void closeGroup(int n) {
    }

    public void fork() {
    }

    public void mergeRoutes(int n) {
    }

    public void reset(UniLexAnalyzer uniLexAnalyzer) {
    }

    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        this.type.createStd(this.mAnnoCreator, n2, n3, glossCollection);
    }

    static enum QueryProcessingType {
        SYN("QuerySynDicts"){

            @Override
            public void createStd(AnnotationsCreatorOF annotationsCreatorOF, int n, int n2, GlossCollection glossCollection) {
                annotationsCreatorOF.createNewSynonymAnnotation(n, n2, glossCollection);
            }

            @Override
            public boolean shouldApply(ResultSpecMgrOF resultSpecMgrOF) {
                return resultSpecMgrOF.mIsSynonymAnnoReq;
            }
        }
        ,
        STOP("StopwordDicts"){

            @Override
            public void createStd(AnnotationsCreatorOF annotationsCreatorOF, int n, int n2, GlossCollection glossCollection) {
                annotationsCreatorOF.createNewStopwordAnnotation(n, n2);
            }

            @Override
            public boolean shouldApply(ResultSpecMgrOF resultSpecMgrOF) {
                return resultSpecMgrOF.mIsStopwordAnnoReq;
            }
        }
        ,
        BOOST("BoostTermDicts"){

            @Override
            public void createStd(AnnotationsCreatorOF annotationsCreatorOF, int n, int n2, GlossCollection glossCollection) {
                for (Gloss gloss : glossCollection) {
                    IntegerGloss integerGloss = (IntegerGloss)gloss;
                    annotationsCreatorOF.createNewBoostTermAnnotation(n, n2, integerGloss.weight);
                }
            }

            @Override
            public boolean shouldApply(ResultSpecMgrOF resultSpecMgrOF) {
                return resultSpecMgrOF.mIsBoostTermAnnoReq;
            }

            @Override
            public void processTokensInCompounds(AnnotationsCreatorOF annotationsCreatorOF, Dictionary[] dictionaryArray, CharacterIterator characterIterator) {
                annotationsCreatorOF.processTokensInCompounds(dictionaryArray, characterIterator, this);
            }
        };

        final String dictionaryType;

        private QueryProcessingType(String string2) {
            this.dictionaryType = string2;
        }

        public abstract void createStd(AnnotationsCreatorOF var1, int var2, int var3, GlossCollection var4);

        abstract boolean shouldApply(ResultSpecMgrOF var1);

        public void processTokensInCompounds(AnnotationsCreatorOF annotationsCreatorOF, Dictionary[] dictionaryArray, CharacterIterator characterIterator) {
        }
    }
}

