/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis.generic;

import com.ibm.dltj.Gloss;
import com.ibm.dltj.annotate.Annotate;
import com.ibm.dltj.annotate.AnnotateContext;
import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.uima_annotator.AnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.ConfigurationMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.generic.AnnotateExContext;
import com.ibm.dltj.uima_annotator.lex_analysis.generic.FSEntry;
import com.ibm.dltj.uima_annotator.lex_analysis.generic.FSStack;
import com.ibm.dltj.uima_annotator.lex_analysis.generic.TypeManager;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.util.ArrayList;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class AnnotateContextImpl
implements AnnotateExContext {
    private static final String CLASS_NAME = AnnotateContextImpl.class.getName();
    private final AnalyzerContext _context;
    private final ConfigurationMgr _configMgr;
    private final FSStack _fsStack = new FSStack();
    private final TypeManager _typeManager;
    private final LowLevelCAS _lowCas;
    private final LowLevelIndexRepository _indexRepository;
    private final int ll_addr_StringArray_0L;
    private final String _documentText;
    private int _begin;
    private int _end;
    private int _sofa;
    public int _topFSAddr;
    private final ArrayList<Object> _objectCache = new ArrayList(4);
    private String _lemmaString;

    public AnnotateContextImpl(CAS cAS, AnalyzerContext analyzerContext) {
        this._context = analyzerContext;
        this._configMgr = (ConfigurationMgr)this._context.getConfigurationManager();
        this._documentText = cAS.getDocumentText();
        this._lowCas = cAS.getLowLevelCAS();
        this._indexRepository = this._lowCas.ll_getIndexRepository();
        this._typeManager = new TypeManager(this._lowCas.ll_getTypeSystem());
        this.ll_addr_StringArray_0L = this._lowCas.ll_createArray(this._lowCas.ll_getTypeSystem().ll_getCodeForTypeName("uima.cas.StringArray"), 0);
    }

    @Override
    public void setTokenBoundaries(int n, int n2, int n3, String string) {
        this._begin = n;
        this._end = n2;
        this._sofa = n3;
        this._lemmaString = string;
        this._topFSAddr = 0;
    }

    @Override
    public void resetTokenBoundaries() {
        this.setTokenBoundaries(Integer.MAX_VALUE, Integer.MIN_VALUE, 0, null);
        this._objectCache.clear();
    }

    public int createFS(String string) throws AnnotateException {
        int n = this._typeManager.getTypeCode(string);
        int n2 = this._lowCas.ll_createFS(n, this._configMgr.mCheckGenericTypes);
        if (this._context.isTraceEnabled()) {
            this._context.logMsg(Level.FINEST, CLASS_NAME, "createFS", Messages.MessageKeys.AnnotateContext__createfs__FINEST.name(), string, n2);
        }
        if (this._fsStack.isEmpty()) {
            this._topFSAddr = n2;
        }
        this._fsStack.push(new FSEntry(string, n2));
        return n2;
    }

    public int getCurrentFS() throws AnnotateException {
        return this._fsStack.top().getFS();
    }

    public void addFS(int n) throws AnnotateException {
        if (this._context.isTraceEnabled()) {
            this._context.logMsg(Level.FINEST, CLASS_NAME, "addFS", Messages.MessageKeys.AnnotateContext__addfs__FINEST.name(), n);
        }
        this.addFS(n, true);
    }

    private void addFS(int n, boolean bl) throws AnnotateException {
        FSEntry fSEntry = this._fsStack.top();
        if (fSEntry.getFS() != n) {
            throw new AnnotateException(Messages.getMessage(Messages.MessageKeys.AnnotateContext__nofsmatch__SEVERE.name()));
        }
        fSEntry.addArrays(this._typeManager, this._lowCas, this._configMgr.mCheckGenericTypes);
        if (bl) {
            this._lowCas.ll_setIntValue(n, this._typeManager.getBeginFeatureCode(), this._begin);
            this._lowCas.ll_setIntValue(n, this._typeManager.getEndFeatureCode(), this._end);
            this._lowCas.ll_setIntValue(n, this._typeManager.getSofaFeatureCode(), this._sofa);
        }
        this._fsStack.pop();
        this._indexRepository.ll_addFS(n, this._configMgr.mCheckGenericTypes);
    }

    public void addChildFS(int n, String string) throws AnnotateException {
        if (this._context.isTraceEnabled()) {
            this._context.logMsg(Level.FINEST, CLASS_NAME, "addChildFS", Messages.MessageKeys.AnnotateContext__addchildfs__FINEST.name(), n);
        }
        this.addFS(n, false);
        FSEntry fSEntry = this._fsStack.top();
        fSEntry.addPendingArrayValue(string, n);
    }

    @Override
    public void addLemmaFS(int n, int n2) {
        try {
            int n3 = this._lowCas.ll_getFSRefType(n);
            int n4 = this._typeManager.getFeatureCode(n3, "lemma");
            this._lowCas.ll_setRefValue(n, n4, n2, this._configMgr.mCheckGenericTypes);
        }
        catch (AnnotateException annotateException) {
            this._context.logMsg(Level.FINEST, CLASS_NAME, "addLemmaFS", Messages.MessageKeys.AnnotateContext__nolemma__SEVERE.name());
        }
    }

    public void addChildGlosses(int n, Gloss[] glossArray) throws AnnotateException {
        FSEntry fSEntry = this._fsStack.top();
        if (fSEntry.getFS() != n) {
            throw new AnnotateException(Messages.getMessage(Messages.MessageKeys.AnnotateContext__nofsmatch__SEVERE.name()));
        }
        for (Gloss gloss : glossArray) {
            if (!(gloss instanceof Annotate)) continue;
            ((Annotate)gloss).annotate((AnnotateContext)this);
        }
    }

    public void setString(int n, String string, String string2) throws AnnotateException {
        int n2 = this._typeManager.getFeatureCode(this._fsStack.top(), string);
        this._lowCas.ll_setStringValue(n, n2, string2, this._configMgr.mCheckGenericTypes);
    }

    public void setString(int n, String string, Double d) throws AnnotateException {
        int n2 = this._typeManager.getFeatureCode(this._fsStack.top(), string);
        this._lowCas.ll_setStringValue(n, n2, d.toString(), this._configMgr.mCheckGenericTypes);
    }

    public void setString(int n, String string, Float f) throws AnnotateException {
        int n2 = this._typeManager.getFeatureCode(this._fsStack.top(), string);
        this._lowCas.ll_setStringValue(n, n2, f.toString(), this._configMgr.mCheckGenericTypes);
    }

    public void setString(int n, String string, Long l) throws AnnotateException {
        int n2 = this._typeManager.getFeatureCode(this._fsStack.top(), string);
        this._lowCas.ll_setStringValue(n, n2, l.toString(), this._configMgr.mCheckGenericTypes);
    }

    public void setStringArray(int n, String string, String[] stringArray) throws AnnotateException {
        int n2 = this._typeManager.getFeatureCode(this._fsStack.top(), string);
        int n3 = stringArray.length == 0 ? this.ll_addr_StringArray_0L : this._lowCas.ll_createArray(this._typeManager.getTypeCode("uima.cas.StringArray"), stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this._lowCas.ll_setStringArrayValue(n3, i, stringArray[i], this._configMgr.mCheckGenericTypes);
        }
        this._lowCas.ll_setRefValue(n, n2, n3, this._configMgr.mCheckGenericTypes);
    }

    public void setInteger(int n, String string, Integer n2) throws AnnotateException {
        int n3 = this._typeManager.getFeatureCode(this._fsStack.top(), string);
        this._lowCas.ll_setIntValue(n, n3, n2.intValue(), this._configMgr.mCheckGenericTypes);
    }

    public void setInteger(int n, String string, Boolean bl) throws AnnotateException {
        int n2 = this._typeManager.getFeatureCode(this._fsStack.top(), string);
        this._lowCas.ll_setIntValue(n, n2, bl != false ? 1 : 0, this._configMgr.mCheckGenericTypes);
    }

    public void setInteger(int n, String string, Byte by) throws AnnotateException {
        int n2 = this._typeManager.getFeatureCode(this._fsStack.top(), string);
        this._lowCas.ll_setIntValue(n, n2, by.intValue(), this._configMgr.mCheckGenericTypes);
    }

    public void setInteger(int n, String string, Short s) throws AnnotateException {
        int n2 = this._typeManager.getFeatureCode(this._fsStack.top(), string);
        this._lowCas.ll_setIntValue(n, n2, s.intValue(), this._configMgr.mCheckGenericTypes);
    }

    public String getCurrentSurfaceForm() {
        return this._documentText.substring(this._begin, this._end);
    }

    public String getCurrentLemma() {
        return this._lemmaString;
    }

    @Override
    public int getTopFSAddr() {
        return this._topFSAddr;
    }

    public void addCachedDatum(Object object, Object object2) {
        this._objectCache.add(object);
        this._objectCache.add(object2);
    }

    public Object getCachedDatum(Object object) {
        int n = this._objectCache.size();
        for (int i = 0; i < n; i += 2) {
            if (!object.equals(this._objectCache.get(i))) continue;
            return this._objectCache.get(i + 1);
        }
        return null;
    }
}

