/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.pos_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.tagger.TagHandler;
import com.ibm.dltj.tagger.Tagger;
import com.ibm.dltj.tagger.Token;
import com.ibm.dltj.tagger.feature.CompoundTag;
import com.ibm.dltj.tagger.feature.CompoundTagFactory;
import com.ibm.dltj.tagger.feature.DefaultTagHandler;
import com.ibm.dltj.tagger.feature.POSTag;
import com.ibm.dltj.tagger.feature.Tag;
import com.ibm.dltj.tagger.impl.DLTTaggerFactory;
import com.ibm.dltj.tagger.interpreter.TokenInterpreter;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterFactory;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.uima_annotator.pos_analysis.Method;
import com.ibm.dltj.uima_annotator.pos_analysis.PartOfSpeechAnnotationCreator;
import com.ibm.dltj.util.PooledList;
import com.ibm.langware.annotator.Copyright;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceConfigurationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
final class MethodRuleBased
extends Method<Tag> {
    private final Tagger<Tag, Tag> _tagger = DLTTaggerFactory.newInstance().createTagger("UNSUPERVISED_RULE_BASED");
    private final TokenInterpreter<Tag> _interpreter;
    private final CompoundTagFactory<? extends Enum<?>> _tagFactory;

    MethodRuleBased(UimaContext uimaContext, String string, URL uRL) throws IOException, ResourceConfigurationException {
        super(uimaContext, string, uRL);
        this._tagger.open(uRL);
        this._handler = (TagHandler)this._tagger.getFeature("com.ibm.dltj.tagger.properites.unsupervised-rule-based.tag-handler");
        this._interpreter = TokenInterpreterFactory.newInstance().createInterpreter(this._language.getLanguagePart(), this._handler.getType());
        this._tagFactory = CompoundTagFactory.newInstance((Class)((DefaultTagHandler)this._handler).getType());
        assert (this._tagger != null);
        assert (this._handler != null);
        assert (this._interpreter != null);
        assert (this._tagFactory != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void invoke(CAS cAS, int n, int n2, PooledList<TokenInfo> pooledList, PartOfSpeechAnnotationCreator partOfSpeechAnnotationCreator) throws DLTException {
        try {
            String string = cAS.getDocumentText();
            this._tagger.setText(string.substring(n, n2));
            this._tagger.setAnnotation(0, 0, this._handler.getStartTag());
            int n3 = 0;
            for (Object object : pooledList) {
                if (((TokenInfo)((Object)object)).begin < n3) {
                    ((TokenInfo)((Object)object)).skipped = true;
                    continue;
                }
                Object object2 = this.toTag(string, ((TokenInfo)((Object)object)).begin, ((TokenInfo)((Object)object)).end, (TokenInfo)((Object)object), this._tagger.isEmpty());
                this._tagger.setAnnotation(((TokenInfo)((Object)object)).begin - n, ((TokenInfo)((Object)object)).end - n, object2);
                n3 = ((TokenInfo)((Object)object)).end;
            }
            this._tagger.setAnnotation(n3 - n, n3 - n, this._handler.getFinalTag());
            this._tagger.process();
            Iterator iterator = this._tagger.iterator();
            iterator.next();
            for (Object object2 : pooledList) {
                if (object2.skipped) {
                    this.annotate((TokenInfo)((Object)object2), null, partOfSpeechAnnotationCreator);
                    continue;
                }
                Token token = (Token)iterator.next();
                Tag tag = (Tag)token.getTag();
                if (tag == null) {
                    tag = (Tag)token.getGloss();
                }
                this.annotate((TokenInfo)((Object)object2), tag, partOfSpeechAnnotationCreator);
            }
            assert (iterator.hasNext());
        }
        finally {
            this._tagger.clear();
        }
    }

    @Override
    protected final int seek(TokenInfo tokenInfo, Tag tag) {
        Object object;
        Object object2;
        int n = -1;
        Iterator iterator = tokenInfo.iterator();
        while (iterator.hasNext()) {
            object2 = (TokenInfo.LemmaEntry)((Object)iterator.next());
            ++n;
            if (0 == ((TokenInfo.LemmaEntry)((Object)object2)).pos || (object = (Tag)((TokenInfo.LemmaEntry)((Object)object2)).tag) == null || !this._handler.contains(object, (Object)tag)) continue;
            return n;
        }
        iterator = (Tag)this._handler.getUnknownTag();
        if (this._handler.contains((Object)iterator, (Object)tag)) {
            n = -1;
            object2 = tokenInfo.iterator();
            while (object2.hasNext()) {
                object = (TokenInfo.LemmaEntry)((Object)object2.next());
                ++n;
                Tag tag2 = (Tag)object.tag;
                if (tag2 != null) continue;
                return n;
            }
        }
        n = -1;
        object2 = tokenInfo.iterator();
        while (object2.hasNext()) {
            object = (TokenInfo.LemmaEntry)((Object)object2.next());
            ++n;
            if (!(tag instanceof POSTag) || !((POSTag)tag).matches(object.pos, false)) continue;
            return n;
        }
        return -1;
    }

    private Tag toTag(CharSequence charSequence, int n, int n2, TokenInfo tokenInfo, boolean bl) {
        Tag tag;
        TokenInfo.LemmaEntry lemmaEntry;
        assert (charSequence != null);
        if (tokenInfo.isEmpty()) {
            return (Tag)this._interpreter.toTag(charSequence, n, n2);
        }
        if (tokenInfo.size() == 1) {
            TokenInfo.LemmaEntry lemmaEntry2 = (TokenInfo.LemmaEntry)tokenInfo.getFirst();
            return (Tag)this._interpreter.toTag(charSequence, n, n2, lemmaEntry2.pos, lemmaEntry2.extPos, lemmaEntry2.morphBitMaskArray, lemmaEntry2.morphBitMaskArray.length, bl);
        }
        CompoundTag compoundTag = this._tagFactory.create();
        Iterator iterator = tokenInfo.iterator();
        while (iterator.hasNext()) {
            lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
            if (lemmaEntry.annoReference == 0) continue;
            tag = (Tag)this._interpreter.toTag(charSequence, n, n2, lemmaEntry.pos, lemmaEntry.extPos, lemmaEntry.morphBitMaskArray, lemmaEntry.morphBitMaskArray.length, bl);
            lemmaEntry.tag = tag;
            compoundTag.add(tag);
        }
        if (!compoundTag.isEmpty()) {
            return compoundTag;
        }
        iterator = tokenInfo.iterator();
        while (iterator.hasNext()) {
            lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
            tag = (Tag)this._interpreter.toTag(charSequence, n, n2, lemmaEntry.pos, lemmaEntry.extPos, lemmaEntry.morphBitMaskArray, lemmaEntry.morphBitMaskArray.length, bl);
            lemmaEntry.tag = tag;
            compoundTag.add(tag);
        }
        if (compoundTag.isEmpty()) {
            return (Tag)this._handler.getUnknownTag();
        }
        return compoundTag;
    }
}

