/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.provider;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.store.api.exceptions.RecordAlreadyExistsException;
import com.ibm.smarts.store.api.provider.IObjectStore;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SmartsObjectStore<T>
implements IObjectStore<T> {
    private final Map<String, T> objects = new ConcurrentHashMap<String, T>();

    @Override
    public T get(String key) {
        return this.objects.get(key);
    }

    @Override
    public StoreStatus store(String key, T value) {
        if (this.objects.containsKey(key)) {
            throw new RecordAlreadyExistsException("key ='" + key + "'", new Object[0]);
        }
        this.objects.put(key, value);
        return new StoreStatus(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreStatus delete(String key) {
        if (key == null) {
            return new StoreStatus(false, Arrays.asList(new InternalException((Throwable)new IllegalArgumentException(), "Object Key is null", new Object[0])));
        }
        T object = this.objects.get(key);
        if (object != null) {
            T t = object;
            synchronized (t) {
                this.objects.remove(key);
            }
        }
        return new StoreStatus(true, null);
    }
}

