/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.useractions.consumers;

import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.StatisticsUtil;
import com.ibm.smarts.store.api.provider.IUserActionStore;
import com.ibm.smarts.useractions.actions.IGenericUserAction;
import com.ibm.smarts.useractions.actions.UserLearningDirective;
import com.ibm.smarts.useractions.actions.VisualizationAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class RelatedVisualizationConsumer {
    public static final String GLOBAL_USER = "GlobalUser";
    private static final String SEPARATOR = "-";
    private static final String APPENDER = "|";
    private static final int PLUS_ONE = 1;
    private static final int MINUS_ONE = -1;
    private static final int PLUS_FIVE = 5;
    private static final int MINUS_FIVE = -5;
    private static final float CLOSE_GENERIC_CONCEPT_TOLERANCE = 0.2f;
    private static final String DOMAIN_SIZE_ONE = "DomainMonotone";
    private static final String DOMAIN_SIZE_TWO = "DomainBivalue";
    private static final String DOMAIN_SIZE_FEW = "DomainFew";
    private static final String DOMAIN_SIZE_MODERATE = "DomainModerate";
    private static final String DOMAIN_SIZE_CONSIDERABLE = "DomainConsiderable";
    private static final String DOMAIN_SIZE_LARGE = "DomainLarge";
    private static final String DOMAIN_SIZE_IMMENSE = "DomainImmense";

    public void store(IGenericUserAction genericAction, IUserActionStore userActionStore, UserLearningDirective learningDirective, String userId) {
        VisualizationAction action = (VisualizationAction)genericAction;
        int scoreAdjustment = this.getScoreAdjustment(learningDirective);
        String key = this.getLemmaKey(action);
        userActionStore.increment(GLOBAL_USER, key, scoreAdjustment);
        userActionStore.increment(userId, key, scoreAdjustment);
        key = this.getConceptKey(action);
        userActionStore.increment(GLOBAL_USER, key, scoreAdjustment);
        userActionStore.increment(userId, key, scoreAdjustment);
    }

    private int getScoreAdjustment(UserLearningDirective learningDirective) {
        switch (learningDirective) {
            case DISLIKE: {
                return -5;
            }
            case LIKE: {
                return 5;
            }
            case USE: {
                return 1;
            }
            case UNUSE: {
                return -1;
            }
        }
        return 1;
    }

    public String getLemmaKey(VisualizationAction action) {
        List<String> lemmaList = this.getLemmaList(action);
        Collections.sort(lemmaList);
        return this.expressAsKey(lemmaList, SEPARATOR);
    }

    public String getConceptKey(VisualizationAction action) {
        List<String> conceptList = this.getConceptList(action);
        Collections.sort(conceptList);
        return this.expressAsKey(conceptList, SEPARATOR);
    }

    private String expressAsKey(List<String> strList, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String lemma : strList) {
            sb.append(lemma);
            sb.append(separator);
        }
        return sb.toString();
    }

    private List<String> getConceptList(VisualizationAction action) {
        ArrayList<String> conceptList = new ArrayList<String>();
        HashSet<String> conceptSet = new HashSet<String>();
        for (ColumnInfo relatedColumnInfo : action.getRelatedColumnInfos()) {
            String conceptId = this.getSpecficConcept(relatedColumnInfo);
            if (conceptId.isEmpty()) {
                conceptId = this.getGenericConcept(relatedColumnInfo);
            }
            if (conceptId.isEmpty() || conceptSet.contains(conceptId)) continue;
            conceptList.add(conceptId);
            conceptSet.add(conceptId);
        }
        return conceptList;
    }

    private String getSpecficConcept(ColumnInfo ci1) {
        List concepts1 = ci1.getSemanticInfo().getConcepts();
        String rep = "";
        float highConf = 0.0f;
        for (ConceptInfo ci : concepts1) {
            Concept concept = ConceptsRegistry.instance().getConcept(ci.getConceptID().trim());
            if (concept == null || concept.getParents().isEmpty() || !(ci.getConfidence() > highConf)) continue;
            highConf = ci.getConfidence();
            rep = ConceptsUtil.getConceptName((ConceptInfo)ci);
        }
        return rep;
    }

    private String getGenericConcept(ColumnInfo ci1) {
        List concepts1 = ci1.getSemanticInfo().getConcepts();
        ArrayList<String> clumpOfGenericConcepts = new ArrayList<String>();
        float highConf = 0.0f;
        for (ConceptInfo ci : concepts1) {
            Concept concept = ConceptsRegistry.instance().getConcept(ci.getConceptID().trim());
            if (concept == null || !concept.getParents().isEmpty() || !(ci.getConfidence() > highConf) && !(ci.getConfidence() - highConf < 0.2f)) continue;
            if (ci.getConfidence() > highConf + 0.2f) {
                clumpOfGenericConcepts.clear();
            }
            if (ci.getConfidence() > highConf) {
                highConf = ci.getConfidence();
            }
            clumpOfGenericConcepts.add(ConceptsUtil.getConceptName((ConceptInfo)ci));
        }
        Collections.sort(clumpOfGenericConcepts);
        Value distinctCountValue = StatisticsUtil.getStatisticValue((ColumnInfo)ci1, (StatisticType)StatisticType.DISTINCT_COUNT);
        int distinctCount = distinctCountValue == null ? 999 : distinctCountValue.intValue();
        clumpOfGenericConcepts.add(this.genericDomainSize(distinctCount));
        return this.expressAsKey(clumpOfGenericConcepts, APPENDER);
    }

    private String genericDomainSize(int distinctCount) {
        if (distinctCount == 1) {
            return DOMAIN_SIZE_ONE;
        }
        if (distinctCount == 2) {
            return DOMAIN_SIZE_TWO;
        }
        if (distinctCount <= 6) {
            return DOMAIN_SIZE_FEW;
        }
        if (distinctCount <= 12) {
            return DOMAIN_SIZE_MODERATE;
        }
        if (distinctCount <= 24) {
            return DOMAIN_SIZE_CONSIDERABLE;
        }
        if (distinctCount <= 100) {
            return DOMAIN_SIZE_LARGE;
        }
        return DOMAIN_SIZE_IMMENSE;
    }

    private List<String> getLemmaList(VisualizationAction action) {
        ArrayList<String> lemmaList = new ArrayList<String>();
        HashSet<String> lemmaSet = new HashSet<String>();
        for (ColumnInfo relatedColumnInfo : action.getRelatedColumnInfos()) {
            List phrasesInLabel = relatedColumnInfo.getLabel().getPhrases();
            String mostSigLemma = this.getMostSignificantLemma(phrasesInLabel);
            if (mostSigLemma.isEmpty() || lemmaSet.contains(mostSigLemma)) continue;
            lemmaList.add(mostSigLemma);
            lemmaSet.add(mostSigLemma);
        }
        return lemmaList;
    }

    private String getMostSignificantLemma(List<PhraseInfo> phrasesInLabel) {
        int mostSig = 0;
        String mostSigLemma = "";
        for (PhraseInfo phrase : phrasesInLabel) {
            for (TokenInfo token : phrase.getTokens()) {
                if (token.getSignificance() <= mostSig) continue;
                mostSig = token.getSignificance();
                mostSigLemma = token.getLemma();
            }
        }
        return mostSigLemma;
    }
}

