/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.validation;

import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.util.AnalysisScopes;
import com.ibm.smarts.smartsmodule.builder.validation.KDSStatus;
import com.ibm.smarts.smartsmodule.builder.validation.ValidationErrors;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class AnalysisScopeValidator {
    private static final Map<Predicate<AnalysisScope>, KDSStatus> criticalErrors = new LinkedHashMap<Predicate<AnalysisScope>, KDSStatus>();

    private AnalysisScopeValidator() {
    }

    public static Optional<ValidationErrors> validate(AnalysisScope analysisScope) {
        Optional<Map.Entry<Predicate<AnalysisScope>, KDSStatus>> stopper = AnalysisScopeValidator.validateCriticalError(analysisScope);
        return stopper.map(predicateKDSStatusEntry -> new ValidationErrors((KDSStatus)((Object)((Object)predicateKDSStatusEntry.getValue()))));
    }

    private static Optional<Map.Entry<Predicate<AnalysisScope>, KDSStatus>> validateCriticalError(AnalysisScope analysisScope) {
        return criticalErrors.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(analysisScope)).findFirst();
    }

    private static void createValidationRules() {
        criticalErrors.put(AnalysisScopeValidator.isOutScopeTablesExisting(), KDSStatus.REQ_NOT_SUPPORT_OUT_SCOPE_TABLES);
        criticalErrors.put(AnalysisScopeValidator.isBothTypeScopeTablesExisting(), KDSStatus.REQ_HAS_BOTH_TYPE_SCOPE_TABLES);
        criticalErrors.put(AnalysisScopeValidator.isScopeExceededMaxSupportTables(), KDSStatus.REQ_EXCEED_MAX_SUPPORT_TABLES);
    }

    private static Predicate<AnalysisScope> isOutScopeTablesExisting() {
        return AnalysisScopes::hasOutScopeTable;
    }

    private static Predicate<AnalysisScope> isBothTypeScopeTablesExisting() {
        return analysisScope -> AnalysisScopes.hasOutScopeTable((AnalysisScope)analysisScope) && AnalysisScopes.hasInScopeTable((AnalysisScope)analysisScope);
    }

    public static Predicate<AnalysisScope> isScopeExceededMaxSupportTables() {
        return AnalysisScopes::isScopeExceededMaxSupportTables;
    }

    static {
        AnalysisScopeValidator.createValidationRules();
    }
}

