/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.contentrecommender;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.ca.core.impl.contentrecommender.QualifierType;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplainRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplainRequest.class);
    private final String sourceModuleId;
    private final String sourceModule;
    private final String sourceModuleURI;
    private final String sourceType;
    private final String targetColumnId;
    private final QualifierType qualifier;
    private List<BaseFilter> filters = new ArrayList<BaseFilter>();
    private String tempModule;

    @JsonCreator
    public ExplainRequest(@JsonProperty(value="sourceModuleId") String sourceModuleId, @JsonProperty(value="sourceModule") String sourceModule, @JsonProperty(value="sourceModuleURI") String sourceModuleURI, @JsonProperty(value="sourceType") String sourceType, @JsonProperty(value="targetColumnId") String targetColumnId, @JsonProperty(value="qualifier") QualifierType qualifier, @JsonProperty(value="filters") List<BaseFilter> filters, @JsonProperty(value="tempModule") String tempModule) {
        this.sourceModuleId = sourceModuleId;
        this.sourceModule = sourceModule;
        this.sourceModuleURI = sourceModuleURI;
        this.sourceType = sourceType;
        this.targetColumnId = targetColumnId;
        this.qualifier = qualifier;
        this.filters = filters;
        this.setTempModule(tempModule);
    }

    public String getTargetColumnId() {
        return this.targetColumnId;
    }

    public QualifierType getQualifier() {
        return this.qualifier;
    }

    public List<BaseFilter> getFilters() {
        return this.filters;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public String getSourceModuleId() {
        return this.sourceModuleId;
    }

    public String getSourceModule() {
        return this.sourceModule;
    }

    public String getSourceModuleURI() {
        return this.sourceModuleURI;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public static ExplainRequest fromJSON(String str) {
        try {
            return (ExplainRequest)CommonJAXBHelper.unmarshalFromJSON(ExplainRequest.class, (String)str);
        }
        catch (JsonDeserializeException e) {
            LOGGER.error("Error parsing ExplainByComparison request", (Throwable)e);
            return null;
        }
    }

    public String getTempModule() {
        return this.tempModule;
    }

    public void setTempModule(String tempModule) {
        this.tempModule = tempModule;
    }
}

