/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.dashboardgenerator;

import com.ibm.smarts.ca.core.impl.dashboardgenerator.Artifact;
import com.ibm.smarts.ca.core.impl.dashboardgenerator.ContentType;
import com.ibm.smarts.ca.core.impl.dashboardgenerator.GenerateDashboardRequest;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateDashboardRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateDashboardRequestBuilder.class);
    private String sourceModuleId;
    private String sourceModule;
    private String sourceModuleURI;
    private String tempModule;
    private String sourceType;
    private boolean includePredictiveCharts;
    private List<String> includedColumns = Collections.emptyList();
    private List<String> excludedColumns = Collections.emptyList();
    private List<Artifact> includedArtifacts = Collections.emptyList();
    private List<Artifact> excludedArtifacts = Collections.emptyList();
    private int maxCharts;
    private boolean shapedModule;
    private boolean guidedDashboard;
    private String primaryTopicColumnId;
    private List<BaseFilter> primaryTopicFilter = Collections.emptyList();
    private List<VisColumn> secondaryTopicColumns = Collections.emptyList();
    private List<BaseFilter> secondaryTopicFilters = Collections.emptyList();

    public GenerateDashboardRequestBuilder(ModuleAccess access, String module) {
        switch (access) {
            case MODULE_ID: {
                this.sourceModuleId = module;
                break;
            }
            case MODULE_URI: {
                this.sourceModuleURI = module;
                break;
            }
            case MODULE_JSON: {
                this.sourceModule = module;
            }
        }
    }

    public GenerateDashboardRequest build() {
        GenerateDashboardRequest generateDashboardRequest = new GenerateDashboardRequest(this.sourceModuleId, this.sourceModule, this.sourceModuleURI, this.sourceType);
        generateDashboardRequest.setIncludePredictiveCharts(this.includePredictiveCharts);
        generateDashboardRequest.setIncludedColumns(this.includedColumns);
        generateDashboardRequest.setExcludedColumns(this.excludedColumns);
        generateDashboardRequest.setIncludedArtifacts(this.includedArtifacts);
        generateDashboardRequest.setExcludedArtifacts(this.excludedArtifacts);
        generateDashboardRequest.setMaxCharts(this.maxCharts);
        generateDashboardRequest.setPrimaryTopicColumnId(this.primaryTopicColumnId);
        generateDashboardRequest.setPrimaryTopicFilter(this.primaryTopicFilter);
        generateDashboardRequest.setSecondaryTopicColumns(this.secondaryTopicColumns);
        generateDashboardRequest.setSecondaryTopicFilters(this.secondaryTopicFilters);
        generateDashboardRequest.setShapedModule(this.shapedModule);
        generateDashboardRequest.setTempModule(this.tempModule);
        generateDashboardRequest.setGuidedDashboard(this.guidedDashboard);
        return generateDashboardRequest;
    }

    public GenerateDashboardRequestBuilder includedCharts(List<String> charts) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        artifacts.add(new Artifact(ContentType.CHART, charts));
        this.includedArtifacts = artifacts;
        return this;
    }

    public GenerateDashboardRequestBuilder excludedCharts(List<String> charts) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        artifacts.add(new Artifact(ContentType.CHART, charts));
        this.excludedArtifacts = artifacts;
        return this;
    }

    public GenerateDashboardRequestBuilder primaryTopicColumnId(String primaryTopicColumnId) {
        this.primaryTopicColumnId = primaryTopicColumnId;
        return this;
    }

    public GenerateDashboardRequestBuilder primaryTopicFilter(List<BaseFilter> primaryTopicFilter) {
        this.primaryTopicFilter = primaryTopicFilter;
        return this;
    }

    public GenerateDashboardRequestBuilder secondaryTopics(List<VisColumn> visColumns, List<BaseFilter> secondaryTopicFilters) {
        this.secondaryTopicColumns = visColumns;
        this.secondaryTopicFilters = secondaryTopicFilters;
        return this;
    }

    public GenerateDashboardRequestBuilder sourceModuleId(String sourceModuleId) {
        this.sourceModuleId = sourceModuleId;
        return this;
    }

    public GenerateDashboardRequestBuilder sourceModule(String sourceModule) {
        this.sourceModule = sourceModule;
        return this;
    }

    public GenerateDashboardRequestBuilder sourceModuleURI(String sourceModuleURI) {
        this.sourceModuleURI = sourceModuleURI;
        return this;
    }

    public GenerateDashboardRequestBuilder sourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public GenerateDashboardRequestBuilder includePredictiveCharts(Boolean includePredictiveCharts) {
        this.includePredictiveCharts = includePredictiveCharts;
        return this;
    }

    public GenerateDashboardRequestBuilder includedColumns(List<String> includedColumns) {
        this.includedColumns = includedColumns;
        return this;
    }

    public GenerateDashboardRequestBuilder excludedColumns(List<String> excludedColumns) {
        this.excludedColumns = excludedColumns;
        return this;
    }

    public GenerateDashboardRequestBuilder maxCharts(int maxCharts) {
        this.maxCharts = maxCharts;
        return this;
    }

    public GenerateDashboardRequestBuilder tempModule(String tempModule) {
        this.tempModule = tempModule;
        return this;
    }

    public GenerateDashboardRequestBuilder shapedModule(boolean shapedModule) {
        this.shapedModule = shapedModule;
        return this;
    }

    public GenerateDashboardRequestBuilder guidedDashboard(boolean guidedDashboard) {
        this.guidedDashboard = guidedDashboard;
        return this;
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public String toString() {
        return "GenerateDashboardRequest{sourceModuleId='" + this.sourceModuleId + '\'' + ", sourceModule='" + this.sourceModule + '\'' + ", sourceModuleURI='" + this.sourceModuleURI + '\'' + ", sourceType='" + this.sourceType + '\'' + ", includePredictiveCharts=" + this.includePredictiveCharts + ", includedColumns=" + this.includedColumns + ", excludedColumns=" + this.excludedColumns + ", includedArtifacts=" + this.includedArtifacts + ", excludedArtifacts=" + this.excludedArtifacts + '}';
    }

    public static enum ModuleAccess {
        MODULE_ID,
        MODULE_URI,
        MODULE_JSON;

    }
}

