/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.store;

import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.Ensure;
import com.ibm.smarts.store.api.query.BoostedFieldSearch;
import com.ibm.smarts.store.api.query.IFieldSearch;
import com.ibm.smarts.store.api.query.IStoreQuery;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CaQueryBuilder {
    private static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf(' '), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('!'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('\"'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('/'));
    private static final Set<String> SOLR_KEYWORDS = new HashSet<String>(Arrays.asList("OR", "AND", "NOT"));
    private static final char BOOST_OPERATOR = '^';
    private static final char FIELD_VAL_SEPARATOR = ':';
    private static final String QUERY_PARAM = "query";
    private static final String DEF_TYPE_PARAM = "defType";
    private static final String QUERY_FIELDS_PARAM = "qf";
    private static final String FILTER_QUERY_PARAM = "fq";
    private static final String ROWS_PARAM = "rows";
    private static final String TIE_BREAKER_PARAM = "tie";
    private static final String LOCALE_PARAM = "locale";
    private static final String ASSET_TYPES = "assetTypes";
    private static final String DEFAULT_DEF_TYPE = "edismax";
    private static final String MAX_RESULTS = "500";
    private static final String DEFAULT_QUERY_PARAM_VALUE = "*";

    public final RestClient.QueryParams from(IStoreQuery sq) {
        return this.context(sq).build();
    }

    protected QueryBuilderContext context(IStoreQuery sq) {
        return new QueryBuilderContext(sq);
    }

    protected static class QueryBuilderContext {
        private final RestClient.QueryParams qp = new RestClient.QueryParams();
        private final List<IFieldSearch> fields;
        private final String defType;

        QueryBuilderContext(IStoreQuery sq) {
            this(sq, CaQueryBuilder.DEFAULT_DEF_TYPE);
        }

        QueryBuilderContext(IStoreQuery sq, String defType) {
            this.fields = sq.getSearchFields();
            this.defType = defType;
        }

        final RestClient.QueryParams build() {
            if (this.fields == null || this.fields.isEmpty() || this.fields.stream().anyMatch(f -> Objects.isNull(f))) {
                throw new IllegalArgumentException("search fields cannot be null in store query");
            }
            if (this.fields.stream().anyMatch(f -> !f.isDisMax() && !f.isFilter())) {
                throw new IllegalArgumentException("unknown query types found in search fields " + this.fields);
            }
            this.buildInternal();
            this.addParam(CaQueryBuilder.ROWS_PARAM, CaQueryBuilder.MAX_RESULTS);
            return this.qp;
        }

        void buildInternal() {
            boolean isDisMaxQuery = this.fields.stream().allMatch(f -> f.isDisMax());
            if (isDisMaxQuery) {
                this.addDisMaxParams();
                return;
            }
            boolean isFilterQuery = this.fields.stream().allMatch(f -> f.isFilter());
            if (isFilterQuery) {
                this.addDefaultQueryParam();
                this.addFilterQueryParams();
                return;
            }
            throw new IllegalArgumentException("fields cannot be of different query types");
        }

        protected void addDefaultQueryParam() {
            this.addQueryParam(CaQueryBuilder.DEFAULT_QUERY_PARAM_VALUE);
        }

        final boolean addDisMaxParams() {
            Optional<IFieldSearch> firstDisMaxField = this.fields.stream().filter(f -> f.isDisMax()).findFirst();
            boolean hasDisMaxField = firstDisMaxField.isPresent();
            if (!hasDisMaxField) {
                return false;
            }
            List disMaxFields = this.fields.stream().filter(f -> f.isDisMax()).collect(Collectors.toList());
            if (disMaxFields.stream().anyMatch(f -> f.getQueries().length != 1)) {
                throw new IllegalArgumentException("all dis max fields must have only one query");
            }
            IFieldSearch disMaxField = firstDisMaxField.get();
            String[] queries = disMaxField.getQueries();
            String query = queries[0];
            Ensure.nonBlank((String[])new String[]{query});
            if (!disMaxFields.stream().allMatch(f -> f.getQueries()[0].equals(query))) {
                throw new IllegalArgumentException("all dis max fields must have same query " + query);
            }
            this.addParam(CaQueryBuilder.DEF_TYPE_PARAM, this.defType);
            this.addQueryFieldsParam();
            this.addQueryParam(this.escapeDisMaxQuery(query));
            return true;
        }

        private void addQueryFieldsParam() {
            StringBuilder qfBldr = new StringBuilder();
            this.fields.stream().filter(f -> f.isDisMax()).forEach(f -> {
                String fieldName = f.getField();
                Ensure.nonBlank((String)"field", (String)fieldName);
                qfBldr.append(fieldName);
                if (f instanceof BoostedFieldSearch) {
                    qfBldr.append('^');
                    qfBldr.append(((BoostedFieldSearch)f).boost);
                }
                qfBldr.append(" ");
            });
            this.addParam(CaQueryBuilder.QUERY_FIELDS_PARAM, qfBldr.toString().trim());
        }

        private void addQueryParam(String query) {
            this.addParam(CaQueryBuilder.QUERY_PARAM, query);
        }

        final void addFilterQueryParams() {
            this.fields.stream().filter(f -> f.isFilter()).forEach(f -> {
                String fieldName = f.getField();
                Ensure.nonBlank((String)"field", (String)fieldName);
                String[] queries = f.getQueries();
                Ensure.nonBlank((String[])queries);
                if (fieldName.equals(CaQueryBuilder.ASSET_TYPES)) {
                    this.addParam(CaQueryBuilder.ASSET_TYPES, f.getQueries()[0]);
                    return;
                }
                StringBuilder fqBldr = new StringBuilder();
                fqBldr.append(fieldName);
                fqBldr.append(':');
                fqBldr.append(this.escapeConcatenateTermFilter(queries));
                String fq = fqBldr.toString();
                this.addParam(CaQueryBuilder.FILTER_QUERY_PARAM, fq);
            });
        }

        private String escapeConcatenateTermFilter(String[] queries) {
            if (queries.length == 1) {
                return this.escapeTermFilter(queries[0]);
            }
            CharSequence[] queriesEscaped = (String[])Arrays.stream(queries).map(q -> this.escapeTermFilter((String)q)).toArray(String[]::new);
            String combinedQuery = String.join((CharSequence)" ", queriesEscaped);
            return '(' + combinedQuery + ')';
        }

        private String escapeTermFilter(String query) {
            String escaped = this.escapeKeywordOrSpecialCharacters(query, false);
            return StringUtils.containsWhitespace((CharSequence)query) ? '(' + escaped + ')' : escaped;
        }

        protected void addTieBreaker(float tieBreaker) {
            this.addParam(CaQueryBuilder.TIE_BREAKER_PARAM, tieBreaker + "");
        }

        protected void addLocale(String locale) {
            this.addParam(CaQueryBuilder.LOCALE_PARAM, locale);
        }

        private void addParam(String param, String value) {
            this.qp.add(param, new String[]{value});
        }

        private String escapeDisMaxQuery(String query) {
            StringBuilder qBuilder = new StringBuilder();
            String[] queries = query.split("\\s+");
            Arrays.stream(queries).forEach(q -> {
                qBuilder.append(this.escapeKeywordOrSpecialCharacters((String)q, true));
                qBuilder.append(" ");
            });
            return qBuilder.toString().trim();
        }

        private String escapeKeywordOrSpecialCharacters(String query, boolean disMax) {
            if (SOLR_KEYWORDS.contains(query.toUpperCase())) {
                return "\\" + query;
            }
            return this.escapeSpecialCharacters(query, disMax);
        }

        protected String escapeSpecialCharacters(String query, boolean disMax) {
            StringBuilder qBuilder = new StringBuilder();
            for (int i = 0; i < query.length(); ++i) {
                char c = query.charAt(i);
                if (SPECIAL_CHARS.contains(Character.valueOf(c)) && (!disMax || c != ' ')) {
                    qBuilder.append("\\");
                }
                qBuilder.append(c);
            }
            return qBuilder.toString();
        }
    }
}

