/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.store.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.util.Ensure;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.core.query.RecordResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SmartsCaParserHelper<T> {
    public static final String ID_FIELD_IN_INDEX = "id";
    private static final String RESULTS_FIELD = "results";
    private static final String SCORE_FIELD = "score";

    private SmartsCaParserHelper() {
    }

    public static <T> String[] serialize(List<IRecord<T>> clueRecords) {
        return (String[])clueRecords.stream().map(c -> SmartsCaParserHelper.serialize(c)).toArray(String[]::new);
    }

    public static <T> String serialize(IRecord<T> record) {
        String recordId = record.getId();
        Ensure.nonBlank((String[])new String[]{recordId});
        Object typedRecord = record.getRecord();
        JsonNode recordJson = CommonJAXBHelper.toJsonNode((Object)typedRecord);
        ((ObjectNode)recordJson).put(ID_FIELD_IN_INDEX, recordId);
        return recordJson.toString();
    }

    public static String serializeToJsonBody(List<String> documents) {
        ArrayNode documentsNode = JsonNodeFactory.instance.arrayNode();
        documents.stream().forEach(d -> {
            Ensure.nonBlank((String[])new String[]{d});
            JsonNode documentNode = JsonParserHelper.parseJson((String)d);
            documentsNode.add(documentNode);
        });
        ObjectNode bodyNode = JsonNodeFactory.instance.objectNode();
        bodyNode.set("documents", (JsonNode)documentsNode);
        return bodyNode.toString();
    }

    public static <T> List<IRecordResult<T>> deserialize(String recordJsonStr, Class<T> klass) {
        if (recordJsonStr == null || recordJsonStr.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IRecordResult<T>> records = new ArrayList<IRecordResult<T>>();
        for (JsonNode recordJson : CommonJAXBHelper.toJsonNode((String)recordJsonStr).findValue(RESULTS_FIELD)) {
            T recordTyped = SmartsCaParserHelper.deserialize(recordJson, klass);
            String recordId = recordJson.get(ID_FIELD_IN_INDEX).asText();
            IRecord record = IRecord.create(recordTyped, (String)recordId);
            float score = recordJson.get(SCORE_FIELD).floatValue();
            records.add((IRecordResult<T>)new RecordResult(record, score));
        }
        return records;
    }

    public static <T> T deserialize(JsonNode record, Class<T> klass) {
        return (T)CommonJAXBHelper.parseJson(klass, (JsonNode)record);
    }
}

