/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.api;

import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IBaseChartDescriptor {
    default public String getStringFromBundle(ResourceBundle bundle, String id) {
        String stringFromBundle = "";
        try {
            stringFromBundle = bundle.getString(id);
            return new String(stringFromBundle.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (MissingResourceException e) {
            LogHolder.ILOGGER.warn("Missing Resource {} ", (Object)id);
        }
        catch (UnsupportedEncodingException e) {
            LogHolder.ILOGGER.error("The string contains unsupported characters {}", (Object)bundle.getString(id));
        }
        return stringFromBundle;
    }

    public List<ChartElement> getElements();

    public String getName();

    public PreferenceLevel getPreference();

    default public double getMinChartScore() {
        return 0.63;
    }

    default public boolean acceptsNoneAggregation() {
        return false;
    }

    public static final class LogHolder {
        static final Logger ILOGGER = LoggerFactory.getLogger(IBaseChartDescriptor.class);
    }
}

