/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.api;

import com.ibm.bi.learningaggregator.application.LearningAggregator;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.recommendationmodel.RecommendationModel;
import com.ibm.bi.recommendationmodel.RecommendationModelBuilder;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.bi.storageservice.application.UserProfileStorageService;
import com.ibm.bi.storageservice.utils.LearningType;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.impl.useractions.CaUserActionRestClient;
import com.ibm.smarts.ca.core.rest.client.BIRestClientConfigInfo;
import com.ibm.smarts.ca.core.rest.client.SmartsCaRestClientHelper;
import com.ibm.smarts.combinations.generator.api.IFilter;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.recommenders.core.utils.Pair;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import com.ibm.smarts.visualization.recommender.api.IVisualizationRecommender;
import com.ibm.smarts.visualization.recommender.api.UserProfile;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.LearningException;
import com.ibm.smarts.visualization.recommender.exceptions.RecommendationException;
import com.ibm.smarts.visualization.recommender.schema.EXTRA_BEHAVIOR;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.schema.SmartsResult;
import com.ibm.smarts.visualization.recommender.schema.SmartsStatus;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import com.ibm.smarts.visualization.recommender.schema.VisualizationUserActionData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisRecommenderSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisRecommenderSupport.class);
    private static final int maxChartsPerColumn = 11;
    private static final String VISRECOMMENDERLEARNINGCONTEXT = "VisRecommenderLearningContext";
    private IVisualizationRecommender recommender;

    public VisRecommenderSupport(IVisualizationRecommender recommender) {
        this.recommender = recommender;
    }

    public SmartsResult generateRecommendations(RequestContext context, SmartsModule smartsModule, List<VisColumn> columns, long timeout, int maxNumOfCharts, List<String> includedCharts, List<String> excludedCharts, Map<String, IFilter> columnFilterMap, List<BaseFilter> filters, List<EXTRA_BEHAVIOR> extraBehaviors) {
        SmartsResult smartsResult;
        try {
            if (timeout > 0L) {
                CompletableFuture<SmartsResult> future = CompletableFuture.supplyAsync(() -> this.generateRecommendations(context, smartsModule, columns, maxNumOfCharts, includedCharts, excludedCharts, columnFilterMap, filters, extraBehaviors, Collections.emptyList()));
                smartsResult = (SmartsResult)future.get(timeout, TimeUnit.MILLISECONDS);
            } else {
                smartsResult = this.generateRecommendations(context, smartsModule, columns, maxNumOfCharts, includedCharts, excludedCharts, columnFilterMap, filters, extraBehaviors, Collections.emptyList());
            }
        }
        catch (TimeoutException e) {
            LOGGER.error("Timed out recommending visualizations", (Throwable)e);
            smartsResult = new SmartsResult(SmartsStatus.RECOMMENDER_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error recommending visualizations", (Throwable)e);
            smartsResult = new SmartsResult(e);
            Thread.currentThread().interrupt();
        }
        return smartsResult;
    }

    public SmartsResult generateRecommendations(RequestContext context, SmartsModule smartsModule, List<VisColumn> columns, long timeout, int maxNumOfCharts, List<String> includedCharts, List<String> excludedCharts, Map<String, IFilter> columnFilterMap, List<BaseFilter> filters, List<EXTRA_BEHAVIOR> extraBehaviors, List<ItemType> hiddenItems) {
        SmartsResult smartsResult;
        try {
            if (timeout > 0L) {
                CompletableFuture<SmartsResult> future = CompletableFuture.supplyAsync(() -> this.generateRecommendations(context, smartsModule, columns, maxNumOfCharts, includedCharts, excludedCharts, columnFilterMap, filters, extraBehaviors, hiddenItems));
                smartsResult = (SmartsResult)future.get(timeout, TimeUnit.MILLISECONDS);
            } else {
                smartsResult = this.generateRecommendations(context, smartsModule, columns, maxNumOfCharts, includedCharts, excludedCharts, columnFilterMap, filters, extraBehaviors, hiddenItems);
            }
        }
        catch (TimeoutException e) {
            LOGGER.error("Timed out recommending visualizations", (Throwable)e);
            smartsResult = new SmartsResult(SmartsStatus.RECOMMENDER_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error recommending visualizations", (Throwable)e);
            smartsResult = new SmartsResult(e);
            Thread.currentThread().interrupt();
        }
        return smartsResult;
    }

    private SmartsResult generateRecommendations(RequestContext context, SmartsModule smartsModule, List<VisColumn> columns, int maxNumOfCharts, List<String> includedCharts, List<String> excludedCharts, Map<String, IFilter> columnFilterMap, List<BaseFilter> filters, List<EXTRA_BEHAVIOR> extraBehaviors, List<ItemType> hiddenItems) {
        SmartsResult smartsResult;
        try {
            int numOfResuts = maxNumOfCharts > 0 ? maxNumOfCharts : 11;
            List<String> columnsIds = columns.stream().map(VisColumn::getFirst).collect(Collectors.toList());
            VisualizationParameters parameters = new VisualizationParameters();
            parameters.setColumnFilterMap(columnFilterMap);
            parameters.setExcludedCharts(excludedCharts);
            parameters.setIncludedCharts(includedCharts);
            parameters.setMaxChartsPerColumnCombination(numOfResuts);
            parameters.setBaseFilterList(filters);
            parameters.addBehaviours(extraBehaviors);
            parameters.getHiddenItems().addAll(hiddenItems);
            for (VisColumn visColumn : columns) {
                for (String id : visColumn.getId()) {
                    parameters.getAggregationMap().put(id, visColumn.getAggregation());
                }
            }
            List<IRecommendedVisualization> recommendations = this.recommender.recommend(this.getAggregatedRecommendationModel(context), smartsModule, context.productLocale, columnsIds, parameters);
            smartsResult = new SmartsResult(SmartsStatus.OK, recommendations);
        }
        catch (RecommendationException e) {
            LOGGER.error("Error generating visualization recommendations", (Throwable)e);
            smartsResult = new SmartsResult((Exception)e);
        }
        return smartsResult;
    }

    private void storeRecModelInProfileStorageService(RecommendationModel recommendationModel, RequestContext context) throws LearningException {
        BIRestClientConfigInfo clientConfigInfo = SmartsCaRestClientHelper.getConfigFromRequestContext((RequestContext)context);
        RESTClient restClient = RESTClientFactory.getInstance().getClient(SmartsCaRestClientHelper.buildRESTClientConfig((RequestContext)context, (Map)clientConfigInfo.headers));
        UserProfileStorageService ups = new UserProfileStorageService();
        String recModelString = CommonJAXBHelper.marshalToJSON((Object)recommendationModel);
        LOGGER.debug(recModelString);
        boolean storeSuccess = ups.storeRecModel(recModelString, LearningType.ONLINE_LEARNING, restClient);
        if (!storeSuccess) {
            throw new LearningException("Failed to store rec model");
        }
    }

    public void like(RequestContext context, SmartsModule smartsModule, VisualizationUserActionData data) {
        try {
            RecommendationModel onlineRecModel = this.getOnlineRecommendationModel(context);
            this.recommender.like(onlineRecModel, smartsModule, data.getColumnList(), data.getChart(), data.getBindingList());
            this.storeRecModelInProfileStorageService(onlineRecModel, context);
        }
        catch (LearningException e) {
            LOGGER.error(e.toString());
        }
    }

    public void dislike(RequestContext context, SmartsModule smartsModule, VisualizationUserActionData data) {
        try {
            RecommendationModel onlineRecModel = this.getOnlineRecommendationModel(context);
            this.recommender.dislike(onlineRecModel, smartsModule, data.getColumnList(), data.getChart(), data.getBindingList());
            this.storeRecModelInProfileStorageService(onlineRecModel, context);
        }
        catch (LearningException e) {
            LOGGER.error(e.toString());
        }
    }

    public void use(RequestContext context, SmartsModule smartsModule, VisualizationUserActionData data) {
        try {
            RecommendationModel onlineRecModel = this.getOnlineRecommendationModel(context);
            this.recommender.use(onlineRecModel, smartsModule, data.getColumnList(), data.getChart(), data.getBindingList());
            this.storeRecModelInProfileStorageService(onlineRecModel, context);
        }
        catch (LearningException e) {
            LOGGER.error(e.toString());
        }
    }

    public void useAll(RequestContext context, SmartsModule smartsModule, List<VisualizationUserActionData> visualizationUserActionData) {
        try {
            RecommendationModel onlineRecModel = this.getOnlineRecommendationModel(context);
            for (VisualizationUserActionData data : visualizationUserActionData) {
                this.recommender.use(onlineRecModel, smartsModule, data.getColumnList(), data.getChart(), data.getBindingList());
            }
            this.storeRecModelInProfileStorageService(onlineRecModel, context);
        }
        catch (LearningException e) {
            LOGGER.error(e.toString());
        }
    }

    public void purge(RequestContext context, String learningType) {
        BIRestClientConfigInfo clientConfigInfo = SmartsCaRestClientHelper.getConfigFromRequestContext((RequestContext)context);
        RESTClient restClient = RESTClientFactory.getInstance().getClient(SmartsCaRestClientHelper.buildRESTClientConfig((RequestContext)context, (Map)clientConfigInfo.headers));
        UserProfileStorageService ups = new UserProfileStorageService();
        if (learningType.equals("online")) {
            ups.deleteRecModel(restClient, LearningType.ONLINE_LEARNING);
        } else if (learningType.equals("offline")) {
            ups.deleteRecModel(restClient, LearningType.OFFLINE_LEARNING);
        }
    }

    public SmartsResult generateRecommendationsFromPair(RequestContext context, SmartsModule smartsModule, List<ColumnIdentifier> columnIdentifierList, long timeout, List<String> includedCharts, List<String> excludedCharts, Map<String, IFilter> columnFilterMap) {
        SmartsResult smartsResult;
        List<Pair<String, String>> datasetAndColumnIDPair = this.makeDataPairList(columnIdentifierList);
        try {
            if (timeout > 0L) {
                CompletableFuture<SmartsResult> future = CompletableFuture.supplyAsync(() -> this.generateRecommendationsFromPair(context, smartsModule, datasetAndColumnIDPair, includedCharts, excludedCharts, columnFilterMap));
                smartsResult = (SmartsResult)future.get(timeout, TimeUnit.MILLISECONDS);
            } else {
                smartsResult = this.generateRecommendationsFromPair(context, smartsModule, datasetAndColumnIDPair, includedCharts, excludedCharts, columnFilterMap);
            }
        }
        catch (TimeoutException e) {
            LOGGER.error("Timed out recommending visualizations", (Throwable)e);
            smartsResult = new SmartsResult(SmartsStatus.RECOMMENDER_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error recommending visualizations", (Throwable)e);
            smartsResult = new SmartsResult(e);
            Thread.currentThread().interrupt();
        }
        return smartsResult;
    }

    private List<Pair<String, String>> makeDataPairList(List<ColumnIdentifier> columnIdentifierList) {
        ArrayList<Pair<String, String>> pairList = new ArrayList<Pair<String, String>>();
        for (ColumnIdentifier id : columnIdentifierList) {
            pairList.add(new Pair<String, String>(id.datasetId, id.columnId));
        }
        return pairList;
    }

    private SmartsCaClientManager getSmartsCaClientManager(RequestContext requestContext) {
        ObjectCreator clientManagerCreator = (ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        if (clientManagerCreator == null) {
            return null;
        }
        return (SmartsCaClientManager)clientManagerCreator.create(requestContext);
    }

    public CaUserActionRestClient getUserActionClient(RequestContext context) {
        SmartsCaClientManager clinetManager = this.getSmartsCaClientManager(context);
        if (clinetManager == null) {
            return null;
        }
        return this.getSmartsCaClientManager(context).getUsersClient();
    }

    private boolean canLearnCapabilityPresent(RequestContext requestContext) {
        return this.getSmartsCaClientManager(requestContext).getUserProfileServiceClient().canLearnFromUsage();
    }

    public UserProfile getUserProfile(RequestContext context, CaUserActionRestClient userActionClient) {
        if (userActionClient == null) {
            return null;
        }
        UserProfile profile = null;
        if (userActionClient != null) {
            CompletableFuture jsonStrFuture = userActionClient.getUserActionStoredAsyncAsJsonString(VISRECOMMENDERLEARNINGCONTEXT);
            try {
                List profiles;
                String json = (String)jsonStrFuture.get();
                if ((json != null || json.isEmpty()) && !(profiles = CommonJAXBHelper.unmarshalListFromJSON(UserProfile.class, (String)json)).isEmpty()) {
                    profile = (UserProfile)profiles.get(0);
                }
            }
            catch (JsonDeserializeException | InterruptedException | ExecutionException e) {
                LOGGER.error("Failed to retrieve user profile", e);
            }
        }
        return profile;
    }

    public RecommendationModel getAggregatedRecommendationModel(RequestContext context) {
        LearningAggregator learningAggregator = new LearningAggregator();
        BIRestClientConfigInfo clientConfigInfo = SmartsCaRestClientHelper.getConfigFromRequestContext((RequestContext)context);
        if (clientConfigInfo != null && this.canLearnCapabilityPresent(context)) {
            RESTClient restClient = RESTClientFactory.getInstance().getClient(SmartsCaRestClientHelper.buildRESTClientConfig((RequestContext)context, (Map)clientConfigInfo.headers));
            return learningAggregator.getLearningAggregation(restClient);
        }
        return new RecommendationModel();
    }

    public RecommendationModel getOnlineRecommendationModel(RequestContext context) throws LearningException {
        BIRestClientConfigInfo clientConfigInfo = SmartsCaRestClientHelper.getConfigFromRequestContext((RequestContext)context);
        if (clientConfigInfo != null && this.canLearnCapabilityPresent(context)) {
            RESTClient restClient = RESTClientFactory.getInstance().getClient(SmartsCaRestClientHelper.buildRESTClientConfig((RequestContext)context, (Map)clientConfigInfo.headers));
            UserProfileStorageService ups = new UserProfileStorageService();
            String recModel = ups.getUncompressedRecModel(restClient, LearningType.ONLINE_LEARNING);
            try {
                return RecommendationModelBuilder.fromJsonString((String)recModel);
            }
            catch (IOException e) {
                throw new LearningException("Failed to unmarshal rec model");
            }
        }
        return new RecommendationModel();
    }

    private SmartsResult generateRecommendationsFromPair(RequestContext context, SmartsModule smartsModule, List<Pair<String, String>> datasetAndColumnIDPair, List<String> includedCharts, List<String> excludedCharts, Map<String, IFilter> columnFilterMap) {
        SmartsResult smartsResult;
        try {
            ArrayList<EXTRA_BEHAVIOR> behaviors = new ArrayList<EXTRA_BEHAVIOR>();
            behaviors.add(EXTRA_BEHAVIOR.ALLOW_EXTRA_CATEGORY);
            VisualizationParameters parameters = new VisualizationParameters();
            parameters.setColumnFilterMap(columnFilterMap);
            parameters.setExcludedCharts(excludedCharts);
            parameters.setIncludedCharts(includedCharts);
            parameters.setMaxChartsPerColumnCombination(11);
            parameters.addBehaviours(behaviors);
            List<IRecommendedVisualization> recommendations = this.recommender.recommendWithPair(this.getAggregatedRecommendationModel(context), smartsModule, context.productLocale, datasetAndColumnIDPair, parameters);
            smartsResult = new SmartsResult(SmartsStatus.OK, recommendations);
        }
        catch (RecommendationException e) {
            LOGGER.error("Error generating visualization recommendations", (Throwable)e);
            smartsResult = new SmartsResult((Exception)e);
        }
        return smartsResult;
    }

    public IVisualizationRecommender getVisRecommender() {
        return this.recommender;
    }

    public Set<String> getSupportedCharts() {
        return this.recommender.getSupportedCharts();
    }
}

