/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.external.charts.extensions;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.generated.parser.ParseException;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.BindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnInfoException;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGUtils;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.ExternalChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.charts.Requirment;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartElements;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.internal.modeling.FeatureExtracter;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListChart
extends ExternalChartDescriptor {
    private static final String LISTCHART_NAME = "List";
    private static final String IDS_LIST_LABEL = "IDS_LIST_LABEL";
    private static final String IDS_LIST_TITLE = "IDS_LIST_TITLE";
    private static final String IDS_LIST_DESCRIPTION = "IDS_LIST_DESCRIPTION";
    private static final int MAX_OCCURENCES = 100;
    private static final String NLG_CODE = "strings.nlgRecommender";
    private static final String IDS_LBL_PLAIN = "IDS_LBL_PLAIN";
    private static final String IDS_TITLE_SIMPLE_SHOW = "IDS_TITLE_SIMPLE_SHOW";
    private static final String IDS_CHART_TYPE_PREFIX = "IDS_CHART_TYPE_";
    private static final List<ChartElement> listChartElements;

    public ListChart() {
        super(LISTCHART_NAME, IDS_LIST_LABEL, IDS_LIST_TITLE, IDS_LIST_DESCRIPTION, listChartElements, PreferenceLevel.HIGH, 0.0, 0.0, 0.0);
    }

    @Override
    public double getScore() {
        return this.getMinChartScore();
    }

    @Override
    public boolean acceptsNoneAggregation() {
        return true;
    }

    @Override
    public ExternalRecommendedVisualization recommend(String combinationId, List<IDataColumn> columns, List<Binding> constraints, VisualizationParameters parameters) {
        if (columns.size() > 100) {
            return null;
        }
        Locale locale = parameters != null && parameters.getRequestContext() != null ? parameters.getRequestContext().locale : null;
        List<Binding> bindings = columns.stream().map(col -> new Binding(Collections.singletonList(col.getIdForExpression()), StdChartElements.ANY.name())).collect(Collectors.toList());
        ExternalRecommendedVisualization recommendation = new ExternalRecommendedVisualization(this, bindings, this.getScore(), 0, combinationId);
        Set<String> measures = ListChart.measures(columns);
        ListChart.sort(measures, recommendation.getColumnBindings());
        if (ChartNLGUtils.NLGSupported(locale)) {
            Optional<ChartDescription> des = this.getDescription(columns, locale);
            if (des.isPresent()) {
                recommendation.setNaturalLanguage(des.get().getLabel(), des.get().getTitle(), des.get().getDescription(), locale);
            } else {
                this.generateNaturalLanguage(recommendation, this.extractFeaturesForDescription(columns), locale, columns);
            }
        } else {
            this.generateNaturalLanguage(recommendation, this.extractFeaturesForDescription(columns), locale, columns);
        }
        if (parameters != null) {
            recommendation.setBaseFilterList(parameters.getBaseFilterList());
            recommendation.setAggregationMap(parameters.getAggregationMap());
        }
        return recommendation;
    }

    @Override
    public List<IBindingResult> bind(Locale locale, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, List<IDataColumn> unboundColumns, boolean forceBinding) throws BindingException {
        List<String> invalidSlots = this.checkForInvalidSlots(bound);
        if (!invalidSlots.isEmpty()) {
            throw new BindingException("Slot does not exist: " + invalidSlots.get(0));
        }
        FeatureExtracter extracter = new FeatureExtracter(unboundColumns);
        try {
            EnumMap<BindingParams, Double> threshold = new EnumMap<BindingParams, Double>(BindingParams.class);
            extracter.extractFeatures(threshold, Function.identity(), true, Collections.emptyList(), true);
        }
        catch (InvalidColumnInfoException e) {
            throw new BindingException(String.format("Chart %s cannot bind %s", LISTCHART_NAME, unboundColumns));
        }
        int noOfAvailableSlots = 100 - bound.size();
        List<Object> toBeBoundFeatures = Collections.emptyList();
        if (noOfAvailableSlots > 0 && !extracter.getFeatures().isEmpty()) {
            toBeBoundFeatures = extracter.getFeatures().get(0);
            if (unboundColumns.size() > noOfAvailableSlots) {
                toBeBoundFeatures = toBeBoundFeatures.subList(0, noOfAvailableSlots);
            }
        }
        List<String> unboundableIdForExpressions = this.getUnboundableIdForExpressionList(toBeBoundFeatures.size(), unboundColumns);
        ArrayList<Binding> newAndOldBindings = new ArrayList<Binding>();
        newAndOldBindings.addAll(bound);
        newAndOldBindings.addAll(this.bindColumns(toBeBoundFeatures));
        List<IDataColumn> columns = Stream.concat(boundColumnInfo.values().stream(), unboundColumns.stream()).collect(Collectors.toList());
        Set<String> measures = ListChart.measures(columns);
        ListChart.sort(measures, newAndOldBindings);
        BindingResult bindingRes = new BindingResult(locale, LISTCHART_NAME, newAndOldBindings, unboundableIdForExpressions, 0, this.preference, false);
        if (ChartNLGUtils.NLGSupported(locale)) {
            Optional<ChartDescription> des = this.getDescription(columns, locale);
            if (des.isPresent()) {
                bindingRes.setNaturalLanguage(des.get().getLabel(), des.get().getTitle(), des.get().getDescription(), locale);
            } else {
                this.addNaturalLanguageToBinding(locale, columns, bindingRes);
            }
        } else {
            this.addNaturalLanguageToBinding(locale, columns, bindingRes);
        }
        return Arrays.asList(bindingRes);
    }

    private Optional<ChartDescription> getDescription(List<IDataColumn> columns, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(NLG_CODE, locale);
        Map<String, String> idToName = this.getMapColumnIdForExpresionToColumnName(columns);
        ArrayList<Object> lblParams = new ArrayList<Object>();
        ArrayList<Object> ttlParams = new ArrayList<Object>();
        ArrayList<String> titleChartName = new ArrayList<String>();
        titleChartName.add(bundle.getString(IDS_CHART_TYPE_PREFIX + this.getName()));
        ttlParams.add(titleChartName);
        ArrayList fieldNames = new ArrayList();
        columns.forEach(c -> fieldNames.add(idToName.get(c.getIdForExpression())));
        lblParams.add(fieldNames);
        ttlParams.add(fieldNames);
        String label = ChartNLGUtils.realiseNLG(bundle.getString(IDS_LBL_PLAIN), lblParams);
        String title = ChartNLGUtils.realiseNLG(bundle.getString(IDS_TITLE_SIMPLE_SHOW), ttlParams);
        String description = "";
        try {
            description = ChartNLGUtils.generateDescription(this.extractFeaturesForDescription(columns), this.getMapColumnIdForExpresionToColumnName(columns), bundle);
        }
        catch (ParseException e) {
            LOGGER.error("Parsing exception while creating description for list chart.");
            return Optional.empty();
        }
        return Optional.of(new ChartDescription(label, title, description, locale));
    }

    private static Set<String> measures(List<IDataColumn> columns) {
        return columns.stream().filter(c -> c.hasConcept(BasicType.MEASURE.getOntologyConcept())).map(c -> c.getIdForExpression()).collect(Collectors.toSet());
    }

    private static void sort(Set<String> measures, List<Binding> bindings) {
        bindings.sort(Comparator.comparingInt(b -> {
            String columnId = (String)b.getColumns().get(0);
            if (measures.contains(columnId)) {
                return 1;
            }
            return 0;
        }));
    }

    private List<ExtractedFeatureSet> extractFeaturesForDescription(List<IDataColumn> columns) {
        EnumMap<BindingParams, Double> bindingParams = new EnumMap<BindingParams, Double>(BindingParams.class);
        FeatureExtracter extracter = new FeatureExtracter(columns);
        try {
            extracter.extractFeatures(bindingParams, Function.identity(), true, Collections.emptyList(), true);
        }
        catch (InvalidColumnInfoException e) {
            LOGGER.error("Failed to extract features for chart description.", (Throwable)e);
            return Collections.emptyList();
        }
        List<List<ExtractedFeatureSet>> llFeatures = extracter.getFeatures();
        if (llFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        return llFeatures.get(0);
    }

    private List<String> checkForInvalidSlots(List<Binding> boundColumns) {
        List validSlots = listChartElements.stream().map(c -> c.getType().getSlot()).collect(Collectors.toList());
        return boundColumns.stream().map(Binding::getSlot).filter(s -> !validSlots.contains(s)).collect(Collectors.toList());
    }

    private List<String> getUnboundableIdForExpressionList(int noOfColumnsToBeBound, List<IDataColumn> unboundColumns) {
        List<String> unboundableIdForExpressions = Collections.emptyList();
        int numberOfUnbindableColumns = unboundColumns.size() - noOfColumnsToBeBound;
        if (numberOfUnbindableColumns > 0) {
            int startIndex = noOfColumnsToBeBound;
            int endIndex = unboundColumns.size();
            unboundableIdForExpressions = unboundColumns.subList(startIndex, endIndex).stream().map(column -> column.getIdForExpression()).collect(Collectors.toList());
        }
        return unboundableIdForExpressions;
    }

    @Override
    protected List<Binding> bindColumns(List<ExtractedFeatureSet> features) {
        ArrayList<Binding> bound = new ArrayList<Binding>();
        Function<ExtractedFeatureSet, Binding> getBinding = f -> {
            List<String> columns = Arrays.asList(f.getColumn().getIdForExpression());
            return new Binding(columns, StdChartElements.ANY.name(), f.getConcept(), f.getBindWarnings());
        };
        bound.addAll(features.stream().filter(f -> f.getColumn() != null).map(getBinding).filter(Objects::nonNull).collect(Collectors.toList()));
        return bound;
    }

    static {
        HashSet<Quantity> quantities = new HashSet<Quantity>();
        Collections.addAll(quantities, Quantity.NONE, Quantity.FEW, Quantity.MODERATE, Quantity.MANY);
        listChartElements = Arrays.asList(new ChartElement(StdChartElements.ANY.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 100));
    }
}

