/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.external.charts.extensions;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilterType;
import com.ibm.smarts.common.modifiers.TopBottomFilteringMethod;
import com.ibm.smarts.recommenders.core.utils.Pair;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.BindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnBindingException;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.BaseMultiMeasureSlotChart;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.FeatureType;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartDescriptionGenerator;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.schema.AutoGrouping;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.EXTRA_BEHAVIOR;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public abstract class MultiMeasureSlotColumn
extends BaseMultiMeasureSlotChart {
    protected static final long MAX_CATEGORIES = 1L;
    protected static final int MAX_DISTINCT_COUNT = 20;
    protected static final String CATEGORY_SLOT = "CATEGORY";
    protected static final String VALUE_SLOT = "VALUE";
    protected static final String COLOR_SLOT = "COLOR";
    protected static final int DEFAULT_AUTO_GROUPING_SIZE = 10;
    protected static final double MEASURE_SCALE_LIMIT = 0.7;
    private static final int DISTINCT_AGGREGATIONS_ALLOWED = 1;
    private double score;

    protected int getMaxCategoryDistinctCount() {
        return 20;
    }

    @Override
    public long getNumberOfChartsElements() {
        return 11L;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    protected abstract void updateRecommendationScore(ExternalRecommendedVisualization var1, Map<FeatureType, List<IDataColumn>> var2);

    protected MultiMeasureSlotColumn(String name, String labelId, String titleId, String descriptionId, List<ChartElement> elements) {
        super(name, labelId, titleId, descriptionId, elements, PreferenceLevel.HIGH);
    }

    @Override
    public boolean validateBindings(List<IDataColumn> columns, List<Binding> bindings) {
        return true;
    }

    protected boolean checkAggregationValuesAllMatch(List<IDataColumn> columns, Map<String, AggregationType> modifiedAggrMap) {
        if (columns == null || columns.isEmpty() || columns.stream().anyMatch(column -> column.getSemanticInfo() == null)) {
            return false;
        }
        return columns.stream().map(col -> VisRecommenderUtils.getAggregationForColumn(col, modifiedAggrMap)).distinct().count() == 1L;
    }

    protected Map<IDataColumn, List<Double>> getMinMaxValues(List<IDataColumn> colList) {
        return colList.stream().map(c -> new Pair((IDataColumn)c, c.getStatistics().stream().filter(s -> s.getType() == StatisticType.MAX_VALUE || s.getType() == StatisticType.MIN_VALUE).map(s -> {
            if (s.getValue() != null) {
                return s.getValue().doubleValue();
            }
            return 0.0;
        }).collect(Collectors.toList()))).collect(Collectors.toMap(p -> (IDataColumn)p.getLeft(), p -> (List)p.getRight(), (p1, p2) -> p1));
    }

    protected List<IDataColumn> findOutOfScaleColumns(Map<IDataColumn, List<Double>> minMaxValues) {
        double minValue;
        double maxValue = minMaxValues.entrySet().stream().map(e -> (List)e.getValue()).map(l -> l.stream().max(Double::compareTo).orElse(0.0)).max(Double::compareTo).orElse(0.0);
        if (maxValue == (minValue = minMaxValues.entrySet().stream().map(e -> (List)e.getValue()).map(l -> l.stream().min(Double::compareTo).orElse(0.0)).min(Double::compareTo).orElse(0.0).doubleValue()) || Math.abs(maxValue - minValue) <= 1.0 && Math.abs(minValue) > 1.0) {
            return Collections.emptyList();
        }
        List<IDataColumn> columns = minMaxValues.entrySet().stream().filter(e -> {
            if (((List)e.getValue()).size() == 2) {
                if (((Double)((List)e.getValue()).get(0)).equals(((List)e.getValue()).get(1))) {
                    return Math.abs(Math.log10(Math.abs((Double)((List)e.getValue()).get(0) / (maxValue - minValue)))) > 0.7;
                }
                return Math.abs(Math.log10(Math.abs((Double)((List)e.getValue()).get(0) - (Double)((List)e.getValue()).get(1)) / (maxValue - minValue))) > 0.7;
            }
            return false;
        }).map(e -> (IDataColumn)e.getKey()).collect(Collectors.toList());
        return columns;
    }

    private TopBottomFilter createTopBottomFilter(String columnId, List<IDataColumn> measures, List<IDataColumn> dual) {
        Optional<IDataColumn> primaryMeasure = measures.stream().filter(m -> m.isPrimary()).findFirst();
        if (!primaryMeasure.isPresent()) {
            primaryMeasure = dual.stream().filter(m -> m.isPrimary()).findFirst();
        }
        String byColumn = !primaryMeasure.isPresent() ? (!measures.isEmpty() ? measures.get(0).getIdForExpression() : dual.get(0).getIdForExpression()) : primaryMeasure.get().getIdForExpression();
        return new TopBottomFilter(columnId, null, null, TopBottomFilterType.TOP, TopBottomFilteringMethod.COUNT, byColumn, 10);
    }

    @Override
    public List<String> getSlots() {
        return Arrays.asList(CATEGORY_SLOT, VALUE_SLOT, COLOR_SLOT);
    }

    protected List<Binding> checkWrongBindings(List<Binding> bound) {
        return bound.stream().filter(b -> !b.getSlot().equals(CATEGORY_SLOT) && !b.getSlot().equals(VALUE_SLOT) && !b.getSlot().equals(COLOR_SLOT)).collect(Collectors.toList());
    }

    @Override
    public ExternalRecommendedVisualization recommend(String combinationId, List<IDataColumn> columns, List<Binding> constraints, VisualizationParameters parameters) {
        IDataColumn column;
        TopBottomFilter filter;
        Map<FeatureType, List<IDataColumn>> classifications = this.classifyColumns(columns);
        HashMap<String, AutoGrouping> autoAroupingMap = new HashMap<String, AutoGrouping>();
        ArrayList<TopBottomFilter> topBottomFilterList = new ArrayList<TopBottomFilter>();
        List entities = classifications.getOrDefault((Object)FeatureType.ENTITY, Collections.emptyList());
        List<IDataColumn> measures = classifications.getOrDefault((Object)FeatureType.MEASURE, Collections.emptyList());
        List<IDataColumn> duals = classifications.getOrDefault((Object)FeatureType.MIXED, Collections.emptyList());
        duals = duals.stream().sorted(Comparator.comparing(IDataColumn::getQuantity).thenComparing(IDataColumn::getId)).collect(Collectors.toList());
        List<IDataColumn> topBottomCandidateDuals = duals.stream().filter(d -> !UsageType.FACT.equals((Object)d.getUsageType()) && d.getQuantity() > this.getMaxCategoryDistinctCount() && !autoAroupingMap.containsKey(d.getIdForExpression())).collect(Collectors.toList());
        if (entities.isEmpty() && duals.isEmpty()) {
            if (!parameters.getBehaviors().contains(EXTRA_BEHAVIOR.ALLOW_AUTO_GROUPING)) {
                return null;
            }
            if ((long)measures.size() <= 2L) {
                return null;
            }
            Optional<IDataColumn> primary = measures.stream().filter(col -> col.isPrimary()).findFirst();
            if (primary.isPresent()) {
                IDataColumn primaryColumn = primary.get();
                entities = new ArrayList();
                entities.add(primaryColumn);
                classifications.put(FeatureType.ENTITY, entities);
                measures.remove(primaryColumn);
                autoAroupingMap.put(primaryColumn.getIdForExpression(), new AutoGrouping(10));
            } else {
                return null;
            }
        }
        if ((long)entities.size() > 1L) {
            return null;
        }
        if (entities.isEmpty() && duals.isEmpty()) {
            return null;
        }
        if (measures.isEmpty() && duals.isEmpty()) {
            return null;
        }
        if (!entities.isEmpty() && !autoAroupingMap.containsKey(((IDataColumn)entities.get(0)).getIdForExpression())) {
            if (((IDataColumn)entities.get(0)).getQuantity() > this.getMaxCategoryDistinctCount()) {
                filter = parameters.getColumnTopBottomFilterMap().get(((IDataColumn)entities.get(0)).getIdForExpression());
                if (filter != null) {
                    if (filter.getDomainSize() > this.getMaxCategoryDistinctCount() || filter.getByColumn() == null) {
                        return null;
                    }
                } else if (parameters.getColumnInclusionExclusionMap().get(((IDataColumn)entities.get(0)).getIdForExpression()) == null) {
                    if (!parameters.getBehaviors().contains(EXTRA_BEHAVIOR.ALLOW_TOP_BOTTOM_FILTER)) {
                        return null;
                    }
                    topBottomFilterList.add(this.createTopBottomFilter(((IDataColumn)entities.get(0)).getIdForExpression(), measures, duals));
                }
            }
        } else if (!topBottomCandidateDuals.isEmpty()) {
            filter = parameters.getColumnTopBottomFilterMap().get(((IDataColumn)topBottomCandidateDuals.get(0)).getIdForExpression());
            if (filter != null) {
                if (filter.getDomainSize() > this.getMaxCategoryDistinctCount() || filter.getByColumn() == null) {
                    return null;
                }
            } else if (parameters.getColumnInclusionExclusionMap().get(((IDataColumn)topBottomCandidateDuals.get(0)).getIdForExpression()) == null) {
                if (!parameters.getBehaviors().contains(EXTRA_BEHAVIOR.ALLOW_TOP_BOTTOM_FILTER)) {
                    return null;
                }
                topBottomFilterList.add(this.createTopBottomFilter(((IDataColumn)topBottomCandidateDuals.get(0)).getIdForExpression(), measures, topBottomCandidateDuals));
            }
        }
        if (measures.isEmpty() || (long)(measures.size() + duals.size() - 1 - entities.size()) > 10L) {
            return null;
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (!entities.isEmpty()) {
            column = (IDataColumn)entities.get(0);
            bindings.add(new Binding(Arrays.asList(column.getIdForExpression()), CATEGORY_SLOT));
        } else if (!topBottomCandidateDuals.isEmpty()) {
            column = (IDataColumn)topBottomCandidateDuals.remove(0);
            duals.remove(column);
            bindings.add(new Binding(Arrays.asList(column.getIdForExpression()), CATEGORY_SLOT));
        } else if (!duals.isEmpty()) {
            column = (IDataColumn)duals.remove(0);
            bindings.add(new Binding(Arrays.asList(column.getIdForExpression()), CATEGORY_SLOT));
        }
        if ((long)(duals.size() + measures.size()) < 2L) {
            return null;
        }
        duals.forEach(m -> bindings.add(new Binding(Arrays.asList(m.getIdForExpression()), VALUE_SLOT)));
        measures.forEach(m -> bindings.add(new Binding(Arrays.asList(m.getIdForExpression()), VALUE_SLOT)));
        if (!this.checkAggregationValuesAllMatch(measures, parameters.getAggregationMap())) {
            return null;
        }
        Map<IDataColumn, List<Double>> minMaxValues = this.getMinMaxValues(duals);
        minMaxValues.putAll(this.getMinMaxValues(measures));
        if (!this.findOutOfScaleColumns(minMaxValues).isEmpty()) {
            return null;
        }
        if (!this.validateBindings(columns, bindings)) {
            return null;
        }
        HashSet<String> flexibleSlotCapacitySet = new HashSet<String>();
        flexibleSlotCapacitySet.add(VALUE_SLOT);
        ExternalRecommendedVisualization recommendation = new ExternalRecommendedVisualization(this, bindings, this.getScore(), 0, combinationId, flexibleSlotCapacitySet);
        recommendation.setBaseFilterList(parameters.getBaseFilterList());
        recommendation.setAggregationMap(parameters.getAggregationMap());
        if (!autoAroupingMap.isEmpty()) {
            recommendation.setAutoGroupingMap(autoAroupingMap);
        }
        if (!topBottomFilterList.isEmpty()) {
            recommendation.getBaseFilterList().addAll(topBottomFilterList);
        }
        this.updateRecommendationScore(recommendation, classifications);
        if (recommendation.getScore() <= 0.0) {
            return null;
        }
        Locale locale = parameters != null && parameters.getRequestContext() != null ? parameters.getRequestContext().locale : null;
        this.setNaturalLanguageStrings(recommendation, bindings, columns, locale);
        return recommendation;
    }

    void setNaturalLanguageStrings(ExternalRecommendedVisualization recommendation, List<Binding> bindings, List<IDataColumn> columns, Locale locale) {
        Optional<ChartDescription> des = this.genericNLGGeneration(bindings, columns, locale);
        if (des.isPresent()) {
            recommendation.setNaturalLanguage(des.get().getLabel(), des.get().getTitle(), des.get().getDescription(), locale);
        } else if (locale != null) {
            Map<String, String> idToName = this.getMapColumnIdForExpresionToColumnName(columns);
            Map<String, List<String>> p = this.getParameters(recommendation.getColumnBindings(), idToName);
            p.putAll(ChartDescriptionGenerator.getSpecialParameters(recommendation.getColumnBindings(), idToName));
            recommendation.setNaturalLanguage(this.getLabel(p, locale), this.getTitle(p, locale), this.getDescription(p, locale), locale);
        }
    }

    @Override
    public List<IBindingResult> bind(Locale locale, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, List<IDataColumn> unboundColumns, boolean forceBinding) throws BindingException {
        BindingResult binding;
        long range;
        Map<FeatureType, List<IDataColumn>> classifications = this.classifyColumns(unboundColumns);
        ArrayList<Binding> bindings = new ArrayList<Binding>(bound);
        ArrayList<String> unboundColumnNames = new ArrayList<String>();
        List<IDataColumn> entities = classifications.getOrDefault((Object)FeatureType.ENTITY, Collections.emptyList()).stream().sorted(Comparator.comparing(IDataColumn::getQuantity)).collect(Collectors.toList());
        List<IDataColumn> measures = classifications.getOrDefault((Object)FeatureType.MEASURE, Collections.emptyList());
        List<IDataColumn> mixed = classifications.getOrDefault((Object)FeatureType.MIXED, Collections.emptyList()).stream().sorted(Comparator.comparing(IDataColumn::getQuantity)).collect(Collectors.toList());
        List<Binding> wrong = this.checkWrongBindings(bound);
        if (!wrong.isEmpty()) {
            throw new BindingException(new InvalidColumnBindingException(wrong));
        }
        if (bound.stream().noneMatch(b -> b.getSlot().equals(CATEGORY_SLOT))) {
            if (!entities.isEmpty()) {
                bindings.add(new Binding(this.getIdForExpression((IDataColumn)entities.remove(0)), CATEGORY_SLOT));
            } else if (!mixed.isEmpty()) {
                bindings.add(new Binding(this.getIdForExpression((IDataColumn)mixed.remove(0)), CATEGORY_SLOT));
            }
        }
        entities.forEach(e -> unboundColumnNames.add(e.getIdForExpression()));
        long roomForMeasures = 10L - bound.stream().filter(b -> b.getSlot().equals(VALUE_SLOT)).count();
        if (!measures.isEmpty()) {
            range = (long)measures.size() > roomForMeasures ? roomForMeasures : (long)measures.size();
            bindings.addAll(LongStream.range(0L, range).mapToObj(i -> new Binding(Arrays.asList(((IDataColumn)measures.remove(0)).getIdForExpression()), VALUE_SLOT)).collect(Collectors.toList()));
            measures.forEach(e -> unboundColumnNames.add(e.getIdForExpression()));
            roomForMeasures -= range;
        }
        if (!mixed.isEmpty()) {
            range = (long)mixed.size() > roomForMeasures ? roomForMeasures : (long)mixed.size();
            bindings.addAll(LongStream.range(0L, range).mapToObj(i -> new Binding(Arrays.asList(((IDataColumn)mixed.remove(0)).getIdForExpression()), VALUE_SLOT)).collect(Collectors.toList()));
            mixed.forEach(e -> unboundColumnNames.add(e.getIdForExpression()));
        }
        boolean isMandatorySlotsMissing = false;
        Map<Boolean, List<Binding>> partitioned = bindings.stream().collect(Collectors.partitioningBy(b -> b.getSlot().equals(CATEGORY_SLOT)));
        if (partitioned.getOrDefault(true, Collections.emptyList()).isEmpty() || partitioned.getOrDefault(false, Collections.emptyList()).isEmpty()) {
            isMandatorySlotsMissing = true;
        }
        if (!this.validateBindings(unboundColumns, (binding = new BindingResult(locale, this.getName(), bindings, unboundColumnNames, 0, this.preference, isMandatorySlotsMissing)).getBinding())) {
            return Collections.emptyList();
        }
        Stream<IDataColumn> boundColumns = boundColumnInfo.entrySet().stream().map(Map.Entry::getValue);
        List<IDataColumn> columns = Stream.concat(boundColumns, unboundColumns.stream()).collect(Collectors.toList());
        Optional<ChartDescription> des = this.genericNLGGeneration(bindings, columns, locale);
        if (des.isPresent()) {
            binding.setNaturalLanguage(des.get().getLabel(), des.get().getTitle(), des.get().getDescription(), locale);
        } else {
            this.addNaturalLanguageToBinding(locale, columns, binding);
        }
        return Arrays.asList(binding);
    }
}

