/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.external.charts.extensions;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.FeatureType;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.MultiMeasureSlotColumn;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.MultiMeasureChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.Requirment;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartElements;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class StackedArea
extends MultiMeasureSlotColumn {
    private static final String CHART_NAME = "StackedArea";
    protected static final double LOW_SCORE = 0.5;
    protected static final double HIGH_SCORE = 1.0;
    protected static final int MAX_DISTINCT_COUNT = 40;
    private static List<ChartElement> chartElements = Arrays.asList(new ChartElement(StdChartElements.CATEGORY.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new MultiMeasureChartElement(StdChartElements.VALUE.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.COLOR.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1));

    @Override
    protected int getMaxCategoryDistinctCount() {
        return 40;
    }

    public StackedArea() {
        super(CHART_NAME, "IDS_COMPARE_CATEGORY_LABEL", "IDS_AREA_CATEGORY_TITLE", null, chartElements);
    }

    @Override
    public String getName() {
        return CHART_NAME;
    }

    @Override
    public boolean validateBindings(List<IDataColumn> columns, List<Binding> bindings) {
        Map columnMap = columns.stream().collect(Collectors.toMap(IDataColumn::getIdForExpression, Function.identity(), (a, b) -> a));
        return bindings.stream().filter(b -> b.getSlot().equals("VALUE")).map(b -> (IDataColumn)columnMap.get(b.getColumns().get(0))).filter(Objects::nonNull).noneMatch(col -> col.isNullable());
    }

    @Override
    protected void updateRecommendationScore(ExternalRecommendedVisualization recommendation, Map<FeatureType, List<IDataColumn>> classifications) {
        List categoryList = classifications.getOrDefault((Object)FeatureType.ENTITY, classifications.getOrDefault((Object)FeatureType.MIXED, Collections.emptyList()));
        if (categoryList.isEmpty()) {
            recommendation.setScore(0.0);
        } else {
            Optional<List> categoryColId = recommendation.getColumnBindings().stream().filter(b -> b.getSlot().equals("CATEGORY")).map(Binding::getColumns).findFirst();
            if (!categoryColId.isPresent()) {
                recommendation.setScore(0.0);
            } else {
                Optional<IDataColumn> categoryCol = categoryList.stream().filter(c -> ((List)categoryColId.get()).contains(c.getIdForExpression())).findFirst();
                if (!categoryCol.isPresent()) {
                    recommendation.setScore(0.0);
                } else {
                    List concepts = categoryCol.get().getSemanticInfo() == null ? Collections.emptyList() : categoryCol.get().getSemanticInfo().getConcepts();
                    Predicate<ConceptInfo> isTemporal = ci -> {
                        Concept c = ConceptsRegistry.instance().getConcept(ci.getConceptID());
                        if (c == null) {
                            return false;
                        }
                        Set parents = c.getAncestors();
                        if (parents == null) {
                            return false;
                        }
                        return parents.stream().map(a -> a.toConceptInfo(ci.getConfidence())).filter(Objects::nonNull).anyMatch(m -> ConceptsUtil.getConceptName((ConceptInfo)m).equals("Temporal"));
                    };
                    if (concepts.stream().anyMatch(isTemporal)) {
                        recommendation.setScore(1.0);
                    } else {
                        recommendation.setScore(0.5);
                    }
                }
            }
        }
    }
}

