/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.visualization.recommender.api.IExternalChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.BaseRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.schema.AutoGrouping;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExternalRecommendedVisualization
extends BaseRecommendedVisualization {
    private IExternalChartDescriptor descriptor;
    private Set<String> flexibleSlotCapacitySet;
    private Map<String, AutoGrouping> autoGroupingMap = new HashMap<String, AutoGrouping>();
    private List<BaseFilter> baseFilterList = new ArrayList<BaseFilter>();
    private Map<String, AggregationType> aggregationMap = new HashMap<String, AggregationType>();

    public ExternalRecommendedVisualization(IExternalChartDescriptor descriptor, List<Binding> bindings, double score, int rank, String combinationId) {
        super(descriptor.getName(), score, rank, combinationId);
        this.setColumnBindings(bindings);
        this.descriptor = descriptor;
        this.flexibleSlotCapacitySet = Collections.emptySet();
    }

    public ExternalRecommendedVisualization(IExternalChartDescriptor descriptor, List<Binding> bindings, double score, int rank, String combinationId, Set<String> flexibleSlotCapacitySet) {
        this(descriptor, bindings, score, rank, combinationId);
        this.flexibleSlotCapacitySet = new HashSet<String>();
        this.flexibleSlotCapacitySet.addAll(flexibleSlotCapacitySet);
    }

    public ExternalRecommendedVisualization(ExternalRecommendedVisualization other, List<Binding> bindings, double score, int rank) {
        super(other, score, rank);
        this.descriptor = other.descriptor;
        this.columnBinding = bindings;
        this.baseFilterList.addAll(other.baseFilterList);
    }

    public ExternalRecommendedVisualization(ExternalRecommendedVisualization other, double score, int rank) {
        super(other, score, rank);
        this.descriptor = other.descriptor;
        this.baseFilterList.addAll(other.baseFilterList);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public IExternalChartDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Set<String> getFlexibleSlotCapacitySet() {
        return this.flexibleSlotCapacitySet;
    }

    @Override
    public void setNaturalLanguage(String label, String title, String description, Locale loc) {
        this.naturalLanguageLabel = label;
        this.naturalLanguageTitle = title;
        this.naturalLanguageDescription = description;
        this.locale = loc;
    }

    public void setAutoGroupingMap(Map<String, AutoGrouping> autoGroupingMap) {
        this.autoGroupingMap.putAll(autoGroupingMap);
    }

    public Map<String, AutoGrouping> getAutoGrouping() {
        return this.autoGroupingMap;
    }

    public Map<String, TopBottomFilter> getTopBottomFilters() {
        return VisRecommenderUtils.getFiltersTopBottomFilters(this.baseFilterList);
    }

    public Map<String, InclusionExclusionFilter> getInclusionExclusionFilters() {
        return VisRecommenderUtils.getFiltersInclusionExclusionFilters(this.baseFilterList);
    }

    public List<BaseFilter> getBaseFilterList() {
        return this.baseFilterList;
    }

    public void setBaseFilterList(List<BaseFilter> baseFilterList) {
        this.baseFilterList = baseFilterList;
    }

    public Map<String, AggregationType> getAggregationMap() {
        return this.aggregationMap;
    }

    public void setAggregationMap(Map<String, AggregationType> aggregationMap) {
        this.aggregationMap = aggregationMap;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalRecommendedVisualization)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalRecommendedVisualization that = (ExternalRecommendedVisualization)o;
        return Objects.equals(this.getDescriptor(), that.getDescriptor()) && Objects.equals(this.getFlexibleSlotCapacitySet(), that.getFlexibleSlotCapacitySet()) && Objects.equals(this.autoGroupingMap, that.autoGroupingMap) && Objects.equals(this.getBaseFilterList(), that.getBaseFilterList());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDescriptor(), this.getFlexibleSlotCapacitySet(), this.autoGroupingMap, this.getBaseFilterList());
    }
}

