/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.charts;

import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.charts.ChartElementFeatureMismatch;
import java.util.Set;

public class ChartElementFeatureSimilarity {
    private final int score;
    private final Set<ChartElementFeatureMismatch> mismatches;
    private final ExtractedFeatureSet feature;
    private final ChartElement element;

    ChartElementFeatureSimilarity(ChartElement element, ExtractedFeatureSet feature, Set<ChartElementFeatureMismatch> mismatches) {
        this.element = element;
        this.mismatches = mismatches;
        this.feature = feature;
        this.score = ChartElementFeatureMismatch.getMaxMatchScore() + mismatches.stream().mapToInt(ChartElementFeatureMismatch::getWeight).sum();
    }

    public int getScore() {
        return this.score;
    }

    public Set<ChartElementFeatureMismatch> getMismatches() {
        return this.mismatches;
    }

    public ExtractedFeatureSet getFeature() {
        return this.feature;
    }

    public ChartElement getElement() {
        return this.element;
    }
}

