/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.charts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import java.util.ArrayList;
import java.util.List;

public class ChartElementType {
    private final String name;
    private List<BasicType> types = new ArrayList<BasicType>();
    private String concept = "NONE";
    private final String slot;

    @JsonCreator
    public ChartElementType(@JsonProperty(value="name") String name, @JsonProperty(value="slot") String slot, @JsonProperty(value="types") List<BasicType> types, @JsonProperty(value="concept") String concept) {
        this.name = name;
        this.types.addAll(types);
        this.slot = slot != null ? slot : name;
        if (concept != null) {
            this.concept = concept;
        }
    }

    public static boolean isValid(ChartElementType elementType) {
        String name = elementType.getName();
        List<BasicType> types = elementType.getTypes();
        return name != null && !name.isEmpty() && types != null && !types.isEmpty();
    }

    public ChartElementType(String name, String slot, List<BasicType> types) {
        this.name = name;
        this.types = types;
        this.slot = slot;
    }

    public String getName() {
        return this.name;
    }

    public String getSlot() {
        return this.slot;
    }

    public List<BasicType> getTypes() {
        return this.types;
    }

    public String getConcept() {
        return this.concept;
    }

    public String toString() {
        return " name=" + this.name + " slot=" + this.slot + " concept=" + this.concept + " types=" + this.types;
    }
}

