/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.charts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ChartNLGProp {
    private String text;
    private List<ChartNlgParam> parameters;

    @JsonCreator
    public ChartNLGProp(@JsonProperty(value="text") String code_text, @JsonProperty(value="parameters") List<String> params) {
        this.text = code_text;
        if (params != null) {
            this.parameters = params.stream().map(p -> {
                if (p.indexOf(",") >= 0) {
                    return new ChartNlgParam((String)p, p.split(","), ",");
                }
                if (p.indexOf("|") >= 0) {
                    return new ChartNlgParam((String)p, p.split("\\|"), "|");
                }
                return new ChartNlgParam((String)p, new String[]{p}, "");
            }).collect(Collectors.toList());
        }
    }

    public String getText() {
        return this.text;
    }

    public List<String> getParameters() {
        return this.parameters.stream().map(p -> p.param).collect(Collectors.toList());
    }

    public List<List<String>> getParameters(Map<String, List<String>> values) {
        return this.parameters.stream().map(p -> p.getParameters(values)).collect(Collectors.toList());
    }

    private static class ChartNlgParam {
        String param;
        List<String> parsedParams;
        String separator;

        ChartNlgParam(String param, String[] parsedParams, String separator) {
            this.param = param;
            this.parsedParams = Arrays.asList(parsedParams);
            this.separator = separator;
        }

        List<String> getParameters(Map<String, List<String>> values) {
            switch (this.separator) {
                case ",": {
                    return this.parsedParams.stream().map(parsedParam -> (List)values.get(parsedParam)).filter(Objects::nonNull).flatMap(l -> l.stream()).collect(Collectors.toList());
                }
                case "|": {
                    return this.parsedParams.stream().map(parsedParam -> (List)values.get(parsedParam)).filter(Objects::nonNull).findFirst().orElse(Collections.emptyList());
                }
            }
            List<String> value = values.get(this.param);
            if (value != null) {
                return value;
            }
            return Arrays.asList(this.param);
        }
    }
}

