/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.learning;

public class Recommendation<T>
implements Comparable<Recommendation<T>> {
    private T item;
    private double score;

    public Recommendation(T item, double score) {
        this.item = item;
        this.score = score;
    }

    public T getItem() {
        return this.item;
    }

    public void setItem(T item) {
        this.item = item;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public int compareTo(Recommendation<T> o) {
        int comparison = Double.compare(o.getScore(), this.score);
        if (comparison == 0) {
            return 0;
        }
        if (comparison > 0) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return "Recommendation [item=" + this.item + ", score=" + this.score + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
            return false;
        }
        return Double.doubleToLongBits(this.score) == Double.doubleToLongBits(other.score);
    }
}

