/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.learning;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class RecommenderUtil {
    public static final double DEFAULT_MIN_CONTEXT_SIMILARITY = 0.89;

    private RecommenderUtil() {
    }

    public static double cosineSimilarity(List<Double> v1, List<Double> v2) {
        if (v1.size() != v2.size()) {
            return 0.0;
        }
        double dotProduct = IntStream.range(0, v1.size()).mapToDouble(i -> (Double)v1.get(i) * (Double)v2.get(i)).reduce(0.0, Double::sum);
        Function<Stream, Double> magnitude = v -> v.map(f -> f * f).reduce(0.0, Double::sum);
        return dotProduct / (magnitude.apply(v1.stream()) + magnitude.apply(v2.stream()) - dotProduct);
    }

    public static double euclideanDistanceSimilarity(List<Double> v1, List<Double> v2) {
        return 1.0 / (1.0 + Math.sqrt(IntStream.range(0, v1.size()).mapToDouble(i -> ((Double)v2.get(i) - (Double)v1.get(i)) * ((Double)v2.get(i) - (Double)v1.get(i))).reduce(0.0, Double::sum)));
    }

    public static List<Double> normalizeVector(List<Double> in) {
        double norm = Math.sqrt(in.stream().map(x -> x * x).reduce(0.0, Double::sum));
        return in.stream().map(x -> x / norm).collect(Collectors.toList());
    }

    public static List<Double> scaleVector(List<Double> vector, double scale) {
        return vector.stream().map(f -> f * scale).collect(Collectors.toList());
    }
}

