/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.modeling;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.internal.modeling.AxisType;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class FeatureBinding {
    private List<ExtractedFeatureSet> axes = new ArrayList<ExtractedFeatureSet>();
    private List<IDataColumn> combination;

    public FeatureBinding() {
        this.reset();
    }

    public FeatureBinding(List<IDataColumn> combination) {
        this();
        this.combination = combination;
    }

    public void bindFeatureSet(ExtractedFeatureSet feature, AxisType axis) {
        feature.setAxis(axis);
        this.axes.set(axis.getPosition(), feature);
    }

    public FeatureBinding(FeatureBinding other) {
        this.axes.addAll(other.axes.stream().map(ExtractedFeatureSet::new).collect(Collectors.toList()));
        this.combination = other.combination;
    }

    public List<String> buildFeatureVector() {
        return this.axes.stream().flatMap(a -> a.toVector().stream()).collect(Collectors.toList());
    }

    void reset() {
        this.axes.clear();
        ExtractedFeatureSet xDefault = new ExtractedFeatureSet(AxisType.X);
        ExtractedFeatureSet yDefault = new ExtractedFeatureSet(AxisType.Y);
        ExtractedFeatureSet seriesDefault = new ExtractedFeatureSet(AxisType.SERIES);
        ExtractedFeatureSet sizeDefault = new ExtractedFeatureSet(AxisType.SIZE);
        Collections.addAll(this.axes, xDefault, yDefault, seriesDefault, sizeDefault);
    }

    public List<IDataColumn> getCombination() {
        return this.combination;
    }

    public List<String> getCombinationIDs() {
        return this.combination.stream().map(IDataColumn::getName).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureBinding other = (FeatureBinding)obj;
        if (this.axes == null ? other.axes != null : !this.axes.equals(other.axes)) {
            return false;
        }
        return !(this.combination == null ? other.combination != null : !this.combination.equals(other.combination));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.axes == null ? 0 : this.axes.hashCode());
        result = 31 * result + (this.combination == null ? 0 : this.combination.hashCode());
        return result;
    }

    public List<ExtractedFeatureSet> getFeatureSets() {
        return this.axes.stream().filter(a -> a.getFeatureType() != BasicType.NONE).collect(Collectors.toList());
    }

    public String toString() {
        return "FeatureBinding [axes=" + this.axes + ", combination=" + this.combination + "]";
    }
}

