/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.pipeline;

import com.ibm.smarts.recommenders.core.utils.Pair;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.internal.RecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartProcessor;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class NoneAggregationFilter
implements ChartProcessor {
    @Override
    public Pair<Stream<RecommendedVisualization>, VisualizationParameters> apply(Pair<Stream<RecommendedVisualization>, VisualizationParameters> pair) {
        Predicate<RecommendedVisualization> validateChartForNoneAggregation = rec -> {
            boolean keepChart = true;
            boolean measureFeatureWithNoneAggr = rec.getFeatures().stream().filter(f -> f.getFeatureType().equals((Object)BasicType.MEASURE)).anyMatch(f -> VisRecommenderUtils.getAggregationForColumn(f.getColumn(), rec.getAggregationMap()).equals((Object)AggregationType.NONE));
            if (measureFeatureWithNoneAggr && !rec.getChartDescriptor().getHighLevelDescriptor().acceptsNoneAggregation()) {
                keepChart = false;
            }
            return keepChart;
        };
        return new Pair<Stream<RecommendedVisualization>, VisualizationParameters>(pair.getLeft().filter(validateChartForNoneAggregation), pair.getRight());
    }
}

