/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.pipeline;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.recommenders.core.utils.Pair;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.InfluencerTuningParams;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.internal.RecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartProcessor;
import java.util.stream.Stream;

public class PredictChartFilter
implements ChartProcessor {
    InterestingFieldsRecommender fieldRecommender = null;

    public PredictChartFilter(InterestingFieldsRecommender fieldRecommender) {
        this.fieldRecommender = fieldRecommender;
    }

    private boolean isInfluencersAbsent(RecommendedVisualization chart, RequestContext rc, SmartsModule sm) {
        if (this.fieldRecommender != null && chart.getChartDescriptor().getHighLevelDescriptor().isPredictive() && chart.getFeatures().size() == 1) {
            String targetFieldIDForExpression = chart.getFeatures().get(0).getColumnId();
            InfluencerTuningParams tuningParams = new InfluencerTuningParams();
            tuningParams.setNoCorrelationLimit(Boolean.valueOf(true));
            tuningParams.setAllowCategoryTarget(Boolean.valueOf(true));
            FieldsRecommendation rec = this.fieldRecommender.recommendInfluencers(rc, sm, targetFieldIDForExpression, null, tuningParams);
            return rec == null || rec.getRecommendedFields().isEmpty();
        }
        return false;
    }

    @Override
    public Pair<Stream<RecommendedVisualization>, VisualizationParameters> apply(Pair<Stream<RecommendedVisualization>, VisualizationParameters> arg0) {
        Stream<RecommendedVisualization> classifications = arg0.getLeft();
        VisualizationParameters visParams = arg0.getRight();
        return new Pair<Stream<RecommendedVisualization>, VisualizationParameters>(classifications.filter(c -> !this.isInfluencersAbsent((RecommendedVisualization)c, visParams.getRequestContext(), visParams.getSmartsModule())), visParams);
    }
}

