/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.client.simple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.core.rest.client.util.IRestClientConfigInfo;
import com.ibm.smarts.core.util.ToString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SimpleRestClientConfigInfo
implements IRestClientConfigInfo<SimpleRestClientConfigInfo> {
    public final String context;
    public final String scheme;
    public final String server;
    public final int port;
    public final Map<String, List<String>> headers;

    @JsonCreator
    public SimpleRestClientConfigInfo(@JsonProperty(value="context") String context, @JsonProperty(value="scheme") String scheme, @JsonProperty(value="host") String server, @JsonProperty(value="port") int port, @JsonProperty(value="headers") Map<String, List<String>> headers) {
        this.context = context;
        this.scheme = scheme;
        this.server = server;
        this.port = port;
        this.headers = headers;
    }

    public String toString() {
        return ToString.with((Object)this).field("scheme", (Object)this.scheme).field("server", (Object)this.server).field("port", (Object)this.port).field("context", (Object)this.context).get();
    }

    @Override
    public SimpleRestClientConfigInfo withHeaders(Map<String, List<String>> headers) {
        return new SimpleRestClientConfigInfo(this.context, this.scheme, this.server, this.port, headers);
    }

    @Override
    public SimpleRestClientConfigInfo withAddedHeader(String name, String value) {
        Map<String, List<String>> newHeaders = this.copy(this.headers);
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        newHeaders.put(name, new ArrayList());
        return new SimpleRestClientConfigInfo(this.context, this.scheme, this.server, this.port, newHeaders);
    }

    public static SimpleRestClientConfigInfo from(HttpServletRequest sr) {
        String context = sr.getContextPath().substring(1);
        String scheme = sr.getScheme();
        String server = sr.getLocalName();
        int port = sr.getLocalPort();
        Map<String, List<String>> headers = null;
        SimpleRestClientConfigInfo ret = new SimpleRestClientConfigInfo(context, scheme, server, port, headers);
        return ret;
    }

    public static SimpleRestClientConfigInfo getDefault() {
        String context = "bi/v1";
        String scheme = "http";
        String server = "localhost";
        int port = 9300;
        Object headers = null;
        SimpleRestClientConfigInfo ret = new SimpleRestClientConfigInfo("bi/v1", "http", "localhost", 9300, null);
        return ret;
    }
}

